/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.console.MessageConsolePartition;
import org.eclipse.ui.internal.console.MessageConsolePartitioner;

public class MessageConsoleViewer
extends TextViewer
implements LineStyleListener {
    protected InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();

    public MessageConsoleViewer(Composite parent) {
        super(parent, MessageConsoleViewer.getSWTStyles());
        this.getTextWidget().setDoubleClickEnabled(true);
        this.getTextWidget().setFont(parent.getFont());
        this.getTextWidget().addLineStyleListener((LineStyleListener)this);
        this.getTextWidget().setEditable(false);
    }

    private static int getSWTStyles() {
        int styles = 768;
        return styles;
    }

    protected void revealEndOfDocument() {
        IDocument doc = this.getDocument();
        int lines = doc.getNumberOfLines();
        try {
            int lineEndOffset;
            int lineStartOffset = doc.getLineOffset(lines - 1);
            StyledText widget = this.getTextWidget();
            if (lineStartOffset > 0) {
                widget.setCaretOffset(lineStartOffset);
                widget.showSelection();
            }
            if ((lineEndOffset = lineStartOffset + doc.getLineLength(lines - 1)) > 0) {
                widget.setCaretOffset(lineEndOffset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setDocument(IDocument doc) {
        IDocument oldDoc = this.getDocument();
        IDocument document = doc;
        if (oldDoc == null && document == null) {
            return;
        }
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this.fInternalDocumentListener);
            if (oldDoc.equals(document)) {
                document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
                return;
            }
        }
        super.setDocument(document);
        if (document != null) {
            this.revealEndOfDocument();
            document.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
        }
    }

    protected boolean canPerformFind() {
        return this.getTextWidget() != null && this.getVisibleDocument() != null && this.getVisibleDocument().getLength() > 0;
    }

    public void dispose() {
    }

    public void lineGetStyle(LineStyleEvent event) {
        MessageConsolePartitioner partitioner;
        IDocument document = this.getDocument();
        if (document != null && (partitioner = (MessageConsolePartitioner)document.getDocumentPartitioner()) != null) {
            ITypedRegion[] regions = partitioner.computePartitioning(event.lineOffset, event.lineOffset + event.lineText.length());
            StyleRange[] styles = new StyleRange[regions.length];
            for (int i = 0; i < regions.length; ++i) {
                MessageConsolePartition partition = (MessageConsolePartition)regions[i];
                Color color = partition.getStream().getColor();
                styles[i] = new StyleRange(partition.getOffset(), partition.getLength(), color, null);
            }
            event.styles = styles;
        }
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            MessageConsoleViewer.this.revealEndOfDocument();
        }
    }
}

