/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.ComboSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.PullPushCheckboxTableViewer;
import org.eclipse.jdt.internal.ui.refactoring.PullUpTreeViewer;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class PullUpWizard
extends RefactoringWizard {
    public PullUpWizard(PullUpRefactoring ref) {
        super((Refactoring)ref, 2);
        this.setDefaultPageTitle(RefactoringMessages.getString("PullUpWizard.defaultPageTitle"));
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR_PULL_UP);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new PullUpInputPage1());
        this.addPage((IWizardPage)new PullUpInputPage2());
    }

    private static class PullUpInputPage2
    extends UserInputWizardPage {
        private Label fTypeHierarchyLabel;
        private SourceViewer fSourceViewer;
        private PullUpTreeViewer fTreeViewer;
        public static final String PAGE_NAME = "PullUpMethodsInputPage2";

        public PullUpInputPage2() {
            super(PAGE_NAME);
            this.setMessage(RefactoringMessages.getString("PullUpInputPage.select_methods"));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createTreeAndSourceViewer(composite);
            this.createButtonComposite(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.pull_up_wizard_page_context");
        }

        private void createButtonComposite(Composite superComposite) {
            Composite buttonComposite = new Composite(superComposite, 0);
            buttonComposite.setLayoutData((Object)new GridData());
            GridLayout bcl = new GridLayout();
            bcl.numColumns = 2;
            bcl.marginWidth = 1;
            buttonComposite.setLayout((Layout)bcl);
            Button button = new Button(buttonComposite, 8);
            button.setText(RefactoringMessages.getString("PullUpInputPage2.Select"));
            button.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ PullUpInputPage2 this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$0.checkPulledUp();
                    PullUpInputPage2.access$1100(this.this$0);
                }
            });
        }

        public void checkPulledUp() {
            this.uncheckAll();
            this.fTreeViewer.setCheckedElements(this.getPullUpMethodsRefactoring().getMembersToPullUp());
            IType parent = this.getPullUpMethodsRefactoring().getDeclaringType();
            this.fTreeViewer.setChecked(parent, true);
            this.checkAllParents(parent);
        }

        private void checkAllParents(IType parent) {
            ITypeHierarchy th = this.getTreeViewerInput();
            IType root = this.getTreeViewerInputRoot();
            IType type = parent;
            while (!root.equals(type)) {
                this.fTreeViewer.setChecked(type, true);
                type = th.getSuperclass(type);
            }
            this.fTreeViewer.setChecked(root, true);
        }

        private void uncheckAll() {
            IType root = this.getTreeViewerInputRoot();
            this.fTreeViewer.setSubtreeChecked(root, false);
            this.fTreeViewer.setSubtreeGrayed(root, false);
        }

        private IType getTreeViewerInputRoot() {
            return this.getTreeViewerInput().getType();
        }

        private ITypeHierarchy getTreeViewerInput() {
            return (ITypeHierarchy)this.fTreeViewer.getInput();
        }

        private void updateTypeHierarchyLabel() {
            String message = RefactoringMessages.getFormattedString("PullUpInputPage.hierarchyLabal", new Integer(this.getCheckedMethods().length).toString());
            this.setMessage(message, 1);
        }

        private void createTreeAndSourceViewer(Composite superComposite) {
            SashForm composite = new SashForm(superComposite, 256);
            this.initializeDialogUnits((Control)superComposite);
            GridData gd = new GridData(1808);
            gd.heightHint = this.convertHeightInCharsToPixels(20);
            gd.widthHint = this.convertWidthInCharsToPixels(10);
            composite.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 1;
            layout.verticalSpacing = 1;
            composite.setLayout((Layout)layout);
            this.createHierarchyTreeComposite((Composite)composite);
            this.createSourceViewerComposite((Composite)composite);
            composite.setWeights(new int[]{50, 50});
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.initializeTreeViewer();
                this.setHierarchyLabelText();
            }
            super.setVisible(visible);
        }

        private void initializeTreeViewer() {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(this){
                    private final /* synthetic */ PullUpInputPage2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(IProgressMonitor pm) {
                        try {
                            PullUpInputPage2.access$1200(this.this$0, pm);
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("PullUpInputPage.pull_Up"), RefactoringMessages.getString("PullUpInputPage.exception"));
            }
            catch (InterruptedException e) {
                Assert.isTrue(false);
            }
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        private void initializeRefactoring() {
            this.getPullUpMethodsRefactoring().setMethodsToDelete(this.getCheckedMethods());
        }

        private IMethod[] getCheckedMethods() {
            Object[] checked = this.fTreeViewer.getCheckedElements();
            ArrayList<Object> members = new ArrayList<Object>(checked.length);
            for (int i = 0; i < checked.length; ++i) {
                if (!(checked[i] instanceof IMethod)) continue;
                members.add(checked[i]);
            }
            return members.toArray(new IMethod[members.size()]);
        }

        private void createSourceViewerComposite(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 1;
            layout.verticalSpacing = 1;
            c.setLayout((Layout)layout);
            this.createSourceViewerLabel(c);
            this.createSourceViewer(c);
        }

        private void createSourceViewer(Composite c) {
            IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
            this.fSourceViewer = new JavaSourceViewer(c, null, null, false, 68354, store);
            this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(PullUpInputPage2.getJavaTextTools().getColorManager(), store, null, null));
            this.fSourceViewer.setEditable(false);
            this.fSourceViewer.getControl().setLayoutData((Object)new GridData(1808));
            this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        }

        private void createSourceViewerLabel(Composite c) {
            Label label = new Label(c, 64);
            GridData gd = new GridData(768);
            label.setText(RefactoringMessages.getString("PullUpInputPage2.Source"));
            label.setLayoutData((Object)gd);
        }

        private void createHierarchyTreeComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 1;
            layout.verticalSpacing = 1;
            composite.setLayout((Layout)layout);
            this.createTypeHierarchyLabel(composite);
            this.createTreeViewer(composite);
        }

        private void createTypeHierarchyLabel(Composite composite) {
            this.fTypeHierarchyLabel = new Label(composite, 64);
            GridData gd = new GridData(768);
            this.fTypeHierarchyLabel.setLayoutData((Object)gd);
        }

        private void setHierarchyLabelText() {
            String message = RefactoringMessages.getFormattedString("PullUpInputPage.subtypes", this.getSupertypeSignature());
            this.fTypeHierarchyLabel.setText(message);
        }

        private String getSupertypeSignature() {
            return JavaElementUtil.createSignature((IMember)this.getPullUpMethodsRefactoring().getTargetClass());
        }

        private void createTreeViewer(Composite composite) {
            Tree tree = new Tree(composite, 2850);
            tree.setLayoutData((Object)new GridData(1808));
            this.fTreeViewer = new PullUpTreeViewer(tree);
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
            this.fTreeViewer.setUseHashlookup(true);
            this.fTreeViewer.setSorter(new JavaElementSorter());
            this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                private final /* synthetic */ PullUpInputPage2 this$0;
                {
                    this.this$0 = this$0;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    PullUpInputPage2.access$1300(this.this$0, event);
                }
            });
            this.fTreeViewer.addCheckStateListener(new ICheckStateListener(this){
                private final /* synthetic */ PullUpInputPage2 this$0;
                {
                    this.this$0 = this$0;
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    PullUpInputPage2.access$1100(this.this$0);
                }
            });
        }

        private void precheckElements(PullUpTreeViewer treeViewer) {
            IMember[] members = this.getPullUpMethodsRefactoring().getMembersToPullUp();
            for (int i = 0; i < members.length; ++i) {
                treeViewer.setCheckState(members[i], true);
            }
        }

        private void initializeTreeViewer(IProgressMonitor pm) {
            try {
                IMember[] matchingMethods = this.getPullUpMethodsRefactoring().getMatchingElements((IProgressMonitor)new SubProgressMonitor(pm, 1), false);
                ITypeHierarchy hierarchy = this.getPullUpMethodsRefactoring().getTypeHierarchyOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1));
                this.removeAllTreeViewFilters();
                this.fTreeViewer.addFilter(new PullUpFilter(hierarchy, matchingMethods));
                this.fTreeViewer.setContentProvider((IContentProvider)new PullUpHierarchyContentProvider(this.getPullUpMethodsRefactoring().getDeclaringType(), matchingMethods));
                this.fTreeViewer.setInput(hierarchy);
                this.precheckElements(this.fTreeViewer);
                this.fTreeViewer.expandAll();
                this.updateTypeHierarchyLabel();
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("PullUpInputPage.pull_up1"), RefactoringMessages.getString("PullUpInputPage.exception"));
                this.fTreeViewer.setInput(null);
            }
        }

        private void removeAllTreeViewFilters() {
            ViewerFilter[] filters = this.fTreeViewer.getFilters();
            for (int i = 0; i < filters.length; ++i) {
                this.fTreeViewer.removeFilter(filters[i]);
            }
        }

        private void treeViewerSelectionChanged(SelectionChangedEvent event) {
            try {
                this.showInSourceViewer(this.getFirstSelectedSourceReference(event));
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("PullUpInputPage.pull_up1"), RefactoringMessages.getString("PullUpInputPage.see_log"));
            }
        }

        private ISourceReference getFirstSelectedSourceReference(SelectionChangedEvent event) {
            ISelection s = event.getSelection();
            if (!(s instanceof IStructuredSelection)) {
                return null;
            }
            IStructuredSelection ss = (IStructuredSelection)s;
            if (ss.size() != 1) {
                return null;
            }
            Object first = ss.getFirstElement();
            if (!(first instanceof ISourceReference)) {
                return null;
            }
            return (ISourceReference)first;
        }

        private void setSourceViewerContents(String contents) {
            Document document = contents == null ? new Document() : new Document(contents);
            PullUpInputPage2.getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
            this.fSourceViewer.setDocument((IDocument)document);
        }

        private void showInSourceViewer(ISourceReference selected) throws JavaModelException {
            if (selected == null) {
                this.setSourceViewerContents(null);
            } else {
                this.setSourceViewerContents(selected.getSource());
            }
        }

        private static JavaTextTools getJavaTextTools() {
            return JavaPlugin.getDefault().getJavaTextTools();
        }

        private static Map createTypeToMemberArrayMapping(IMember[] members) {
            Map typeToMemberSet = PullUpInputPage2.createTypeToMemberSetMapping(members);
            HashMap<IType, IMember[]> typeToMemberArray = new HashMap<IType, IMember[]>();
            Iterator iter = typeToMemberSet.keySet().iterator();
            while (iter.hasNext()) {
                IType type = (IType)iter.next();
                Set memberSet = (Set)typeToMemberSet.get(type);
                IMember[] memberArray = memberSet.toArray(new IMember[memberSet.size()]);
                typeToMemberArray.put(type, memberArray);
            }
            return typeToMemberArray;
        }

        private static Map createTypeToMemberSetMapping(IMember[] members) {
            HashMap typeToMemberSet = new HashMap();
            for (int i = 0; i < members.length; ++i) {
                IMember member = members[i];
                IType type = member.getDeclaringType();
                if (!typeToMemberSet.containsKey(type)) {
                    typeToMemberSet.put(type, new HashSet());
                }
                ((Set)typeToMemberSet.get(type)).add(member);
            }
            return typeToMemberSet;
        }

        private PullUpRefactoring getPullUpMethodsRefactoring() {
            return (PullUpRefactoring)this.getRefactoring();
        }

        static /* synthetic */ void access$1100(PullUpInputPage2 x0) {
            x0.updateTypeHierarchyLabel();
        }

        static /* synthetic */ void access$1200(PullUpInputPage2 x0, IProgressMonitor x1) {
            x0.initializeTreeViewer(x1);
        }

        static /* synthetic */ void access$1300(PullUpInputPage2 x0, SelectionChangedEvent x1) {
            x0.treeViewerSelectionChanged(x1);
        }

        private static class PullUpHierarchyContentProvider
        implements ITreeContentProvider {
            private ITypeHierarchy fHierarchy;
            private Map fTypeToMemberArray;
            private IType fDeclaringType;

            PullUpHierarchyContentProvider(IType declaringType, IMember[] members) {
                this.fDeclaringType = declaringType;
                this.fTypeToMemberArray = PullUpInputPage2.createTypeToMemberArrayMapping(members);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IType) {
                    return this.getSubclassesAndMembers((IType)parentElement);
                }
                return new Object[0];
            }

            private Object[] getSubclassesAndMembers(IType type) {
                HashSet<Object> set = new HashSet<Object>();
                set.addAll(Arrays.asList(this.getSubclasses(type)));
                set.addAll(Arrays.asList(this.getMembers(type)));
                return set.toArray();
            }

            private IType[] getSubclasses(IType type) {
                if (type.equals(this.fDeclaringType)) {
                    return new IType[0];
                }
                return this.fHierarchy.getSubclasses(type);
            }

            private IMember[] getMembers(IType type) {
                if (this.fTypeToMemberArray.containsKey(type)) {
                    return (IMember[])this.fTypeToMemberArray.get(type);
                }
                return new IMember[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IType) {
                    return this.fHierarchy.getSuperclass((IType)element);
                }
                if (element instanceof IMember) {
                    return ((IMember)element).getDeclaringType();
                }
                Assert.isTrue(false, "Should not get here");
                return null;
            }

            public boolean hasChildren(Object element) {
                if (!(element instanceof IType)) {
                    return false;
                }
                IType type = (IType)element;
                return this.hasSubtypes(type) || this.hasMembers(type);
            }

            private boolean hasSubtypes(IType type) {
                return this.fHierarchy.getAllSubtypes(type).length > 0;
            }

            private boolean hasMembers(IType type) {
                return this.fTypeToMemberArray.containsKey(type);
            }

            public Object[] getElements(Object inputElement) {
                Assert.isTrue(inputElement == null || inputElement instanceof ITypeHierarchy);
                return new IType[]{this.fHierarchy.getType()};
            }

            public void dispose() {
                this.fHierarchy = null;
                this.fTypeToMemberArray.clear();
                this.fTypeToMemberArray = null;
                this.fDeclaringType = null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                Assert.isTrue(newInput == null || newInput instanceof ITypeHierarchy);
                this.fHierarchy = (ITypeHierarchy)newInput;
            }
        }

        private static class PullUpFilter
        extends ViewerFilter {
            private final Set fTypesToShow;

            PullUpFilter(ITypeHierarchy hierarchy, IMember[] members) {
                Map typeToMemberArray = PullUpInputPage2.createTypeToMemberArrayMapping(members);
                this.fTypesToShow = PullUpFilter.computeTypesToShow(hierarchy, typeToMemberArray);
            }

            private static Set computeTypesToShow(ITypeHierarchy hierarchy, Map typeToMemberArray) {
                HashSet<IType> typesToShow = new HashSet<IType>();
                typesToShow.add(hierarchy.getType());
                typesToShow.addAll(PullUpFilter.computeShowableSubtypesOfMainType(hierarchy, typeToMemberArray));
                return typesToShow;
            }

            private static Set computeShowableSubtypesOfMainType(ITypeHierarchy hierarchy, Map typeToMemberArray) {
                HashSet<IType> result = new HashSet<IType>();
                IType[] subtypes = hierarchy.getAllSubtypes(hierarchy.getType());
                for (int i = 0; i < subtypes.length; ++i) {
                    IType subtype = subtypes[i];
                    if (!PullUpFilter.canBeShown(subtype, typeToMemberArray, hierarchy)) continue;
                    result.add(subtype);
                }
                return result;
            }

            private static boolean canBeShown(IType type, Map typeToMemberArray, ITypeHierarchy hierarchy) {
                if (typeToMemberArray.containsKey(type)) {
                    return true;
                }
                return PullUpFilter.anySubtypeCanBeShown(type, typeToMemberArray, hierarchy);
            }

            private static boolean anySubtypeCanBeShown(IType type, Map typeToMemberArray, ITypeHierarchy hierarchy) {
                IType[] subTypes = hierarchy.getSubtypes(type);
                for (int i = 0; i < subTypes.length; ++i) {
                    if (!PullUpFilter.canBeShown(subTypes[i], typeToMemberArray, hierarchy)) continue;
                    return true;
                }
                return false;
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IMethod) {
                    return true;
                }
                return this.fTypesToShow.contains(element);
            }
        }
    }

    private static class PullUpInputPage1
    extends UserInputWizardPage {
        private static final int MEMBER_COLUMN = 0;
        private static final int ACTION_COLUMN = 1;
        private static final int ROW_COUNT = 10;
        public static final String PAGE_NAME = "PullUpMethodsInputPage1";
        private static final String ACTION_PROPERTY = "action";
        private static final String MEMBER_PROPERTY = "member";
        private CheckboxTableViewer fTableViewer;
        private Combo fSuperclassCombo;
        private IType[] fSuperclasses;
        private Button fEditButton;
        private Button fCreateStubsButton;
        private Label fStatusLine;

        public PullUpInputPage1() {
            super(PAGE_NAME);
            this.setMessage(RefactoringMessages.getString("PullUpInputPage1.page_message"));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            composite.setLayout((Layout)gl);
            this.createSuperTypeCombo(composite);
            this.createSpacer(composite);
            this.createStubCheckbox(composite);
            this.createSpacer(composite);
            this.createMemberTableLabel(composite);
            this.createMemberTableComposite(composite);
            this.createStatusLine(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.pull_up_wizard_page_context");
        }

        private void createStatusLine(Composite composite) {
            this.fStatusLine = new Label(composite, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            this.updateStatusLine();
            this.fStatusLine.setLayoutData((Object)gd);
        }

        private void createStubCheckbox(Composite parent) {
            this.fCreateStubsButton = new Button(parent, 32);
            this.fCreateStubsButton.setText(RefactoringMessages.getString("PullUpInputPage1.Create_stubs"));
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            this.fCreateStubsButton.setLayoutData((Object)gd);
            this.fCreateStubsButton.setEnabled(false);
            this.fCreateStubsButton.setSelection(this.getPullUpRefactoring().getCreateMethodStubs());
        }

        private void createSpacer(Composite parent) {
            Label label = new Label(parent, 0);
            GridData gd0 = new GridData();
            gd0.horizontalSpan = 2;
            label.setLayoutData((Object)gd0);
        }

        private PullUpRefactoring getPullUpRefactoring() {
            return (PullUpRefactoring)this.getRefactoring();
        }

        private void createSuperTypeCombo(Composite parent) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(this, parent){
                    private final /* synthetic */ Composite val$parent;
                    private final /* synthetic */ PullUpInputPage1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$parent = val$parent;
                    }

                    public void run(IProgressMonitor pm) throws InvocationTargetException {
                        try {
                            PullUpInputPage1.access$100(this.this$0, pm, this.val$parent);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("PullUpInputPage.pull_Up"), RefactoringMessages.getString("PullUpInputPage.exception"));
            }
            catch (InterruptedException e) {
                Assert.isTrue(false);
            }
        }

        private void createSuperTypeCombo(IProgressMonitor pm, Composite parent) throws JavaModelException {
            Label label = new Label(parent, 0);
            label.setText(RefactoringMessages.getString("PullUpInputPage1.Select_destination"));
            label.setLayoutData((Object)new GridData());
            this.fSuperclassCombo = new Combo(parent, 8);
            this.fSuperclasses = this.getPullUpRefactoring().getPossibleTargetClasses(pm);
            Assert.isTrue(this.fSuperclasses.length > 0);
            for (int i = 0; i < this.fSuperclasses.length; ++i) {
                String comboLabel = JavaModelUtil.getFullyQualifiedName(this.fSuperclasses[i]);
                this.fSuperclassCombo.add(comboLabel);
            }
            this.fSuperclassCombo.select(this.fSuperclasses.length - 1);
            this.fSuperclassCombo.setLayoutData((Object)new GridData(768));
        }

        private void createMemberTableComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            composite.setLayoutData((Object)gd);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            composite.setLayout((Layout)gl);
            this.createMemberTable(composite);
            this.createButtonComposite(composite);
        }

        private void createMemberTableLabel(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(RefactoringMessages.getString("PullUpInputPage1.Specify_actions"));
            GridData gd0 = new GridData();
            gd0.horizontalSpan = 2;
            label.setLayoutData((Object)gd0);
        }

        private void createButtonComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1040));
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            composite.setLayout((Layout)gl);
            this.fEditButton = new Button(composite, 8);
            this.fEditButton.setText(RefactoringMessages.getString("PullUpInputPage1.Edit"));
            this.fEditButton.setLayoutData((Object)new GridData(768));
            this.fEditButton.setEnabled(false);
            SWTUtil.setButtonDimensionHint(this.fEditButton);
            this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ PullUpInputPage1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent event) {
                    PullUpInputPage1.access$200(this.this$0);
                }
            });
            Button addButton = new Button(composite, 8);
            addButton.setText(RefactoringMessages.getString("PullUpInputPage1.Add_Required"));
            addButton.setLayoutData((Object)new GridData(768));
            SWTUtil.setButtonDimensionHint(addButton);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ PullUpInputPage1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent event) {
                    PullUpInputPage1.access$300(this.this$0);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void editSelectedMembers() {
            if (!this.fEditButton.isEnabled()) {
                return;
            }
            ISelection preserved = this.fTableViewer.getSelection();
            try {
                String shellTitle = RefactoringMessages.getString("PullUpInputPage1.Edit_members");
                String labelText = RefactoringMessages.getString("PullUpInputPage1.Mark_selected_members");
                Map stringMapping = this.createStringMappingForSelectedMembers();
                Object[] keys = stringMapping.keySet().toArray(new String[stringMapping.keySet().size()]);
                Arrays.sort(keys);
                int initialSelectionIndex = this.getInitialSelectionIndexForEditDialog(stringMapping, (String[])keys);
                ComboSelectionDialog dialog = new ComboSelectionDialog(this.getShell(), shellTitle, labelText, (String[])keys, initialSelectionIndex);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 1) {
                    return;
                }
                int action = (Integer)stringMapping.get(dialog.getSelectedString());
                PullUpInputPage1.setInfoAction(this.getSelectedMemberActionInfos(), action);
            }
            finally {
                this.updateUIElements(preserved, true);
            }
        }

        private int getInitialSelectionIndexForEditDialog(Map stringMapping, String[] keys) {
            int commonActionCode = this.getCommonActionCodeForSelectedInfos();
            if (commonActionCode == -1) {
                return 0;
            }
            Iterator iter = stringMapping.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                int action = (Integer)stringMapping.get(key);
                if (commonActionCode != action) continue;
                for (int i = 0; i < keys.length; ++i) {
                    if (!key.equals(keys[i])) continue;
                    return i;
                }
                Assert.isTrue(false);
            }
            return 0;
        }

        private int getCommonActionCodeForSelectedInfos() {
            MemberActionInfo[] infos = this.getSelectedMemberActionInfos();
            if (infos.length == 0) {
                return -1;
            }
            int code = infos[0].getAction();
            for (int i = 0; i < infos.length; ++i) {
                if (code == infos[i].getAction()) continue;
                return -1;
            }
            return code;
        }

        private static void setInfoAction(MemberActionInfo[] infos, int action) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setAction(action);
            }
        }

        private Map createStringMappingForSelectedMembers() {
            HashMap result = new HashMap();
            PullUpInputPage1.putToStingMapping(result, MemberActionInfo.METHOD_LABELS, 0);
            PullUpInputPage1.putToStingMapping(result, MemberActionInfo.METHOD_LABELS, 1);
            return result;
        }

        private static void putToStingMapping(Map result, String[] actionLabels, int actionIndex) {
            result.put(actionLabels[actionIndex], new Integer(actionIndex));
        }

        private void updateUIElements(ISelection preserved, boolean displayErrorMessage) {
            this.fTableViewer.refresh();
            if (preserved != null) {
                this.fTableViewer.getControl().setFocus();
                this.fTableViewer.setSelection(preserved);
            }
            this.checkPageCompletionStatus(displayErrorMessage);
            this.updateButtonEnablementState(this.fTableViewer.getSelection());
            this.updateStatusLine();
        }

        private void updateStatusLine() {
            if (this.fStatusLine == null) {
                return;
            }
            int selected = this.fTableViewer.getCheckedElements().length;
            Object[] keys = new String[]{String.valueOf(selected)};
            String msg = RefactoringMessages.getFormattedString("PullUpInputPage1.status_line", keys);
            this.fStatusLine.setText(msg);
        }

        private static int countEditableInfos(MemberActionInfo[] infos) {
            int result = 0;
            for (int i = 0; i < infos.length; ++i) {
                MemberActionInfo info = infos[i];
                if (!info.isEditable()) continue;
                ++result;
            }
            return result;
        }

        private MemberActionInfo[] getSelectedMemberActionInfos() {
            Assert.isTrue(this.fTableViewer.getSelection() instanceof IStructuredSelection);
            IStructuredSelection ss = (IStructuredSelection)this.fTableViewer.getSelection();
            List result = ss.toList();
            return result.toArray(new MemberActionInfo[result.size()]);
        }

        private void markAdditionalRequiredMembersAsMembersToPullUp() {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(this){
                    private final /* synthetic */ PullUpInputPage1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(IProgressMonitor pm) throws InvocationTargetException {
                        try {
                            PullUpInputPage1.access$600(this.this$0, PullUpInputPage1.access$500(this.this$0).getAdditionalRequiredMembersToPullUp(pm), true);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("PullUpInputPage.pull_Up"), RefactoringMessages.getString("PullUpInputPage.exception"));
            }
            catch (InterruptedException e) {
                Assert.isTrue(false);
            }
        }

        private void createMemberTable(Composite parent) {
            TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            Table table = new Table((Composite)layouter, 68386);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            GridData gd = new GridData(1808);
            gd.heightHint = SWTUtil.getTableHeightHint(table, 10);
            gd.widthHint = this.convertWidthInCharsToPixels(30);
            layouter.setLayoutData(gd);
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            TableColumn column0 = new TableColumn(table, 0);
            column0.setText(RefactoringMessages.getString("PullUpInputPage1.Member"));
            TableColumn column1 = new TableColumn(table, 0);
            column1.setText(RefactoringMessages.getString("PullUpInputPage1.Action"));
            this.fTableViewer = new PullPushCheckboxTableViewer(table);
            this.fTableViewer.setUseHashlookup(true);
            this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MemberActionInfoLabelProvider());
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                private final /* synthetic */ PullUpInputPage1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    PullUpInputPage1.access$800(this.this$0, event.getSelection());
                }
            });
            this.fTableViewer.addCheckStateListener(new ICheckStateListener(this){
                private final /* synthetic */ PullUpInputPage1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean checked = event.getChecked();
                    MemberActionInfo info = (MemberActionInfo)event.getElement();
                    if (checked) {
                        info.setAction(0);
                    } else {
                        info.setAction(2);
                    }
                    PullUpInputPage1.access$000(this.this$0, null, true);
                }
            });
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(this){
                private final /* synthetic */ PullUpInputPage1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void doubleClick(DoubleClickEvent event) {
                    PullUpInputPage1.access$200(this.this$0);
                }
            });
            this.setTableInput();
            this.markAsMembersToPullUp(this.getPullUpRefactoring().getMembersToPullUp(), false);
            this.setupCellEditors(table);
        }

        private void updateButtonEnablementState(ISelection tableSelection) {
            if (this.fEditButton != null) {
                this.fEditButton.setEnabled(this.enableEditButton((IStructuredSelection)tableSelection));
            }
            this.fCreateStubsButton.setEnabled(this.getMethodsToDeclareAbstract().length != 0);
        }

        private boolean enableEditButton(IStructuredSelection ss) {
            if (ss.isEmpty() || ss.size() == 0) {
                return false;
            }
            return ss.size() == PullUpInputPage1.countEditableInfos(this.getSelectedMemberActionInfos());
        }

        private void setTableInput() {
            this.fTableViewer.setInput((Object)this.convertPullableMemberToMemberActionInfoArray());
        }

        private MemberActionInfo[] convertPullableMemberToMemberActionInfoArray() {
            List<IMember> toPullUp = Arrays.asList(this.getPullUpRefactoring().getMembersToPullUp());
            IMember[] members = this.getPullUpRefactoring().getPullableMembersOfDeclaringType();
            MemberActionInfo[] result = new MemberActionInfo[members.length];
            for (int i = 0; i < members.length; ++i) {
                IMember member = members[i];
                result[i] = toPullUp.contains(member) ? new MemberActionInfo(member, 0) : new MemberActionInfo(member, 2);
            }
            return result;
        }

        private void setupCellEditors(Table table) {
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor();
            comboBoxCellEditor.setStyle(8);
            this.fTableViewer.setCellEditors(new CellEditor[]{null, comboBoxCellEditor});
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(this, comboBoxCellEditor, table){
                private final /* synthetic */ ComboBoxCellEditor val$comboBoxCellEditor;
                private final /* synthetic */ Table val$table;
                private final /* synthetic */ PullUpInputPage1 this$0;
                {
                    this.this$0 = this$0;
                    this.val$comboBoxCellEditor = val$comboBoxCellEditor;
                    this.val$table = val$table;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection sel;
                    if (this.val$comboBoxCellEditor.getControl() == null & !this.val$table.isDisposed()) {
                        this.val$comboBoxCellEditor.create((Composite)this.val$table);
                    }
                    if (!((sel = event.getSelection()) instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection ss = (IStructuredSelection)sel;
                    if (ss.size() != 1) {
                        return;
                    }
                    MemberActionInfo mac = (MemberActionInfo)ss.getFirstElement();
                    this.val$comboBoxCellEditor.setItems(mac.getAllowedLabels());
                    this.val$comboBoxCellEditor.setValue((Object)new Integer(mac.getAction()));
                }
            });
            PullUpCellModifier cellModifier = new PullUpCellModifier();
            this.fTableViewer.setCellModifier((ICellModifier)cellModifier);
            this.fTableViewer.setColumnProperties(new String[]{MEMBER_PROPERTY, ACTION_PROPERTY});
        }

        private void checkPageCompletionStatus(boolean displayErrorMessage) {
            if (this.areAllMembersMarkedAsWithNoAction()) {
                if (displayErrorMessage) {
                    this.setErrorMessage(RefactoringMessages.getString("PullUpInputPage1.Select_members_to_pull_up"));
                }
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }

        private boolean areAllMembersMarkedAsWithNoAction() {
            return this.getMembersWithNoAction().length == this.getTableInputAsMemberActionInfoArray().length;
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            if (this.canSkipSecondInputPage()) {
                return this.computeSuccessorPage();
            }
            return super.getNextPage();
        }

        public boolean canFlipToNextPage() {
            if (this.canSkipSecondInputPage()) {
                return this.isPageComplete();
            }
            return super.canFlipToNextPage();
        }

        private boolean canSkipSecondInputPage() {
            return this.getMethodsToPullUp().length == 0;
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        private void initializeRefactoring() {
            this.getPullUpRefactoring().setMembersToPullUp(this.getMembersToPullUp());
            this.getPullUpRefactoring().setMethodsToDeclareAbstract(this.getMethodsToDeclareAbstract());
            this.getPullUpRefactoring().setTargetClass(this.getSelectedClass());
            this.getPullUpRefactoring().setCreateMethodStubs(this.fCreateStubsButton.getSelection());
            this.getPullUpRefactoring().setMethodsToDelete(this.getMethodsToPullUp());
        }

        private IType getSelectedClass() {
            return this.fSuperclasses[this.fSuperclassCombo.getSelectionIndex()];
        }

        private void markAsMembersToPullUp(IMember[] elements, boolean displayErrorMessage) {
            this.setActionForMembers(elements, 0);
            this.updateUIElements(null, displayErrorMessage);
        }

        private void setActionForMembers(IMember[] members, int action) {
            MemberActionInfo[] macs = this.getTableInputAsMemberActionInfoArray();
            for (int i = 0; i < members.length; ++i) {
                for (int j = 0; j < macs.length; ++j) {
                    if (!macs[j].getMember().equals(members[i])) continue;
                    macs[j].setAction(action);
                }
            }
        }

        private MemberActionInfo[] getTableInputAsMemberActionInfoArray() {
            return (MemberActionInfo[])this.fTableViewer.getInput();
        }

        private IMethod[] getMethodsToPullUp() {
            return this.getMethodsForAction(0);
        }

        private IMethod[] getMethodsToDeclareAbstract() {
            return this.getMethodsForAction(1);
        }

        private IMethod[] getMethodsForAction(int action) {
            MemberActionInfo[] macs = this.getTableInputAsMemberActionInfoArray();
            ArrayList<IMember> list = new ArrayList<IMember>(macs.length);
            for (int i = 0; i < macs.length; ++i) {
                if (!macs[i].isMethodInfo() || macs[i].getAction() != action) continue;
                list.add(macs[i].getMember());
            }
            return list.toArray(new IMethod[list.size()]);
        }

        private IMember[] getMembersWithNoAction() {
            return this.getMembersForAction(2);
        }

        private IMember[] getMembersToPullUp() {
            return this.getMembersForAction(0);
        }

        private IMember[] getMembersForAction(int action) {
            MemberActionInfo[] macs = this.getTableInputAsMemberActionInfoArray();
            ArrayList<IMember> result = new ArrayList<IMember>(macs.length);
            for (int i = 0; i < macs.length; ++i) {
                if (macs[i].getAction() != action) continue;
                result.add(macs[i].getMember());
            }
            return result.toArray(new IMember[result.size()]);
        }

        private MemberActionInfo[] getActiveInfos() {
            MemberActionInfo[] infos = this.getTableInputAsMemberActionInfoArray();
            ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(infos.length);
            for (int i = 0; i < infos.length; ++i) {
                MemberActionInfo info = infos[i];
                if (!info.isActive()) continue;
                result.add(info);
            }
            return result.toArray(new MemberActionInfo[result.size()]);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.getActiveInfos()), true);
                this.fTableViewer.getControl().setFocus();
            }
        }

        static /* synthetic */ void access$100(PullUpInputPage1 x0, IProgressMonitor x1, Composite x2) throws JavaModelException {
            x0.createSuperTypeCombo(x1, x2);
        }

        static /* synthetic */ void access$200(PullUpInputPage1 x0) {
            x0.editSelectedMembers();
        }

        static /* synthetic */ void access$300(PullUpInputPage1 x0) {
            x0.markAdditionalRequiredMembersAsMembersToPullUp();
        }

        static /* synthetic */ PullUpRefactoring access$500(PullUpInputPage1 x0) {
            return x0.getPullUpRefactoring();
        }

        static /* synthetic */ void access$600(PullUpInputPage1 x0, IMember[] x1, boolean x2) {
            x0.markAsMembersToPullUp(x1, x2);
        }

        static /* synthetic */ void access$800(PullUpInputPage1 x0, ISelection x1) {
            x0.updateButtonEnablementState(x1);
        }

        private static class MemberActionInfoLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private final ILabelProvider fJavaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);

            private MemberActionInfoLabelProvider() {
            }

            public String getColumnText(Object element, int columnIndex) {
                MemberActionInfo mac = (MemberActionInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return this.fJavaElementLabelProvider.getText((Object)mac.getMember());
                    }
                    case 1: {
                        return mac.getActionLabel();
                    }
                }
                Assert.isTrue(false);
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                MemberActionInfo mac = (MemberActionInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return this.fJavaElementLabelProvider.getImage((Object)mac.getMember());
                    }
                    case 1: {
                        return null;
                    }
                }
                Assert.isTrue(false);
                return null;
            }

            public void dispose() {
                super.dispose();
                this.fJavaElementLabelProvider.dispose();
            }
        }

        private static class MemberActionInfo
        implements IMemberActionInfo {
            static final int PULL_UP_ACTION = 0;
            static final int DECLARE_ABSTRACT_ACTION = 1;
            static final int NO_ACTION = 2;
            private static final String NO_LABEL = "";
            private static final String PULL_UP_LABEL = RefactoringMessages.getString("PullUpInputPage1.pull_up");
            private static final String DECLARE_ABSTRACT_LABEL = RefactoringMessages.getString("PullUpInputPage1.declare_abstract");
            private static final String[] FIELD_LABELS = new String[]{""};
            private static final String[] METHOD_LABELS = new String[2];
            private static final String[] TYPE_LABELS;
            private final IMember fMember;
            private int fAction;

            MemberActionInfo(IMember member, int action) {
                Assert.isTrue(member instanceof IMethod || member instanceof IField || member instanceof IType);
                MemberActionInfo.assertAction(member, action);
                this.fMember = member;
                this.fAction = action;
            }

            public boolean isTypeInfo() {
                return this.getMember() instanceof IType;
            }

            public boolean isMethodInfo() {
                return this.getMember() instanceof IMethod;
            }

            public boolean isFieldInfo() {
                return this.getMember() instanceof IField;
            }

            IMember getMember() {
                return this.fMember;
            }

            int getAction() {
                return this.fAction;
            }

            private static void assertAction(IMember member, int action) {
                if (member instanceof IMethod) {
                    try {
                        Assert.isTrue(action != 1 || !JdtFlags.isStatic(member));
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                    Assert.isTrue(action == 2 || action == 1 || action == 0);
                } else {
                    Assert.isTrue(action == 2 || action == 0);
                }
            }

            void setAction(int action) {
                MemberActionInfo.assertAction(this.fMember, action);
                this.fAction = action;
            }

            String getActionLabel() {
                switch (this.fAction) {
                    case 0: {
                        return PULL_UP_LABEL;
                    }
                    case 1: {
                        return DECLARE_ABSTRACT_LABEL;
                    }
                    case 2: {
                        return NO_LABEL;
                    }
                }
                Assert.isTrue(false);
                return null;
            }

            String[] getAllowedLabels() {
                if (this.isFieldInfo()) {
                    return FIELD_LABELS;
                }
                if (this.isMethodInfo()) {
                    return METHOD_LABELS;
                }
                if (this.isTypeInfo()) {
                    return TYPE_LABELS;
                }
                Assert.isTrue(false);
                return null;
            }

            public boolean isEditable() {
                if (this.fAction == 2) {
                    return false;
                }
                if (!this.isMethodInfo()) {
                    return false;
                }
                IMethod method = (IMethod)this.fMember;
                try {
                    return !JdtFlags.isStatic((IMember)method);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    return false;
                }
            }

            public boolean isActive() {
                return this.getAction() != 2;
            }

            static {
                MemberActionInfo.METHOD_LABELS[0] = PULL_UP_LABEL;
                MemberActionInfo.METHOD_LABELS[1] = DECLARE_ABSTRACT_LABEL;
                TYPE_LABELS = new String[1];
                MemberActionInfo.TYPE_LABELS[0] = PULL_UP_LABEL;
            }
        }

        private class PullUpCellModifier
        implements ICellModifier {
            private PullUpCellModifier() {
            }

            public Object getValue(Object element, String property) {
                if (!PullUpInputPage1.ACTION_PROPERTY.equals(property)) {
                    return null;
                }
                MemberActionInfo mac = (MemberActionInfo)element;
                return new Integer(mac.getAction());
            }

            public boolean canModify(Object element, String property) {
                if (!PullUpInputPage1.ACTION_PROPERTY.equals(property)) {
                    return false;
                }
                return ((MemberActionInfo)element).isEditable();
            }

            public void modify(Object element, String property, Object value) {
                if (!PullUpInputPage1.ACTION_PROPERTY.equals(property)) {
                    return;
                }
                int action = (Integer)value;
                MemberActionInfo mac = element instanceof Item ? (MemberActionInfo)((Item)element).getData() : (MemberActionInfo)element;
                if (!this.canModify(mac, property)) {
                    return;
                }
                Assert.isTrue(mac.isMethodInfo());
                mac.setAction(action);
                PullUpInputPage1.this.updateUIElements(null, true);
            }
        }
    }
}

