/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DefaultPreferences
extends EclipsePreferences {
    private static Set loadedNodes = new HashSet();
    private static final String ELEMENT_INITIALIZER = "initializer";
    private static final String ATTRIBUTE_CLASS = "class";
    private static boolean initialized = false;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final IPath NL_DIR = new Path("$nl$");
    public static final String PRODUCT_KEY = "preferenceCustomization";
    private static final String LEGACY_PRODUCT_CUSTOMIZATION_FILENAME = "plugin_customization.ini";
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private EclipsePreferences loadLevel;
    private String qualifier;
    private int segmentCount;
    private Plugin plugin;

    public DefaultPreferences() {
        this(null, null);
    }

    private DefaultPreferences(IEclipsePreferences parent, String name, Plugin context) {
        this(parent, name);
        this.plugin = context;
    }

    private DefaultPreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        if (parent instanceof DefaultPreferences) {
            this.plugin = ((DefaultPreferences)parent).plugin;
        }
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = DefaultPreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = DefaultPreferences.getSegment(path, 1);
    }

    private void applyBundleDefaults() {
        Bundle bundle = Platform.getBundle(this.name());
        if (bundle == null) {
            return;
        }
        URL url = Platform.find(bundle, new Path("preferences.ini"));
        if (url == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Preference default override file not found for bundle: " + bundle.getSymbolicName());
            }
            return;
        }
        URL transURL = Platform.find(bundle, NL_DIR.append("preferences").addFileExtension(PROPERTIES_FILE_EXTENSION));
        if (transURL == null && InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Preference translation file not found for bundle: " + bundle.getSymbolicName());
        }
        this.applyDefaults(this.name(), this.loadProperties(url), this.loadProperties(transURL));
    }

    private void applyCommandLineDefaults() {
        String filename = InternalPlatform.pluginCustomizationFile;
        if (filename == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Command-line preferences customization file not specified.");
            }
            return;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Using command-line preference customization file: " + filename);
        }
        this.applyDefaults(null, this.loadProperties(filename), null);
    }

    private void applyDefaults(String id, Properties defaultValues, Properties translations) {
        Enumeration<Object> e = defaultValues.keys();
        while (e.hasMoreElements()) {
            String fullKey = (String)e.nextElement();
            String value = defaultValues.getProperty(fullKey);
            if (value == null) continue;
            IPath childPath = new Path(fullKey);
            String key = childPath.lastSegment();
            childPath = childPath.removeLastSegments(1);
            String localQualifier = id;
            if (id == null) {
                localQualifier = childPath.segment(0);
                childPath = childPath.removeFirstSegments(1);
            }
            if (!this.name().equals(localQualifier)) continue;
            value = this.translatePreference(value, translations);
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Setting default preference: " + new Path(this.absolutePath()).append(childPath).append(key) + '=' + value);
            }
            ((EclipsePreferences)this.internalNode(((Object)childPath).toString(), false, null)).internalPut(key, value);
        }
    }

    private void runInitializer(IConfigurationElement element) {
        AbstractPreferenceInitializer initializer = null;
        try {
            initializer = (AbstractPreferenceInitializer)element.createExecutableExtension(ATTRIBUTE_CLASS);
        }
        catch (ClassCastException e) {
            String message = Policy.bind("preferences.invalidExtensionSuperclass");
            Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
            this.log(status);
        }
        catch (CoreException e) {
            this.log(e.getStatus());
        }
        initializer.initializeDefaultPreferences();
    }

    public IEclipsePreferences node(String childName, Plugin context) {
        return this.internalNode(childName, true, context);
    }

    private void applyRuntimeDefaults() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.runtime", "preferences");
        if (point == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("No extensions for org.eclipse.core.runtime.preferences extension point. Skipping runtime default preference customization.");
            }
            return;
        }
        IExtension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                if (!ELEMENT_INITIALIZER.equals(elements[j].getName()) || !this.name().equals(elements[j].getDeclaringExtension().getNamespace())) continue;
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Running default preference customization as defined by: " + elements[j].getDeclaringExtension().getDeclaringPluginDescriptor());
                }
                this.runInitializer(elements[j]);
                return;
            }
        }
        if (this.plugin == null && InternalPlatform.getDefault().getBundle("org.eclipse.core.runtime.compatibility") != null) {
            this.plugin = Platform.getPlugin(this.name());
        }
        if (this.plugin == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("No plug-in object available to set plug-in default preference overrides for:" + this.name());
            }
            return;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Applying plug-in default preference overrides for plug-in: " + this.plugin.getDescriptor().getUniqueIdentifier());
        }
        this.plugin.internalInitializeDefaultPluginPreferences();
    }

    private void applyProductDefaults() {
        URL transURL;
        URL url;
        String value;
        Bundle bundle;
        String id;
        block14: {
            IProduct product = Platform.getProduct();
            if (product == null) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Product not available to set product default preference overrides.");
                }
                return;
            }
            id = product.getId();
            if (id == null) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Product ID not available to apply product-level preference defaults.");
                }
                return;
            }
            bundle = product.getDefiningBundle();
            if (bundle == null) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Bundle not available to apply product-level preference defaults for product id: " + id);
                }
                return;
            }
            value = product.getProperty(PRODUCT_KEY);
            url = null;
            transURL = null;
            if (value == null) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Product : " + id + " does not define preference customization file. Using legacy file: plugin_customization.ini");
                }
                value = LEGACY_PRODUCT_CUSTOMIZATION_FILENAME;
                url = Platform.find(bundle, new Path(LEGACY_PRODUCT_CUSTOMIZATION_FILENAME));
                transURL = Platform.find(bundle, NL_DIR.append(value).removeFileExtension().addFileExtension(PROPERTIES_FILE_EXTENSION));
            } else {
                try {
                    url = new URL(value);
                }
                catch (MalformedURLException e) {
                    url = Platform.find(bundle, new Path(value));
                    if (url == null) break block14;
                    transURL = Platform.find(bundle, NL_DIR.append(value).removeFileExtension().addFileExtension(PROPERTIES_FILE_EXTENSION));
                }
            }
        }
        if (url == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Product preference customization file: " + value + " not found for bundle: " + id);
            }
            return;
        }
        if (transURL == null && InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("No preference translations found for product/file: " + bundle.getSymbolicName() + '/' + value);
        }
        this.applyDefaults(null, this.loadProperties(url), this.loadProperties(transURL));
    }

    public void flush() {
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences node = this;
            for (int i = 2; i < this.segmentCount; ++i) {
                node = (EclipsePreferences)node.parent();
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent == null) {
            return;
        }
        try {
            DefaultPreferences defaultPreferences = this;
            synchronized (defaultPreferences) {
                BundleContext context = InternalPlatform.getDefault().getBundleContext();
                Bundle[] bundles = context.getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    String childName = bundles[i].getSymbolicName();
                    if (childName == null) continue;
                    this.addChild(childName, null);
                }
            }
        }
        finally {
            initialized = true;
        }
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new DefaultPreferences(nodeParent, nodeName, context);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void load() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.applyRuntimeDefaults();
        this.applyBundleDefaults();
        this.applyProductDefaults();
        this.applyCommandLineDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadProperties(URL url) {
        Properties result = new Properties();
        if (url == null) {
            return result;
        }
        InputStream input = null;
        input = Platform.resolve(url).openStream();
        result.load(input);
        Object var6_4 = null;
        if (input == null) return result;
        try {
            input.close();
            return result;
        }
        catch (IOException e2) {}
        return result;
        {
            catch (IOException e) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Problem opening stream to preference customization file: " + url);
                    e.printStackTrace();
                }
                Object var6_5 = null;
                if (input == null) return result;
                try {
                    input.close();
                    return result;
                }
                catch (IOException e2) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadProperties(String filename) {
        Properties result = new Properties();
        BufferedInputStream input = null;
        input = new BufferedInputStream(new FileInputStream(filename));
        result.load(input);
        Object var8_4 = null;
        if (input == null) return result;
        try {
            ((InputStream)input).close();
            return result;
        }
        catch (IOException e2) {}
        return result;
        {
            catch (FileNotFoundException e) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Preference customization file not found: " + filename);
                }
                Object var8_5 = null;
                if (input == null) return result;
                try {
                    ((InputStream)input).close();
                    return result;
                }
                catch (IOException e2) {}
                return result;
            }
            catch (IOException e) {
                String message = Policy.bind("preferences.loadException", filename);
                Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
                InternalPlatform.getDefault().log(status);
                Object var8_6 = null;
                if (input == null) return result;
                try {
                    ((InputStream)input).close();
                    return result;
                }
                catch (IOException e2) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (input == null) throw throwable;
            try {
                ((InputStream)input).close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void sync() {
    }

    private String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value.substring(1) : value.substring(1, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key, dflt);
        }
        return value;
    }
}

