/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.ws.EnablementDialog;

public final class WorkbenchActivityHelper {
    public static boolean allowUseOf(Object object) {
        if (!WorkbenchActivityHelper.isFiltering()) {
            return true;
        }
        if (object instanceof IPluginContribution) {
            IPluginContribution contribution = (IPluginContribution)object;
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(contribution));
            return WorkbenchActivityHelper.allow(identifier);
        }
        return true;
    }

    private static boolean allow(IIdentifier identifier) {
        if (identifier.isEnabled()) {
            return true;
        }
        if (!PlatformUI.getWorkbench().getPreferenceStore().getBoolean("shouldPromptForEnablement")) {
            WorkbenchActivityHelper.enableIdentifier(identifier);
            return true;
        }
        EnablementDialog dialog = new EnablementDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), identifier.getActivityIds());
        if (dialog.open() == 0) {
            WorkbenchActivityHelper.enabledActivities(dialog.getActivitiesToEnable());
            if (dialog.getDontAsk()) {
                PlatformUI.getWorkbench().getPreferenceStore().setValue("shouldPromptForEnablement", false);
                WorkbenchPlugin.getDefault().savePluginPreferences();
            }
            return true;
        }
        return false;
    }

    public static final String createUnifiedId(IPluginContribution contribution) {
        if (contribution.getPluginId() != null) {
            return contribution.getPluginId() + '/' + contribution.getLocalId();
        }
        return contribution.getLocalId();
    }

    private static void enabledActivities(Collection activities) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet newSet = new HashSet(activitySupport.getActivityManager().getEnabledActivityIds());
        newSet.addAll(activities);
        activitySupport.setEnabledActivityIds(newSet);
    }

    private static final void enableIdentifier(IIdentifier identifier) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet newSet = new HashSet(activitySupport.getActivityManager().getEnabledActivityIds());
        newSet.addAll(identifier.getActivityIds());
        activitySupport.setEnabledActivityIds(newSet);
    }

    public static final boolean filterItem(Object object) {
        if (object instanceof IPluginContribution) {
            IPluginContribution contribution = (IPluginContribution)object;
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(contribution));
            if (!identifier.isEnabled()) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }

    private WorkbenchActivityHelper() {
    }
}

