/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler;

import java.util.Calendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IStartup;
import org.eclipse.update.internal.scheduler.AutomaticUpdatesJob;
import org.eclipse.update.internal.scheduler.UpdateScheduler;

public class SchedulerStartup
implements IStartup {
    public static final String P_ENABLED = "enabled";
    public static final String P_SCHEDULE = "schedule";
    public static final String VALUE_ON_STARTUP = "on-startup";
    public static final String VALUE_ON_SCHEDULE = "on-schedule";
    public static final String P_DOWNLOAD = "download";
    public static final String P_DAY = "day";
    public static final String P_HOUR = "hour";
    private Job job;
    private UpdateJobChangeAdapter jobListener;
    public static final String[] DAYS = new String[]{UpdateScheduler.getString("SchedulerStartup.day"), UpdateScheduler.getString("SchedulerStartup.Monday"), UpdateScheduler.getString("SchedulerStartup.Tuesday"), UpdateScheduler.getString("SchedulerStartup.Wednesday"), UpdateScheduler.getString("SchedulerStartup.Thursday"), UpdateScheduler.getString("SchedulerStartup.Friday"), UpdateScheduler.getString("SchedulerStartup.Saturday"), UpdateScheduler.getString("SchedulerStartup.Sunday")};
    public static final String[] HOURS = new String[]{UpdateScheduler.getString("SchedulerStartup.1AM"), UpdateScheduler.getString("SchedulerStartup.2AM"), UpdateScheduler.getString("SchedulerStartup.3AM"), UpdateScheduler.getString("SchedulerStartup.4AM"), UpdateScheduler.getString("SchedulerStartup.5AM"), UpdateScheduler.getString("SchedulerStartup.6AM"), UpdateScheduler.getString("SchedulerStartup.7AM"), UpdateScheduler.getString("SchedulerStartup.8AM"), UpdateScheduler.getString("SchedulerStartup.9AM"), UpdateScheduler.getString("SchedulerStartup.10AM"), UpdateScheduler.getString("SchedulerStartup.11AM"), UpdateScheduler.getString("SchedulerStartup.12PM"), UpdateScheduler.getString("SchedulerStartup.1PM"), UpdateScheduler.getString("SchedulerStartup.2PM"), UpdateScheduler.getString("SchedulerStartup.3PM"), UpdateScheduler.getString("SchedulerStartup.4PM"), UpdateScheduler.getString("SchedulerStartup.5PM"), UpdateScheduler.getString("SchedulerStartup.6PM"), UpdateScheduler.getString("SchedulerStartup.7PM"), UpdateScheduler.getString("SchedulerStartup.8PM"), UpdateScheduler.getString("SchedulerStartup.9PM"), UpdateScheduler.getString("SchedulerStartup.10PM"), UpdateScheduler.getString("SchedulerStartup.11PM"), UpdateScheduler.getString("SchedulerStartup.12AM")};

    public SchedulerStartup() {
        UpdateScheduler.setScheduler(this);
        this.jobListener = new UpdateJobChangeAdapter();
        Platform.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
    }

    public void earlyStartup() {
        this.scheduleUpdateJob();
    }

    public void scheduleUpdateJob() {
        Preferences pref = UpdateScheduler.getDefault().getPluginPreferences();
        if (!pref.getBoolean(P_ENABLED)) {
            return;
        }
        String schedule = pref.getString(P_SCHEDULE);
        long delay = -1L;
        delay = schedule.equals(VALUE_ON_STARTUP) ? (this.job == null ? 0L : -1L) : this.computeDelay(pref);
        if (delay == -1L) {
            return;
        }
        this.startSearch(delay);
    }

    private int getDay(Preferences pref) {
        String day = pref.getString(P_DAY);
        for (int d = 0; d < DAYS.length; ++d) {
            if (!DAYS[d].equals(day)) continue;
            switch (d) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 1;
                }
            }
        }
        return -1;
    }

    private int getHour(Preferences pref) {
        String hour = pref.getString(P_HOUR);
        for (int h = 0; h < HOURS.length; ++h) {
            if (!HOURS[h].equals(hour)) continue;
            return h + 1;
        }
        return 1;
    }

    private long computeDelay(Preferences pref) {
        int target_d = this.getDay(pref);
        int target_h = this.getHour(pref);
        Calendar calendar = Calendar.getInstance();
        int current_d = calendar.get(7);
        int current_h = calendar.get(11);
        int current_m = calendar.get(12);
        int current_s = calendar.get(13);
        int current_ms = calendar.get(14);
        long delay = 0L;
        if (target_d == -1) {
            if (target_h == current_h && current_m == 0 && current_s == 0) {
                return delay;
            }
            int delta_h = target_h - current_h;
            if (target_h <= current_h) {
                delta_h += 24;
            }
            delay = ((delta_h * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
            return delay;
        }
        if (target_d == current_d && target_h == current_h && current_m == 0 && current_s == 0) {
            return delay;
        }
        int delta_d = target_d - current_d;
        if (target_d < current_d || target_d == current_d && (target_h < current_h || target_h == current_h && current_m > 0)) {
            delta_d += 7;
        }
        delay = (((delta_d * 24 + target_h - current_h) * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
        return delay;
    }

    private void startSearch(long delay) {
        if (this.job != null) {
            Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this.jobListener);
            Platform.getJobManager().cancel(AutomaticUpdatesJob.family);
            Platform.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
        }
        this.job = new AutomaticUpdatesJob();
        this.job.schedule(delay);
    }

    private class UpdateJobChangeAdapter
    extends JobChangeAdapter {
        private UpdateJobChangeAdapter() {
        }

        public void done(Job job, IStatus result) {
            if (job == SchedulerStartup.this.job) {
                SchedulerStartup.this.scheduleUpdateJob();
            }
        }
    }
}

