/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.internal.core.InfiniteSubProgressMonitor;
import org.eclipse.team.internal.core.NullSubProgressMonitor;

public class Policy {
    protected static ResourceBundle bundle = null;

    public static void localize(String bundleName) {
        bundle = ResourceBundle.getBundle(bundleName);
    }

    public static String bind(String id, String binding) {
        return Policy.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Policy.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String binding1, String binding2, String binding3) {
        return Policy.bind(id, new String[]{binding1, binding2, binding3});
    }

    public static String bind(String key, ResourceBundle b) {
        try {
            return b.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public static String bind(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public static String bind(String key, Object[] args) {
        try {
            return MessageFormat.format(Policy.bind(key), args);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public static IProgressMonitor subInfiniteMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new InfiniteSubProgressMonitor(monitor, ticks);
    }

    public static IProgressMonitor subNullMonitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new NullSubProgressMonitor(monitor);
    }

    public static String toTruncatedPath(IPath path, int split) {
        int count = 0;
        String stringPath = path.toString();
        int index = stringPath.length();
        while (count++ < split && index != -1) {
            index = stringPath.lastIndexOf(47, index - 1);
        }
        if (index == -1) {
            return stringPath;
        }
        return "..." + stringPath.substring(index);
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }
}

