/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.help.ui.internal.workingset;

import org.eclipse.core.runtime.*;
import org.eclipse.help.internal.base.*;
import org.eclipse.help.internal.workingset.*;
import org.eclipse.ui.*;

/**
 * A working set for help elements.
 */
public class HelpWorkingSet {

	private WorkingSet workingSet;
	private IWorkingSet iworkingSet;

	/**
	 * Constructor for HelpWorkingSet.
	 * 
	 * @param name
	 * @param elements
	 */
	public HelpWorkingSet(String name, IAdaptable[] elements) {
		this(BaseHelpSystem.getWorkingSetManager().createWorkingSet(name,
				(AdaptableHelpResource[]) elements));
	}

	public HelpWorkingSet(WorkingSet ws) {
		this.workingSet = ws;
		this.iworkingSet = PlatformUI.getWorkbench().getWorkingSetManager()
				.createWorkingSet(ws.getName(), ws.getElements());

		iworkingSet.setId(HelpWorkingSetPage.PAGE_ID);

		//HelpSystem.getWorkingSetManager().addWorkingSet(workingSet);
		//PlatformUI.getWorkbench().getWorkingSetManager().addWorkingSet(iworkingSet);
	}

	public HelpWorkingSet(IWorkingSet iws) {
		this.iworkingSet = iws;
		AdaptableHelpResource[] elements = new AdaptableHelpResource[iws
				.getElements().length];
		System.arraycopy(iws.getElements(), 0, elements, 0, elements.length);
		this.workingSet = BaseHelpSystem.getWorkingSetManager()
				.createWorkingSet(iws.getName(), elements);

		//HelpSystem.getWorkingSetManager().addWorkingSet(workingSet);
		//PlatformUI.getWorkbench().getWorkingSetManager().addWorkingSet(iworkingSet);
	}

	public HelpWorkingSet(WorkingSet ws, IWorkingSet iws) {
		this.workingSet = ws;
		this.iworkingSet = iws;
	}

	public IWorkingSet getIWorkingSet() {
		return iworkingSet;
	}

	public WorkingSet getWorkingSet() {
		return workingSet;
	}

	/**
	 * Tests the receiver and the object for equality
	 * 
	 * @param object
	 *            object to compare the receiver to
	 * @return true=the object equals the receiver, the name is the same. false
	 *         otherwise
	 */
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object instanceof HelpWorkingSet) {
			HelpWorkingSet ws = (HelpWorkingSet) object;
			return this.workingSet == ws.workingSet;
		} else
			return false;
	}

}
