/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class AddImportsOperation
implements IWorkspaceRunnable {
    private ICompilationUnit fCompilationUnit;
    private IJavaElement[] fImports;
    private boolean fDoSave;
    private CodeGenerationSettings fSettings;

    public AddImportsOperation(ICompilationUnit cu, IJavaElement[] imports, CodeGenerationSettings settings, boolean save) {
        this.fImports = imports;
        this.fCompilationUnit = cu;
        this.fDoSave = save;
        this.fSettings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            int nImports = this.fImports.length;
            monitor.beginTask(CodeGenerationMessages.getString("AddImportsOperation.description"), 2);
            ImportsStructure impStructure = new ImportsStructure(this.fCompilationUnit, this.fSettings.importOrder, this.fSettings.importThreshold, true);
            impStructure.setFindAmbiguousImports(true);
            for (int i = 0; i < nImports; ++i) {
                IJavaElement imp = this.fImports[i];
                if (imp instanceof IType) {
                    IType type = (IType)imp;
                    impStructure.addImport(JavaModelUtil.getTypeContainerName(type), type.getElementName());
                    continue;
                }
                if (!(imp instanceof IPackageFragment)) continue;
                String packageName = ((IPackageFragment)imp).getElementName();
                impStructure.addImport(packageName, "*");
            }
            monitor.worked(1);
            impStructure.create(this.fDoSave, null);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

