/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.LexicalSortingAction;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;

public class MembersView
extends JavaBrowsingPart
implements IPropertyChangeListener {
    private MemberFilterActionGroup fMemberFilterActionGroup;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInTargetList;

    public MembersView() {
        this.setHasWorkingSetFilter(false);
        this.setHasCustomSetFilter(true);
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object getAdapter(Class key) {
        if (key == (class$org$eclipse$ui$part$IShowInTargetList == null ? (class$org$eclipse$ui$part$IShowInTargetList = MembersView.class$("org.eclipse.ui.part.IShowInTargetList")) : class$org$eclipse$ui$part$IShowInTargetList)) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(1090519561, 1);
    }

    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.members_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.jdt.ui.browsing.memberstoeditor";
    }

    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer viewer = new ProblemTreeViewer(parent, 2);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)viewer, JavaUI.ID_MEMBERS_VIEW);
        return viewer;
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)new LexicalSortingAction(this.getViewer(), JavaUI.ID_MEMBERS_VIEW));
        this.fMemberFilterActionGroup.contributeToToolBar(tbm);
        super.fillToolBar(tbm);
    }

    protected boolean isValidInput(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.isBinary() || type.getDeclaringType() == null;
        }
        return false;
    }

    protected boolean isValidElement(Object element) {
        Object input;
        if (element instanceof IMember) {
            return super.isValidElement(((IMember)element).getDeclaringType());
        }
        if (element instanceof IImportDeclaration) {
            return this.isValidElement(((IJavaElement)element).getParent());
        }
        if (element instanceof IImportContainer && (input = this.getViewer().getInput()) instanceof IJavaElement) {
            ICompilationUnit cu = (ICompilationUnit)((IJavaElement)input).getAncestor(5);
            if (cu != null) {
                ICompilationUnit importContainerCu = (ICompilationUnit)((IJavaElement)element).getAncestor(5);
                return cu.equals(importContainerCu);
            }
            IClassFile cf = (IClassFile)((IJavaElement)input).getAncestor(6);
            IClassFile importContainerCf = (IClassFile)((IJavaElement)element).getAncestor(6);
            return cf != null && cf.equals(importContainerCf);
        }
        return false;
    }

    protected IJavaElement findElementToSelect(IJavaElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                if (((IType)je).getDeclaringType() == null) {
                    return null;
                }
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return this.getSuitableJavaElement(je);
            }
            case 13: {
                je = this.getSuitableJavaElement(je);
                if (je == null) break;
                ICompilationUnit cu = (ICompilationUnit)je.getParent().getParent();
                try {
                    Object selectedElement;
                    if (cu.getImports()[0].equals(je) && (selectedElement = this.getSingleElementFromSelection(this.getViewer().getSelection())) instanceof IImportContainer) {
                        return (IImportContainer)selectedElement;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                return je;
            }
        }
        return null;
    }

    protected IJavaElement findInputForJavaElement(IJavaElement je) {
        if (je == null || !je.exists()) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    return je;
                }
                return this.findInputForJavaElement((IJavaElement)type);
            }
            case 5: {
                return this.getTypeForCU((ICompilationUnit)je);
            }
            case 6: {
                try {
                    return this.findInputForJavaElement((IJavaElement)((IClassFile)je).getType());
                }
                catch (JavaModelException ex) {
                    return null;
                }
            }
            case 13: {
                return this.findInputForJavaElement(je.getParent());
            }
            case 11: 
            case 12: {
                IJavaElement parent = je.getParent();
                if (parent instanceof ICompilationUnit) {
                    return this.getTypeForCU((ICompilationUnit)parent);
                }
                if (!(parent instanceof IClassFile)) break;
                return this.findInputForJavaElement(parent);
            }
        }
        if (je instanceof IMember) {
            return this.findInputForJavaElement((IJavaElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.fMemberFilterActionGroup.saveState(memento);
    }

    protected void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.fMemberFilterActionGroup.restoreState(memento);
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().refresh();
        this.getViewer().getControl().setRedraw(true);
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)MembersView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    boolean isInputAWorkingCopy() {
        ICompilationUnit cu;
        Object input = this.getViewer().getInput();
        if (input instanceof IJavaElement && (cu = (ICompilationUnit)((IJavaElement)input).getAncestor(5)) != null) {
            return cu.isWorkingCopy();
        }
        return false;
    }

    protected void restoreSelection() {
        IEditorPart editor = this.getViewSite().getPage().getActiveEditor();
        if (editor != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.getViewer().refresh();
        }
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        super.dispose();
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

