/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.HistoryAction;
import org.eclipse.jdt.internal.ui.callhierarchy.HistoryListAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.help.WorkbenchHelp;

class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private CallHierarchyViewPart fView;
    private Menu fMenu;

    public HistoryDropDownAction(CallHierarchyViewPart view) {
        this.fView = view;
        this.fMenu = null;
        this.setToolTipText(CallHierarchyMessages.getString("HistoryDropDownAction.tooltip"));
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "history_list.gif");
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_history_drop_down_action_context");
        this.setMenuCreator(this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IMethod[] elements = this.fView.getHistoryEntries();
        boolean checked = this.addEntries(this.fMenu, elements);
        if (elements.length > 10) {
            new MenuItem(this.fMenu, 2);
            HistoryListAction others = new HistoryListAction(this.fView);
            others.setChecked(checked);
            this.addActionToMenu(this.fMenu, others);
        }
        return this.fMenu;
    }

    public void dispose() {
        this.fView = null;
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private boolean addEntries(Menu menu, IMethod[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        for (int i = 0; i < min; ++i) {
            HistoryAction action = new HistoryAction(this.fView, elements[i]);
            action.setChecked(elements[i].equals(this.fView.getMethod()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
        }
        return checked;
    }

    public void run() {
        new HistoryListAction(this.fView).run();
    }
}

