/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.compare.JavaParseTreeBuilder;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class JavaStructureCreator
implements IStructureCreator {
    public String getName() {
        return CompareMessages.getString("JavaStructureViewer.title");
    }

    public IStructureComparator getStructure(final Object input) {
        String contents = null;
        char[] buffer = null;
        IDocument doc = DocumentManager.get((Object)input);
        if (doc == null) {
            if (input instanceof IStreamContentAccessor) {
                IStreamContentAccessor sca = (IStreamContentAccessor)input;
                try {
                    contents = JavaCompareUtilities.readString(sca);
                }
                catch (CoreException ex) {
                    return null;
                }
            }
            if (contents != null) {
                int n = contents.length();
                buffer = new char[n];
                contents.getChars(0, n, buffer, 0);
                doc = new Document(contents);
                DocumentManager.put((Object)input, (IDocument)doc);
                JavaCompareUtilities.setupDocument(doc);
            }
        }
        if (doc != null) {
            boolean isEditable = false;
            if (input instanceof IEditableContent) {
                isEditable = ((IEditableContent)input).isEditable();
            }
            JavaNode root = new JavaNode(doc, isEditable){

                void nodeChanged(JavaNode node) {
                    JavaStructureCreator.this.save((IStructureComparator)this, input);
                }
            };
            if (buffer == null) {
                contents = doc.get();
                int n = contents.length();
                buffer = new char[n];
                contents.getChars(0, n, buffer, 0);
            }
            JavaParseTreeBuilder builder = new JavaParseTreeBuilder(root, buffer);
            SourceElementParser parser = new SourceElementParser((ISourceElementRequestor)builder, (IProblemFactory)new ProblemFactory(), new CompilerOptions((Map)JavaCore.getOptions()));
            try {
                parser.parseCompilationUnit((ICompilationUnit)builder, false);
            }
            catch (ParseError ex) {
                return null;
            }
            return root;
        }
        return null;
    }

    public boolean canSave() {
        return true;
    }

    public void save(IStructureComparator node, Object input) {
        if (node instanceof JavaNode && input instanceof IEditableContent) {
            byte[] bytes;
            IDocument document = ((JavaNode)node).getDocument();
            IEditableContent bca = (IEditableContent)input;
            String contents = document.get();
            String encoding = null;
            if (input instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)input).getCharset();
                }
                catch (CoreException e1) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            try {
                bytes = contents.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                bytes = contents.getBytes();
            }
            bca.setContent(bytes);
        }
    }

    public String getContents(Object node, boolean ignoreWhiteSpace) {
        if (!(node instanceof IStreamContentAccessor)) {
            return null;
        }
        IStreamContentAccessor sca = (IStreamContentAccessor)node;
        String content = null;
        try {
            content = JavaCompareUtilities.readString(sca);
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex);
            return null;
        }
        if (ignoreWhiteSpace) {
            StringBuffer buf = new StringBuffer();
            char[] b = content.toCharArray();
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
            scanner.setSource(b);
            try {
                int token;
                block7: while ((token = scanner.getNextToken()) != 158) {
                    switch (token) {
                        case 1000: 
                        case 1001: 
                        case 1002: 
                        case 1003: {
                            int l = buf.length();
                            if (l <= 0 || buf.charAt(l - 1) == ' ') continue block7;
                            buf.append(' ');
                            continue block7;
                        }
                    }
                    buf.append(scanner.getCurrentTokenSource());
                    buf.append(' ');
                }
                content = buf.toString();
            }
            catch (InvalidInputException ex) {
                // empty catch block
            }
        }
        return content;
    }

    public boolean canRewriteTree() {
        return true;
    }

    public void rewriteTree(Differencer differencer, IDiffContainer root) {
        HashMap<String, RewriteInfo> map = new HashMap<String, RewriteInfo>(10);
        IDiffElement[] children = root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            DiffNode diff = (DiffNode)children[i];
            JavaNode jn = (JavaNode)diff.getId();
            if (jn == null) continue;
            int type = jn.getTypeCode();
            if (type == 9 || type == 8) {
                String name = jn.extractMethodName();
                RewriteInfo nameInfo = (RewriteInfo)map.get(name);
                if (nameInfo == null) {
                    nameInfo = new RewriteInfo();
                    map.put(name, nameInfo);
                }
                nameInfo.add((IDiffElement)diff);
                String argList = jn.extractArgumentList();
                RewriteInfo argInfo = null;
                if (argList != null && !argList.equals("()")) {
                    argInfo = (RewriteInfo)map.get(argList);
                    if (argInfo == null) {
                        argInfo = new RewriteInfo();
                        map.put(argList, argInfo);
                    }
                    argInfo.add((IDiffElement)diff);
                }
                switch (diff.getKind() & 3) {
                    case 1: 
                    case 2: {
                        if (type != 8) {
                            nameInfo.setDiff((ICompareInput)diff);
                        }
                        if (argInfo == null) break;
                        argInfo.setDiff((ICompareInput)diff);
                        break;
                    }
                }
            }
            this.rewriteTree(differencer, (IDiffContainer)diff);
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            DiffNode d;
            String name = (String)it.next();
            RewriteInfo i = (RewriteInfo)map.get(name);
            if (!i.matches() || (d = (DiffNode)differencer.findDifferences(true, null, (Object)root, (Object)i.fAncestor, (Object)i.fLeft, (Object)i.fRight)) == null) continue;
            d.setDontExpand(true);
            Iterator it2 = i.fChildren.iterator();
            while (it2.hasNext()) {
                IDiffElement rd = (IDiffElement)it2.next();
                root.removeToRoot(rd);
                d.add(rd);
            }
        }
    }

    public IStructureComparator locate(Object selector, Object input) {
        if (!(selector instanceof IJavaElement)) {
            return null;
        }
        IStructureComparator structure = this.getStructure(input);
        if (structure == null) {
            return null;
        }
        String[] path = JavaStructureCreator.createPath((IJavaElement)selector);
        return JavaStructureCreator.find(structure, path, 0);
    }

    private static String[] createPath(IJavaElement je) {
        ArrayList<String> args = new ArrayList<String>();
        while (je != null) {
            String name = JavaCompareUtilities.getJavaElementID(je);
            if (name == null) {
                return null;
            }
            args.add(name);
            if (je instanceof org.eclipse.jdt.core.ICompilationUnit) break;
            je = je.getParent();
        }
        int n = args.size();
        String[] path = new String[n];
        for (int i = 0; i < n; ++i) {
            path[i] = (String)args.get(n - 1 - i);
        }
        return path;
    }

    private static IStructureComparator find(IStructureComparator tree, String[] path, int index) {
        Object[] children;
        if (tree != null && (children = tree.getChildren()) != null) {
            for (int i = 0; i < children.length; ++i) {
                String n2;
                IStructureComparator child = (IStructureComparator)children[i];
                if (!(child instanceof ITypedElement) || !(child instanceof DocumentRangeNode)) continue;
                String n1 = null;
                if (child instanceof DocumentRangeNode) {
                    n1 = ((DocumentRangeNode)child).getId();
                }
                if (n1 == null) {
                    n1 = ((ITypedElement)child).getName();
                }
                if (!n1.equals(n2 = path[index])) continue;
                if (index == path.length - 1) {
                    return child;
                }
                IStructureComparator result = JavaStructureCreator.find(child, path, index + 1);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    static boolean hasEdition(IJavaElement je) {
        if (je instanceof IMember && ((IMember)je).isBinary()) {
            return false;
        }
        switch (je.getElementType()) {
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    static class RewriteInfo {
        boolean fIsOut = false;
        JavaNode fAncestor = null;
        JavaNode fLeft = null;
        JavaNode fRight = null;
        ArrayList fChildren = new ArrayList();

        RewriteInfo() {
        }

        void add(IDiffElement diff) {
            this.fChildren.add(diff);
        }

        void setDiff(ICompareInput diff) {
            if (this.fIsOut) {
                return;
            }
            this.fIsOut = true;
            JavaNode a = (JavaNode)diff.getAncestor();
            JavaNode y = (JavaNode)diff.getLeft();
            JavaNode m = (JavaNode)diff.getRight();
            if (a != null) {
                if (this.fAncestor != null) {
                    return;
                }
                this.fAncestor = a;
            }
            if (y != null) {
                if (this.fLeft != null) {
                    return;
                }
                this.fLeft = y;
            }
            if (m != null) {
                if (this.fRight != null) {
                    return;
                }
                this.fRight = m;
            }
            this.fIsOut = false;
        }

        boolean matches() {
            return !this.fIsOut && this.fAncestor != null && this.fLeft != null && this.fRight != null;
        }
    }

    static class ProblemFactory
    implements IProblemFactory {
        ProblemFactory() {
        }

        public IProblem createProblem(char[] originatingFileName, int problemId, String[] arguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
            DefaultProblem problem = new DefaultProblem(originatingFileName, "", problemId, arguments, severity, startPosition, endPosition, lineNumber);
            if (problem.isError() && (problemId & 0x40000000) != 0) {
                throw new ParseError();
            }
            return problem;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public String getLocalizedMessage(int problemId, String[] problemArguments) {
            return "" + problemId;
        }
    }

    private static class ParseError
    extends RuntimeException {
        private ParseError() {
        }
    }
}

