/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class TypeSelectionDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fElementKinds;

    public TypeSelectionDialog(Shell parent, IRunnableContext context, int elementKinds, IJavaSearchScope scope) {
        super(parent, (ILabelProvider)new TypeInfoLabelProvider(16), (ILabelProvider)new TypeInfoLabelProvider(40));
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)scope);
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKinds = elementKinds;
        this.setUpperListLabel(JavaUIMessages.getString("TypeSelectionDialog.upperLabel"));
        this.setLowerListLabel(JavaUIMessages.getString("TypeSelectionDialog.lowerLabel"));
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        this.fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)new TypeFilterMatcher());
        this.fFilteredList.setComparator((Comparator)new StringComparator());
        return list;
    }

    public int open() {
        final ArrayList typeList = new ArrayList();
        try {
            if (this.isCacheUpToDate()) {
                AllTypesCache.getTypes(this.fScope, this.fElementKinds, null, typeList);
            } else {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        AllTypesCache.getTypes(TypeSelectionDialog.this.fScope, TypeSelectionDialog.this.fElementKinds, monitor, typeList);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                };
                this.fRunnableContext.run(true, true, runnable);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, JavaUIMessages.getString("TypeSelectionDialog.error3Title"), JavaUIMessages.getString("TypeSelectionDialog.error3Message"));
            return 1;
        }
        catch (InterruptedException e) {
            return 1;
        }
        if (typeList.isEmpty()) {
            String title = JavaUIMessages.getString("TypeSelectionDialog.notypes.title");
            String message = JavaUIMessages.getString("TypeSelectionDialog.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        Object[] typeRefs = typeList.toArray(new TypeInfo[typeList.size()]);
        this.setElements(typeRefs);
        return super.open();
    }

    protected void computeResult() {
        TypeInfo ref = (TypeInfo)this.getLowerSelectedElement();
        if (ref == null) {
            return;
        }
        try {
            IType type = ref.resolveType(this.fScope);
            if (type == null) {
                String title = JavaUIMessages.getString("TypeSelectionDialog.errorTitle");
                String message = JavaUIMessages.getFormattedString("TypeSelectionDialog.dialogMessage", ref.getPath());
                MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                this.setResult(null);
            } else {
                ArrayList<IType> result = new ArrayList<IType>(1);
                result.add(type);
                this.setResult(result);
            }
        }
        catch (JavaModelException e) {
            String title = JavaUIMessages.getString("TypeSelectionDialog.errorTitle");
            String message = JavaUIMessages.getString("TypeSelectionDialog.errorMessage");
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)e.getStatus());
            this.setResult(null);
        }
    }

    private boolean isCacheUpToDate() throws InvocationTargetException, InterruptedException {
        final boolean[] result = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    result[0] = AllTypesCache.isCacheUpToDate(monitor);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
        return result[0];
    }

    private static class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object left, Object right) {
            String leftString = (String)left;
            String rightString = (String)right;
            if (Strings.isLowerCase(leftString.charAt(0)) && !Strings.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(rightString.charAt(0)) && !Strings.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            int result = leftString.compareToIgnoreCase(rightString);
            if (result == 0) {
                result = leftString.compareTo(rightString);
            }
            return result;
        }
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        private TypeFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
            int qualifierIndex = pattern.lastIndexOf(".");
            if (qualifierIndex == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern), ignoreCase, igoreWildCards);
            } else {
                this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern.substring(qualifierIndex + 1)), ignoreCase, igoreWildCards);
            }
        }

        public boolean match(Object element) {
            if (!(element instanceof TypeInfo)) {
                return false;
            }
            TypeInfo type = (TypeInfo)element;
            if (!this.fMatcher.match(type.getTypeName())) {
                return false;
            }
            if (this.fQualifierMatcher == null) {
                return true;
            }
            return this.fQualifierMatcher.match(type.getTypeContainerName());
        }

        private String adjustPattern(String pattern) {
            int length = pattern.length();
            if (length > 0) {
                switch (pattern.charAt(length - 1)) {
                    case '<': {
                        pattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case '*': {
                        break;
                    }
                    default: {
                        pattern = pattern + '*';
                    }
                }
            }
            return pattern;
        }
    }
}

