/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencePageSupport;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TodoTaskConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.TodoTaskPreferencePage;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TodoTaskPropertyPage
extends PropertyPage {
    private TodoTaskConfigurationBlock fConfigurationBlock;
    private Control fConfigurationBlockControl;
    private SelectionButtonDialogField fUseWorkspaceSettings;
    private SelectionButtonDialogField fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private IStatus fBlockStatus;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public TodoTaskPropertyPage() {
        this.setDescription(PreferencesMessages.getString("TodoTaskPropertyPage.description"));
        this.fBlockStatus = new StatusInfo();
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                TodoTaskPropertyPage.this.doDialogFieldChanged(field);
            }
        };
        this.fUseWorkspaceSettings = new SelectionButtonDialogField(16);
        this.fUseWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useworkspacesettings.label"));
        this.fChangeWorkspaceSettings = new SelectionButtonDialogField(8);
        this.fChangeWorkspaceSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useworkspacesettings.change"));
        this.fChangeWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.attachDialogField(this.fChangeWorkspaceSettings);
        this.fUseProjectSettings = new SelectionButtonDialogField(16);
        this.fUseProjectSettings.setDialogFieldListener(listener);
        this.fUseProjectSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useprojectsettings.label"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.tasktags_property_page_context");
    }

    protected Control createContents(Composite parent) {
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                TodoTaskPropertyPage.this.fBlockStatus = status;
                TodoTaskPropertyPage.this.doStatusChanged();
            }
        };
        this.fConfigurationBlock = new TodoTaskConfigurationBlock(listener, this.getProject());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fUseWorkspaceSettings.doFillIntoGrid(composite, 1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fUseWorkspaceSettings.getSelectionButton(null));
        this.fChangeWorkspaceSettings.doFillIntoGrid(composite, 1);
        GridData data = (GridData)this.fChangeWorkspaceSettings.getSelectionButton(null).getLayoutData();
        data.horizontalIndent = this.convertWidthInCharsToPixels(3);
        data.horizontalAlignment = 1;
        this.fUseProjectSettings.doFillIntoGrid(composite, 1);
        data = new GridData(272);
        data.horizontalSpan = 1;
        data.horizontalIndent = this.convertWidthInCharsToPixels(2);
        this.fConfigurationBlockControl = this.fConfigurationBlock.createContents(composite);
        this.fConfigurationBlockControl.setLayoutData((Object)data);
        boolean useProjectSettings = this.fConfigurationBlock.hasProjectSpecificOptions();
        this.fUseProjectSettings.setSelection(useProjectSettings);
        this.fUseWorkspaceSettings.setSelection(!useProjectSettings);
        this.updateEnableState();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private boolean useProjectSettings() {
        return this.fUseProjectSettings.isSelected();
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fChangeWorkspaceSettings) {
            TodoTaskPreferencePage page = new TodoTaskPreferencePage();
            PreferencePageSupport.showPreferencePage(this.getShell(), "org.eclipse.jdt.ui.preferences.TodoTaskPreferencePage", (IPreferencePage)page);
        } else {
            this.updateEnableState();
            this.doStatusChanged();
        }
    }

    private void doStatusChanged() {
        this.updateStatus((IStatus)(this.useProjectSettings() ? this.fBlockStatus : new StatusInfo()));
    }

    private IJavaProject getProject() {
        return (IJavaProject)this.getElement().getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = TodoTaskPropertyPage.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
    }

    private void updateEnableState() {
        this.fConfigurationBlock.setEnabled(this.useProjectSettings());
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.fConfigurationBlock.performDefaults();
            this.fUseProjectSettings.setSelection(false);
            this.fUseWorkspaceSettings.setSelection(true);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        return this.fConfigurationBlock.performOk(this.useProjectSettings());
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

