/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;

public final class DestinationContentProvider
extends StandardJavaElementContentProvider {
    private IReorgDestinationValidator fValidator;

    public DestinationContentProvider(IReorgDestinationValidator validator) {
        super(true);
        this.fValidator = validator;
    }

    public boolean hasChildren(Object element) {
        IResource resource;
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            if (!this.fValidator.canChildrenBeDestinations(javaElement)) {
                return false;
            }
            if (javaElement.getElementType() == 3 && ((IPackageFragmentRoot)javaElement).isArchive()) {
                return false;
            }
        } else if (element instanceof IResource && !this.fValidator.canChildrenBeDestinations(resource = (IResource)element)) {
            return false;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaModel) {
                return DestinationContentProvider.concatenate(this.getJavaProjects((IJavaModel)parentElement), DestinationContentProvider.getOpenNonJavaProjects((IJavaModel)parentElement));
            }
            Object[] children = super.getChildren(parentElement);
            ArrayList<Object> result = new ArrayList<Object>(children.length);
            for (int i = 0; i < children.length; ++i) {
                IResource resource;
                if (children[i] instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)children[i];
                    if (!this.fValidator.canElementBeDestination(javaElement) && !this.fValidator.canChildrenBeDestinations(javaElement)) continue;
                    result.add(javaElement);
                    continue;
                }
                if (!(children[i] instanceof IResource) || !this.fValidator.canElementBeDestination(resource = (IResource)children[i]) && !this.fValidator.canChildrenBeDestinations(resource)) continue;
                result.add(resource);
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new Object[0];
        }
    }

    private static Object[] getOpenNonJavaProjects(IJavaModel model) throws JavaModelException {
        Object[] nonJavaProjects = model.getNonJavaResources();
        ArrayList<IProject> result = new ArrayList<IProject>(nonJavaProjects.length);
        for (int i = 0; i < nonJavaProjects.length; ++i) {
            IProject project = (IProject)nonJavaProjects[i];
            if (!project.isOpen()) continue;
            result.add(project);
        }
        return result.toArray();
    }
}

