/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.TypedSource;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.TypedSourceTransfer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;

    public PasteAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        Assert.isNotNull(clipboard);
        this.fClipboard = clipboard;
        this.setText(ReorgMessages.getString("PasteAction.4"));
        this.setDescription(ReorgMessages.getString("PasteAction.5"));
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_HOVER"));
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.paste_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canOperateOn(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canOperateOn(IStructuredSelection selection) throws JavaModelException {
        TransferData[] availableDataTypes = this.fClipboard.getAvailableTypes();
        List elements = selection.toList();
        IResource[] resources = ReorgUtils.getResources(elements);
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
        Paster[] pasters = this.createEnabledPasters(availableDataTypes);
        for (int i = 0; i < pasters.length; ++i) {
            if (!pasters[i].canPasteOn(javaElements, resources)) continue;
            return true;
        }
        return false;
    }

    private Paster[] createEnabledPasters(TransferData[] availableDataTypes) throws JavaModelException {
        Shell shell = this.getShell();
        ArrayList<Paster> result = new ArrayList<Paster>(2);
        Paster paster = new ProjectPaster(shell, this.fClipboard);
        if (paster.canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new JavaElementAndResourcePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new TypedSourcePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new FilePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        return result.toArray(new Paster[result.size()]);
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] result = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = clipboard.getContents(transfer);
            }
        });
        return result[0];
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] availableDataTypes) {
        for (int i = 0; i < availableDataTypes.length; ++i) {
            if (!transfer.isSupportedType(availableDataTypes[i])) continue;
            return true;
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        try {
            TransferData[] availableTypes = this.fClipboard.getAvailableTypes();
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            Paster[] pasters = this.createEnabledPasters(availableTypes);
            for (int i = 0; i < pasters.length; ++i) {
                if (!pasters[i].canPasteOn(javaElements, resources)) continue;
                pasters[i].paste(javaElements, resources, availableTypes);
                return;
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class TypedSourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected TypedSourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] availableTypes) throws JavaModelException {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)TypedSourceTransfer.getInstance(), availableTypes);
        }

        public boolean canPasteOn(IJavaElement[] selectedJavaElements, IResource[] selectedResources) throws JavaModelException {
            if (selectedResources.length != 0) {
                return false;
            }
            TypedSource[] typedSources = this.getClipboardTypedSources(this.fAvailableTypes);
            IJavaElement destination = TypedSourcePaster.getTarget(selectedJavaElements, selectedResources);
            if (destination instanceof IJavaElement) {
                return ReorgTypedSourcePasteStarter.create(typedSources, destination) != null;
            }
            return false;
        }

        public void paste(IJavaElement[] selectedJavaElements, IResource[] selectedResources, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            TypedSource[] typedSources = this.getClipboardTypedSources(availableTypes);
            IJavaElement destination = TypedSourcePaster.getTarget(selectedJavaElements, selectedResources);
            ReorgTypedSourcePasteStarter.create(typedSources, destination).run(this.getShell());
        }

        private static IJavaElement getTarget(IJavaElement[] selectedJavaElements, IResource[] selectedResources) {
            Assert.isTrue(selectedResources.length == 0);
            if (selectedJavaElements.length == 1) {
                return TypedSourcePaster.getAsTypeOrCu(selectedJavaElements[0]);
            }
            Object parent = new ParentChecker(selectedResources, selectedJavaElements).getCommonParent();
            if (parent instanceof IJavaElement) {
                return TypedSourcePaster.getAsTypeOrCu((IJavaElement)parent);
            }
            return null;
        }

        private static IJavaElement getAsTypeOrCu(IJavaElement element) {
            if (element.getElementType() == 5 || element.getElementType() == 7) {
                return element;
            }
            IJavaElement ancestorType = element.getAncestor(7);
            if (ancestorType != null) {
                return ancestorType;
            }
            return ReorgUtils.getCompilationUnit(element);
        }

        private static class PasteTypedSourcesRefactoring
        extends Refactoring {
            private final TypedSource[] fSources;
            private IJavaElement fDestination;

            static PasteTypedSourcesRefactoring create(TypedSource[] sources) {
                if (!PasteTypedSourcesRefactoring.isAvailable(sources)) {
                    return null;
                }
                return new PasteTypedSourcesRefactoring(sources);
            }

            public RefactoringStatus setDestination(IJavaElement destination) {
                this.fDestination = destination;
                if (ReorgUtils.getCompilationUnit(destination) == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.getString("PasteAction.wrong_destination"));
                }
                if (!destination.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.getString("PasteAction.element_doesnot_exist"));
                }
                if (!this.canPasteAll(destination)) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.getString("PasteAction.invalid_destination"));
                }
                return new RefactoringStatus();
            }

            private boolean canPasteAll(IJavaElement destination) {
                for (int i = 0; i < this.fSources.length; ++i) {
                    if (PasteTypedSourcesRefactoring.canPaste(this.fSources[i].getType(), destination)) continue;
                    return false;
                }
                return true;
            }

            private static boolean canPaste(int elementType, IJavaElement destination) {
                IType ancestorType = PasteTypedSourcesRefactoring.getAncestorType(destination);
                if (ancestorType != null) {
                    return PasteTypedSourcesRefactoring.canPasteToType(elementType);
                }
                return PasteTypedSourcesRefactoring.canPasteToCu(elementType);
            }

            private static boolean canPasteToType(int elementType) {
                return elementType == 7 || elementType == 8 || elementType == 10 || elementType == 9;
            }

            private static boolean canPasteToCu(int elementType) {
                return elementType == 11 || elementType == 7 || elementType == 13;
            }

            PasteTypedSourcesRefactoring(TypedSource[] sources) {
                Assert.isNotNull(sources);
                Assert.isTrue(sources.length != 0);
                this.fSources = sources;
            }

            private static boolean isAvailable(TypedSource[] sources) {
                return sources != null && sources.length > 0;
            }

            public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
                return new RefactoringStatus();
            }

            public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
                RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.getDestinationCu()}), this.getValidationContext());
                return result;
            }

            public Change createChange(IProgressMonitor pm) throws CoreException {
                ASTParser p = ASTParser.newParser((int)2);
                p.setSource(this.getDestinationCu());
                CompilationUnit cuNode = (CompilationUnit)p.createAST(pm);
                OldASTRewrite rewrite = new OldASTRewrite((ASTNode)cuNode);
                for (int i = 0; i < this.fSources.length; ++i) {
                    this.pasteSource(this.fSources[i], rewrite, cuNode);
                }
                TextBuffer textBuffer = TextBuffer.create(this.getDestinationCu().getBuffer().getContents());
                MultiTextEdit rootEdit = new MultiTextEdit();
                rewrite.rewriteNode(textBuffer, (TextEdit)rootEdit);
                CompilationUnitChange result = new CompilationUnitChange(ReorgMessages.getString("PasteAction.change.name"), this.getDestinationCu());
                if (this.getDestinationCu().isWorkingCopy()) {
                    result.setSaveMode(4);
                }
                TextChangeCompatibility.addTextEdit((TextChange)result, ReorgMessages.getString("PasteAction.edit.name"), (TextEdit)rootEdit);
                return result;
            }

            private void pasteSource(TypedSource source, OldASTRewrite rewrite, CompilationUnit cuNode) throws CoreException {
                ASTNode node = this.createAndInsertNewNode(source, cuNode, rewrite);
                if (node != null) {
                    rewrite.markAsInserted(node);
                }
            }

            private ASTNode createAndInsertNewNode(TypedSource source, CompilationUnit cuNode, OldASTRewrite rewrite) throws CoreException {
                ASTNode destinationNode = this.getDestinationNodeForSourceElement(this.fDestination, source.getType(), cuNode);
                if (destinationNode == null) {
                    return null;
                }
                if (destinationNode.getNodeType() == 15) {
                    ASTNode nodeToInsert = this.createNewNodeToInsertToCu(source, rewrite);
                    PasteTypedSourcesRefactoring.insertToCu(nodeToInsert, (CompilationUnit)destinationNode);
                    return nodeToInsert;
                }
                if (destinationNode.getNodeType() == 55) {
                    ASTNode nodeToInsert = this.createNewNodeToInsertToType(source, rewrite);
                    PasteTypedSourcesRefactoring.insertToType(nodeToInsert, (TypeDeclaration)destinationNode);
                    return nodeToInsert;
                }
                return null;
            }

            private static void insertToType(ASTNode node, TypeDeclaration typeDeclaration) {
                switch (node.getNodeType()) {
                    case 23: 
                    case 28: 
                    case 31: 
                    case 55: {
                        typeDeclaration.bodyDeclarations().add(ASTNodes.getInsertionIndex((BodyDeclaration)node, typeDeclaration.bodyDeclarations()), node);
                        break;
                    }
                    default: {
                        Assert.isTrue(false, String.valueOf(node.getNodeType()));
                    }
                }
            }

            private static void insertToCu(ASTNode node, CompilationUnit cuNode) {
                switch (node.getNodeType()) {
                    case 55: {
                        cuNode.types().add(ASTNodes.getInsertionIndex((BodyDeclaration)((TypeDeclaration)node), cuNode.types()), node);
                        break;
                    }
                    case 26: {
                        cuNode.imports().add(node);
                        break;
                    }
                    case 35: {
                        if (cuNode.getPackage() != null) break;
                        cuNode.setPackage((PackageDeclaration)node);
                        break;
                    }
                    default: {
                        Assert.isTrue(false, String.valueOf(node.getNodeType()));
                    }
                }
            }

            private ASTNode getDestinationNodeForSourceElement(IJavaElement destinationElement, int elementType, CompilationUnit cuNode) throws JavaModelException {
                IType ancestorType = PasteTypedSourcesRefactoring.getAncestorType(destinationElement);
                if (ancestorType != null) {
                    return ASTNodeSearchUtil.getTypeDeclarationNode(ancestorType, cuNode);
                }
                if (elementType == 7 || elementType == 11 || elementType == 13 || elementType == 12) {
                    return cuNode;
                }
                return null;
            }

            private static IType getAncestorType(IJavaElement destinationElement) {
                return destinationElement.getElementType() == 7 ? (IType)destinationElement : (IType)destinationElement.getAncestor(7);
            }

            private ASTNode createNewNodeToInsertToCu(TypedSource source, OldASTRewrite rewrite) {
                switch (source.getType()) {
                    case 7: {
                        return rewrite.createStringPlaceholder(source.getSource(), 55);
                    }
                    case 11: {
                        return rewrite.createStringPlaceholder(source.getSource(), 35);
                    }
                    case 13: {
                        return rewrite.createStringPlaceholder(source.getSource(), 26);
                    }
                }
                Assert.isTrue(false, String.valueOf(source.getType()));
                return null;
            }

            private ASTNode createNewNodeToInsertToType(TypedSource source, OldASTRewrite rewrite) {
                switch (source.getType()) {
                    case 7: {
                        return rewrite.createStringPlaceholder(source.getSource(), 55);
                    }
                    case 9: {
                        return rewrite.createStringPlaceholder(source.getSource(), 31);
                    }
                    case 8: {
                        return rewrite.createStringPlaceholder(source.getSource(), 23);
                    }
                    case 10: {
                        return rewrite.createStringPlaceholder(source.getSource(), 28);
                    }
                }
                Assert.isTrue(false);
                return null;
            }

            private ICompilationUnit getDestinationCu() {
                return ReorgUtils.getCompilationUnit(this.fDestination);
            }

            public String getName() {
                return ReorgMessages.getString("PasteAction.name");
            }
        }

        private static class ReorgTypedSourcePasteStarter {
            private final PasteTypedSourcesRefactoring fPasteRefactoring;

            private ReorgTypedSourcePasteStarter(PasteTypedSourcesRefactoring pasteRefactoring) {
                Assert.isNotNull((Object)pasteRefactoring);
                this.fPasteRefactoring = pasteRefactoring;
            }

            public static ReorgTypedSourcePasteStarter create(TypedSource[] typedSources, IJavaElement destination) {
                Assert.isNotNull(typedSources);
                Assert.isNotNull(destination);
                PasteTypedSourcesRefactoring pasteRefactoring = PasteTypedSourcesRefactoring.create(typedSources);
                if (pasteRefactoring == null) {
                    return null;
                }
                if (!pasteRefactoring.setDestination(destination).isOK()) {
                    return null;
                }
                return new ReorgTypedSourcePasteStarter(pasteRefactoring);
            }

            public void run(Shell parent) throws InterruptedException, InvocationTargetException {
                ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
                new RefactoringExecutionHelper(this.fPasteRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), false, parent, (IRunnableContext)context).perform();
            }
        }
    }

    private static class JavaElementAndResourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected JavaElementAndResourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] javaElements, IResource[] resources, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            Object destination;
            IJavaElement[] clipboardJavaElements;
            IResource[] clipboardResources = this.getClipboardResources(availableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardJavaElements = this.getClipboardJavaElements(availableTypes)) == null) {
                clipboardJavaElements = new IJavaElement[]{};
            }
            if ((destination = this.getTarget(javaElements, resources)) instanceof IJavaElement) {
                ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IJavaElement)destination).run(this.getShell());
            } else if (destination instanceof IResource) {
                ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IResource)destination).run(this.getShell());
            }
        }

        private Object getTarget(IJavaElement[] javaElements, IResource[] resources) {
            if (javaElements.length + resources.length == 1) {
                if (javaElements.length == 1) {
                    return javaElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(javaElements, resources);
        }

        private Object getCommonParent(IJavaElement[] javaElements, IResource[] resources) {
            return new ParentChecker(resources, javaElements).getCommonParent();
        }

        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources) throws JavaModelException {
            Object destination;
            IJavaElement[] clipboardJavaElements;
            IResource[] clipboardResources = this.getClipboardResources(this.fAvailableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardJavaElements = this.getClipboardJavaElements(this.fAvailableTypes)) == null) {
                clipboardJavaElements = new IJavaElement[]{};
            }
            if ((destination = this.getTarget(javaElements, resources)) instanceof IJavaElement) {
                return ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IJavaElement)destination) != null;
            }
            if (destination instanceof IResource) {
                return ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IResource)destination) != null;
            }
            return false;
        }

        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableTypes) || PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes);
        }
    }

    private static class FilePaster
    extends Paster {
        protected FilePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] javaElements, IResource[] resources, TransferData[] availableTypes) throws JavaModelException {
            String[] fileData = this.getClipboardFiles(availableTypes);
            if (fileData == null) {
                return;
            }
            IContainer container = this.getAsContainer(this.getTarget(javaElements, resources));
            if (container == null) {
                return;
            }
            new CopyFilesAndFoldersOperation(this.getShell()).copyFiles(fileData, container);
        }

        private Object getTarget(IJavaElement[] javaElements, IResource[] resources) {
            if (javaElements.length + resources.length == 1) {
                if (javaElements.length == 1) {
                    return javaElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(javaElements, resources);
        }

        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources) throws JavaModelException {
            Object target = this.getTarget(javaElements, resources);
            return target != null && this.canPasteFilesOn(this.getAsContainer(target));
        }

        public boolean canEnable(TransferData[] availableDataTypes) throws JavaModelException {
            return PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), availableDataTypes);
        }

        private boolean canPasteFilesOn(Object target) {
            boolean isPackageFragment = target instanceof IPackageFragment;
            boolean isJavaProject = target instanceof IJavaProject;
            boolean isPackageFragmentRoot = target instanceof IPackageFragmentRoot;
            boolean isContainer = target instanceof IContainer;
            if (!(isPackageFragment || isJavaProject || isPackageFragmentRoot || isContainer)) {
                return false;
            }
            if (isContainer) {
                return true;
            }
            IJavaElement element = (IJavaElement)target;
            return !element.isReadOnly();
        }

        private IContainer getAsContainer(Object target) throws JavaModelException {
            if (target == null) {
                return null;
            }
            if (target instanceof IContainer) {
                return (IContainer)target;
            }
            if (target instanceof IFile) {
                return ((IFile)target).getParent();
            }
            return this.getAsContainer(((IJavaElement)target).getCorrespondingResource());
        }

        private String[] getClipboardFiles(TransferData[] availableDataTypes) {
            FileTransfer transfer = FileTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String[])PasteAction.getContents(this.getClipboard(), (Transfer)transfer, this.getShell());
            }
            return null;
        }

        private Object getCommonParent(IJavaElement[] javaElements, IResource[] resources) {
            return new ParentChecker(resources, javaElements).getCommonParent();
        }
    }

    private static class ProjectPaster
    extends Paster {
        protected ProjectPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] availableDataTypes) {
            boolean resourceTransfer = PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableDataTypes);
            boolean javaElementTransfer = PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableDataTypes);
            if (!javaElementTransfer) {
                return this.canPasteSimpleProjects(availableDataTypes);
            }
            if (!resourceTransfer) {
                return this.canPasteJavaProjects(availableDataTypes);
            }
            return this.canPasteJavaProjects(availableDataTypes) && this.canPasteSimpleProjects(availableDataTypes);
        }

        public void paste(IJavaElement[] javaElements, IResource[] resources, TransferData[] availableTypes) {
            this.pasteProjects(availableTypes);
        }

        private void pasteProjects(TransferData[] availableTypes) {
            this.pasteProjects(this.getProjectsToPaste(availableTypes));
        }

        private void pasteProjects(IProject[] projects) {
            Shell shell = this.getShell();
            for (int i = 0; i < projects.length; ++i) {
                new CopyProjectOperation(shell).copyProject(projects[i]);
            }
        }

        private IProject[] getProjectsToPaste(TransferData[] availableTypes) {
            IResource[] resources = this.getClipboardResources(availableTypes);
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableTypes);
            HashSet<IResource> result = new HashSet<IResource>();
            if (resources != null) {
                result.addAll(Arrays.asList(resources));
            }
            if (javaElements != null) {
                result.addAll(Arrays.asList(ReorgUtils.getNotNulls(ReorgUtils.getResources(javaElements))));
            }
            Assert.isTrue(result.size() > 0);
            return result.toArray(new IProject[result.size()]);
        }

        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources) {
            return true;
        }

        private boolean canPasteJavaProjects(TransferData[] availableDataTypes) {
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableDataTypes);
            return javaElements != null && javaElements.length != 0 && !ReorgUtils.hasElementsNotOfType(javaElements, 2);
        }

        private boolean canPasteSimpleProjects(TransferData[] availableDataTypes) {
            IResource[] resources = this.getClipboardResources(availableDataTypes);
            if (resources == null || resources.length == 0) {
                return false;
            }
            for (int i = 0; i < resources.length; ++i) {
                if (resources[i].getType() == 4 && ((IProject)resources[i]).isOpen()) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class Paster {
        private final Shell fShell;
        private final Clipboard fClipboard2;

        protected Paster(Shell shell, Clipboard clipboard) {
            this.fShell = shell;
            this.fClipboard2 = clipboard;
        }

        protected final Shell getShell() {
            return this.fShell;
        }

        protected final Clipboard getClipboard() {
            return this.fClipboard2;
        }

        protected final IResource[] getClipboardResources(TransferData[] availableDataTypes) {
            ResourceTransfer transfer = ResourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IResource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final IJavaElement[] getClipboardJavaElements(TransferData[] availableDataTypes) {
            JavaElementTransfer transfer = JavaElementTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IJavaElement[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final TypedSource[] getClipboardTypedSources(TransferData[] availableDataTypes) {
            TypedSourceTransfer transfer = TypedSourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (TypedSource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        public abstract void paste(IJavaElement[] var1, IResource[] var2, TransferData[] var3) throws JavaModelException, InterruptedException, InvocationTargetException;

        public abstract boolean canEnable(TransferData[] var1) throws JavaModelException;

        public abstract boolean canPasteOn(IJavaElement[] var1, IResource[] var2) throws JavaModelException;
    }
}

