/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class JavaTypeCompletionProposal
extends JavaCompletionProposal {
    protected final ICompilationUnit fCompilationUnit;
    private final String fUnqualifiedTypeName;
    private final String fFullyQualifiedTypeName;

    private static String unqualify(String typeName) {
        if (typeName == null) {
            return null;
        }
        int index = typeName.lastIndexOf(46);
        return index == -1 ? typeName : typeName.substring(index + 1);
    }

    private static String qualify(String typeName, String packageName) {
        if (packageName == null) {
            return typeName;
        }
        if (typeName == null) {
            return null;
        }
        if (packageName.length() == 0) {
            return typeName;
        }
        return packageName + '.' + typeName;
    }

    public JavaTypeCompletionProposal(String replacementString, ICompilationUnit cu, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, cu, replacementOffset, replacementLength, image, displayString, relevance, null, null);
    }

    public JavaTypeCompletionProposal(String replacementString, ICompilationUnit cu, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, String typeName, String packageName) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.fCompilationUnit = cu;
        this.fUnqualifiedTypeName = JavaTypeCompletionProposal.unqualify(typeName);
        this.fFullyQualifiedTypeName = JavaTypeCompletionProposal.qualify(typeName, packageName);
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportsStructure impStructure) throws CoreException, BadLocationException {
        IType[] types;
        if (impStructure != null && (types = impStructure.getCompilationUnit().getTypes()).length > 0 && types[0].getSourceRange().getOffset() <= offset) {
            this.setReplacementString(impStructure.addImport(this.getReplacementString()));
            return true;
        }
        return false;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            ImportsStructure impStructure = null;
            if (this.fCompilationUnit != null) {
                IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference(store);
                int threshold = JavaPreferencesSettings.getImportNumberThreshold(store);
                impStructure = new ImportsStructure(this.fCompilationUnit, prefOrder, threshold, true);
            }
            if (this.updateReplacementString(document, trigger, offset, impStructure)) {
                this.setCursorPosition(this.getReplacementString().length());
            }
            super.apply(document, trigger, offset);
            if (impStructure != null) {
                int oldLen = document.getLength();
                impStructure.create(false, null);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        boolean isValid = super.validate(document, offset, event);
        if (isValid) {
            return true;
        }
        return this.fUnqualifiedTypeName != null && this.startsWith(document, offset, this.fUnqualifiedTypeName) || this.fFullyQualifiedTypeName != null && this.startsWith(document, offset, this.fFullyQualifiedTypeName);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fUnqualifiedTypeName;
    }
}

