/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class JavaUILabelProvider
extends LabelProvider
implements IColorProvider {
    protected JavaElementImageProvider fImageLabelProvider = new JavaElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private ArrayList fLabelDecorators = null;
    private int fImageFlags;
    private int fTextFlags;

    public JavaUILabelProvider() {
        this(1, 1);
    }

    public JavaUILabelProvider(int textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(decorator);
    }

    public final void setTextFlags(int textFlags) {
        this.fTextFlags = textFlags;
    }

    public final void setImageFlags(int imageFlags) {
        this.fImageFlags = imageFlags;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final int getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object element) {
        return this.getImageFlags();
    }

    protected int evaluateTextFlags(Object element) {
        return this.getTextFlags();
    }

    protected Image decorateImage(Image image, Object element) {
        if (this.fLabelDecorators != null && image != null) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                image = decorator.decorateImage(image, element);
            }
        }
        return image;
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        if (result == null && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getImage(element);
        }
        return this.decorateImage(result, element);
    }

    protected String decorateText(String text, Object element) {
        if (this.fLabelDecorators != null && text.length() > 0) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                text = decorator.decorateText(text, element);
            }
        }
        return text;
    }

    public String getText(Object element) {
        String result = JavaElementLabels.getTextLabel(element, this.evaluateTextFlags(element));
        if (result.length() == 0 && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getText(element);
        }
        return this.decorateText(result, element);
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.dispose();
            }
            this.fLabelDecorators = null;
        }
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.addListener(listener);
            }
        }
        super.addListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.removeListener(listener);
            }
        }
        super.removeListener(listener);
    }

    public static ILabelDecorator[] getDecorators(boolean errortick, ILabelDecorator extra) {
        if (errortick) {
            if (extra == null) {
                return new ILabelDecorator[0];
            }
            return new ILabelDecorator[]{extra};
        }
        if (extra != null) {
            return new ILabelDecorator[]{extra};
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

