/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.r21.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolder;

public class CTabItem
extends Item {
    CTabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    String toolTipText;
    Control control;
    private Image disabledImage;
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 4;
    static final int TOP_MARGIN = 3;
    static final int BOTTOM_MARGIN = 3;
    private static final int INTERNAL_SPACING = 2;
    private static final String ellipsis = "...";
    String shortenedText;
    int shortenedTextWidth;

    public CTabItem(CTabFolder parent, int style) {
        this(parent, style, parent.getItemCount());
    }

    public CTabItem(CTabFolder parent, int style, int index) {
        super((Widget)parent, CTabItem.checkStyle(style));
        parent.createItem(this, index);
    }

    private static int checkStyle(int style) {
        return 0;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Display getDisplay() {
        if (this.parent == null) {
            SWT.error((int)24);
        }
        return this.parent.getDisplay();
    }

    public Image getDisabledImage() {
        return this.disabledImage;
    }

    public CTabFolder getParent() {
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void onPaint(GC gc, boolean isSelected) {
        Image temp;
        if (this.width == 0 || this.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        Color highlightShadow = display.getSystemColor(20);
        Color normalShadow = display.getSystemColor(18);
        int index = this.parent.indexOf(this);
        if (isSelected) {
            Rectangle bounds = null;
            bounds = !this.parent.onBottom ? (index == this.parent.topTabIndex ? new Rectangle(this.x + 1, this.y + 1, this.width - 2, this.height - 1) : new Rectangle(this.x + 2, this.y + 1, this.width - 3, this.height - 1)) : (index == this.parent.topTabIndex ? new Rectangle(this.x + 1, this.y + 1, this.width - 2, this.height - 2) : new Rectangle(this.x + 2, this.y + 1, this.width - 3, this.height - 2));
            if (this.parent.backgroundImage != null) {
                Rectangle imageRect = this.parent.backgroundImage.getBounds();
                gc.drawImage(this.parent.backgroundImage, 0, 0, imageRect.width, imageRect.height, bounds.x, bounds.y, bounds.width, bounds.height);
            } else if (this.parent.gradientColors != null) {
                Color oldBackground = gc.getBackground();
                if (this.parent.gradientColors.length == 1) {
                    if (this.parent.gradientColors[0] != null) {
                        gc.setBackground(this.parent.gradientColors[0]);
                    }
                    gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                } else {
                    Color oldForeground = gc.getForeground();
                    Color lastColor = this.parent.gradientColors[0];
                    if (lastColor == null) {
                        lastColor = oldBackground;
                    }
                    int pos = 0;
                    for (int i = 0; i < this.parent.gradientPercents.length; ++i) {
                        gc.setForeground(lastColor);
                        lastColor = this.parent.gradientColors[i + 1];
                        if (lastColor == null) {
                            lastColor = oldBackground;
                        }
                        gc.setBackground(lastColor);
                        int gradientWidth = this.parent.gradientPercents[i] * bounds.width / 100 - pos;
                        gc.fillGradientRectangle(bounds.x + pos, bounds.y, gradientWidth, bounds.height, false);
                        pos += gradientWidth;
                    }
                    gc.setForeground(oldForeground);
                }
                gc.setBackground(oldBackground);
            }
            if (!this.parent.onBottom) {
                gc.setForeground(normalShadow);
                if (index != this.parent.topTabIndex) {
                    gc.drawLine(this.x + 1, this.y, this.x + 1, this.y);
                    gc.drawLine(this.x, this.y + 1, this.x, this.y + this.height - 2);
                    gc.drawLine(this.x, this.y + this.height - 1, this.x, this.y + this.height - 1);
                }
                gc.drawLine(this.x + this.width - 1, this.y, this.x + this.width - 1, this.y);
                gc.drawLine(this.x + this.width, this.y + 1, this.x + this.width, this.y + this.height - 2);
                gc.drawLine(this.x + this.width, this.y + this.height - 1, this.x + this.width, this.y + this.height - 1);
                gc.setForeground(highlightShadow);
                if (index != this.parent.topTabIndex) {
                    gc.drawLine(this.x + 2, this.y, this.x + 2, this.y);
                    gc.drawLine(this.x + 1, this.y + 1, this.x + 1, this.y + this.height - 2);
                    gc.drawLine(this.x + 1, this.y + this.height - 1, this.x + 1, this.y + this.height - 1);
                } else {
                    gc.drawLine(this.x, this.y, this.x, this.y + this.height - 1);
                }
                gc.drawLine(this.x + this.width - 2, this.y, this.x + this.width - 2, this.y);
                gc.drawLine(this.x + this.width - 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 2);
                gc.drawLine(this.x + this.width - 1, this.y + this.height - 1, this.x + this.width - 1, this.y + this.height - 1);
                if (index != this.parent.topTabIndex) {
                    gc.drawLine(this.x + 3, this.y, this.x + this.width - 3, this.y);
                } else {
                    gc.drawLine(this.x + 1, this.y, this.x + this.width - 3, this.y);
                }
            } else {
                gc.setForeground(normalShadow);
                if (index != this.parent.topTabIndex) {
                    gc.drawLine(this.x, this.y, this.x, this.y);
                    gc.drawLine(this.x, this.y + 1, this.x, this.y + this.height - 2);
                    gc.drawLine(this.x + 1, this.y + this.height - 1, this.x + 1, this.y + this.height - 1);
                }
                gc.drawLine(this.x + this.width, this.y, this.x + this.width, this.y);
                gc.drawLine(this.x + this.width, this.y + 1, this.x + this.width, this.y + this.height - 2);
                gc.drawLine(this.x + this.width - 1, this.y + this.height - 1, this.x + this.width - 1, this.y + this.height - 1);
                gc.setForeground(highlightShadow);
                if (index != this.parent.topTabIndex) {
                    gc.drawLine(this.x + 1, this.y, this.x + 1, this.y);
                    gc.drawLine(this.x + 1, this.y + 1, this.x + 1, this.y + this.height - 2);
                    gc.drawLine(this.x + 2, this.y + this.height - 1, this.x + 2, this.y + this.height - 1);
                } else {
                    gc.drawLine(this.x, this.y, this.x, this.y + this.height - 1);
                }
                gc.drawLine(this.x + this.width - 1, this.y, this.x + this.width - 1, this.y);
                gc.drawLine(this.x + this.width - 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 2);
                gc.drawLine(this.x + this.width - 2, this.y + this.height - 1, this.x + this.width - 2, this.y + this.height - 1);
                if (index != this.parent.topTabIndex) {
                    gc.drawLine(this.x + 1, this.y, this.x + this.width - 2, this.y);
                    gc.drawLine(this.x + 2, this.y + this.height - 1, this.x + this.width - 3, this.y + this.height - 1);
                } else {
                    gc.drawLine(this.x + 1, this.y, this.x + this.width - 2, this.y);
                    gc.drawLine(this.x + 1, this.y + this.height - 1, this.x + this.width - 3, this.y + this.height - 1);
                }
            }
            if (this.parent.isFocusControl()) {
                int height1;
                int width1;
                int y1;
                int x1;
                if (!this.parent.onBottom) {
                    if (index == this.parent.topTabIndex) {
                        x1 = this.x + 1;
                        y1 = this.y + 1;
                        width1 = this.width - 2;
                        height1 = this.height - 1;
                    } else {
                        x1 = this.x + 2;
                        y1 = this.y + 1;
                        width1 = this.width - 3;
                        height1 = this.height - 1;
                    }
                } else if (index == this.parent.topTabIndex) {
                    x1 = this.x + 1;
                    y1 = this.y + 1;
                    width1 = this.width - 2;
                    height1 = this.height - 2;
                } else {
                    x1 = this.x + 2;
                    y1 = this.y + 1;
                    width1 = this.width - 3;
                    height1 = this.height - 2;
                }
                gc.setBackground(display.getSystemColor(2));
                gc.setForeground(display.getSystemColor(1));
                gc.drawFocus(x1, y1, width1, height1);
            }
        } else {
            gc.setForeground(normalShadow);
            if (!this.parent.onBottom) {
                if (index != this.parent.topTabIndex && index != this.parent.getSelectionIndex() + 1) {
                    gc.drawLine(this.x, this.y, this.x, this.y + this.height / 2);
                }
            } else if (index != this.parent.topTabIndex && index != this.parent.getSelectionIndex() + 1) {
                gc.drawLine(this.x, this.y + this.height / 2, this.x, this.y + this.height - 1);
            }
        }
        int xDraw = this.x + 4;
        Image image = this.getImage();
        if (!isSelected && image != null && (temp = this.getDisabledImage()) != null) {
            image = temp;
        }
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            int imageX = xDraw;
            int imageHeight = Math.min(this.height - 3 - 3, imageBounds.height);
            int imageY = this.y + (this.height - imageHeight) / 2;
            int imageWidth = imageBounds.width * imageHeight / imageBounds.height;
            gc.drawImage(image, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, imageX, imageY, imageWidth, imageHeight);
            xDraw += imageWidth + 2;
        }
        int textWidth = this.x + this.width - xDraw - 4;
        if (isSelected && this.parent.showClose) {
            textWidth = this.x + this.width - xDraw - this.parent.closeBar.getSize().x - 4;
        }
        if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
            this.shortenedText = CTabItem.shortenText(gc, this.getText(), textWidth);
            this.shortenedTextWidth = textWidth;
        }
        String text = this.shortenedText;
        if (isSelected && this.parent.selectionForeground != null) {
            gc.setForeground(this.parent.selectionForeground);
        } else {
            gc.setForeground(this.parent.getForeground());
        }
        int textY = this.y + (this.height - gc.textExtent((String)text, (int)8).y) / 2;
        gc.drawText(text, xDraw, textY, 9);
        gc.setForeground(this.parent.getForeground());
    }

    private static String shortenText(GC gc, String text, int width) {
        if (gc.textExtent((String)text, (int)8).x <= width) {
            return text;
        }
        int ellipseWidth = gc.textExtent((String)ellipsis, (int)8).x;
        int length = text.length();
        for (int end = length - 1; end > 0; --end) {
            text = text.substring(0, end);
            int l1 = gc.textExtent((String)text, (int)8).x;
            if (l1 + ellipseWidth > width) continue;
            return text + ellipsis;
        }
        return text + ellipsis;
    }

    int preferredHeight(GC gc) {
        Image image = this.getImage();
        int height = 0;
        if (image != null) {
            height = image.getBounds().height;
        }
        String text = this.getText();
        height = Math.max(height, gc.textExtent((String)text, (int)8).y);
        return height + 3 + 3;
    }

    int preferredWidth(GC gc) {
        String text;
        int width = 0;
        Image image = this.getImage();
        if (image != null) {
            width += image.getBounds().width;
        }
        if ((text = this.getText()) != null) {
            if (image != null) {
                width += 2;
            }
            width += gc.textExtent((String)text, (int)8).x;
        }
        if (this.parent.showClose) {
            width += 2 + this.preferredHeight(gc);
        }
        return width + 4 + 4;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error((int)5);
            }
            if (control.getParent() != this.parent) {
                SWT.error((int)32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int index = this.parent.indexOf(this);
            if (index == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                this.control.setVisible(false);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.equals((Object)this.getImage())) {
            return;
        }
        super.setImage(image);
        this.parent.resetTabSize(true);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.equals((Object)this.getDisabledImage())) {
            return;
        }
        this.disabledImage = image;
        this.parent.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        this.shortenedText = null;
        this.shortenedTextWidth = 0;
        this.parent.resetTabSize(false);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

