/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;

public class Indents {
    private Indents() {
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Indents.isLineDelimiterChar(ch);
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static int computeIndent(String line, int tabWidth) {
        int result = 0;
        int blanks = 0;
        int size = line.length();
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++result;
                blanks = 0;
                continue;
            }
            if (Indents.isIndentChar(c)) {
                if (++blanks != tabWidth) continue;
                ++result;
                blanks = 0;
                continue;
            }
            return result;
        }
        return result;
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth) {
        if (line == null || indentsToRemove <= 0) {
            return line;
        }
        int start = 0;
        int indents = 0;
        int blanks = 0;
        int size = line.length();
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++indents;
                blanks = 0;
            } else if (Indents.isIndentChar(c)) {
                if (++blanks == tabWidth) {
                    ++indents;
                    blanks = 0;
                }
            } else {
                start = i;
                break;
            }
            if (indents != indentsToRemove) continue;
            start = i + 1;
            break;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String getIndentString(String line, int tabWidth) {
        int size = line.length();
        int end = 0;
        int blanks = 0;
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                end = i + 1;
                blanks = 0;
                continue;
            }
            if (!Indents.isIndentChar(c)) break;
            if (++blanks != tabWidth) continue;
            end = i + 1;
            blanks = 0;
        }
        if (end == 0) {
            return "";
        }
        if (end == size) {
            return line;
        }
        return line.substring(0, end);
    }

    public static int computeIndentLength(String line, int numberOfIndents, int tabWidth) {
        Assert.isTrue((numberOfIndents >= 0 ? 1 : 0) != 0);
        Assert.isTrue((tabWidth >= 0 ? 1 : 0) != 0);
        int size = line.length();
        int result = -1;
        int indents = 0;
        int blanks = 0;
        for (int i = 0; i < size && indents < numberOfIndents; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++indents;
                result = i;
                blanks = 0;
                continue;
            }
            if (!Indents.isIndentChar(c)) break;
            if (++blanks != tabWidth) continue;
            result = i;
            ++indents;
            blanks = 0;
        }
        if (indents < numberOfIndents) {
            return -1;
        }
        return result + 1;
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, String newIndent, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < nLines; ++i) {
                IRegion region = tracker.getLineInformation(i);
                int start = region.getOffset();
                int end = start + region.getLength();
                String line = code.substring(start, end);
                if (i == 0) {
                    buf.append(line);
                    continue;
                }
                buf.append(lineDelim);
                buf.append(newIndent);
                buf.append(Indents.trimIndent(line, codeIndentLevel, tabWidth));
            }
            return buf.toString();
        }
        catch (BadLocationException e) {
            return code;
        }
    }

    public static ReplaceEdit[] getChangeIndentEdits(String source, int sourceIndentLevel, int tabWidth, String newIndent) {
        ArrayList<ReplaceEdit> result = new ArrayList<ReplaceEdit>();
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(source);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return result.toArray(new ReplaceEdit[result.size()]);
            }
            for (int i = 1; i < nLines; ++i) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                String line = source.substring(offset, offset + region.getLength());
                int length = Indents.computeIndentLength(line, sourceIndentLevel, tabWidth);
                if (length >= 0) {
                    result.add(new ReplaceEdit(offset, length, newIndent));
                    continue;
                }
                length = Indents.computeIndent(line, tabWidth);
                result.add(new ReplaceEdit(offset, length, ""));
            }
        }
        catch (BadLocationException cannotHappen) {
            // empty catch block
        }
        return result.toArray(new ReplaceEdit[result.size()]);
    }
}

