/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public class OpenPreferencesAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public OpenPreferencesAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public OpenPreferencesAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("OpenPreferences.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.window.preferences");
        this.setToolTipText(WorkbenchMessages.getString("OpenPreferences.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.open_preferences_action_context");
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        PreferenceManager pm = WorkbenchPlugin.getDefault().getPreferenceManager();
        if (pm != null) {
            WorkbenchPreferenceDialog d = new WorkbenchPreferenceDialog(this.workbenchWindow.getShell(), pm);
            d.create();
            WorkbenchHelp.setHelp((Control)d.getShell(), "org.eclipse.ui.preference_dialog_context");
            d.open();
        }
    }

    public void dispose() {
        this.workbenchWindow = null;
    }
}

