/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.activities.CategoryEvent;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.activities.ICategoryListener;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.util.Util;

final class Category
implements ICategory {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = (class$org$eclipse$ui$internal$activities$Category == null ? (class$org$eclipse$ui$internal$activities$Category = Category.class$("org.eclipse.ui.internal.activities.Category")) : class$org$eclipse$ui$internal$activities$Category).getName().hashCode();
    private static final Set strongReferences = new HashSet();
    private Set categoryActivityBindings;
    private transient ICategoryActivityBinding[] categoryActivityBindingsAsArray;
    private List categoryListeners;
    private boolean defined;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private String name;
    private transient String string;
    private String description;
    static /* synthetic */ Class class$org$eclipse$ui$internal$activities$Category;
    static /* synthetic */ Class class$org$eclipse$ui$activities$ICategoryActivityBinding;

    Category(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
    }

    public void addCategoryListener(ICategoryListener categoryListener) {
        if (categoryListener == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners == null) {
            this.categoryListeners = new ArrayList();
        }
        if (!this.categoryListeners.contains(categoryListener)) {
            this.categoryListeners.add(categoryListener);
        }
        strongReferences.add(this);
    }

    public int compareTo(Object object) {
        Category castedObject = (Category)object;
        int compareTo = Util.compare(this.categoryActivityBindingsAsArray, castedObject.categoryActivityBindingsAsArray);
        if (compareTo == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Category)) {
            return false;
        }
        Category castedObject = (Category)object;
        boolean equals = true;
        equals &= Util.equals(this.categoryActivityBindings, castedObject.categoryActivityBindings);
        equals &= Util.equals(this.defined, castedObject.defined);
        equals &= Util.equals(this.id, castedObject.id);
        return equals &= Util.equals(this.name, castedObject.name);
    }

    void fireCategoryChanged(CategoryEvent categoryEvent) {
        if (categoryEvent == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners != null) {
            for (int i = 0; i < this.categoryListeners.size(); ++i) {
                ((ICategoryListener)this.categoryListeners.get(i)).categoryChanged(categoryEvent);
            }
        }
    }

    public Set getCategoryActivityBindings() {
        return this.categoryActivityBindings;
    }

    public String getId() {
        return this.id;
    }

    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.categoryActivityBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public void removeCategoryListener(ICategoryListener categoryListener) {
        if (categoryListener == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners != null) {
            this.categoryListeners.remove(categoryListener);
        }
        if (this.categoryListeners.isEmpty()) {
            strongReferences.remove(this);
        }
    }

    boolean setCategoryActivityBindings(Set categoryActivityBindings) {
        if (!Util.equals(categoryActivityBindings = Util.safeCopy(categoryActivityBindings, class$org$eclipse$ui$activities$ICategoryActivityBinding == null ? (class$org$eclipse$ui$activities$ICategoryActivityBinding = Category.class$("org.eclipse.ui.activities.ICategoryActivityBinding")) : class$org$eclipse$ui$activities$ICategoryActivityBinding), this.categoryActivityBindings)) {
            this.categoryActivityBindings = categoryActivityBindings;
            this.categoryActivityBindingsAsArray = this.categoryActivityBindings.toArray(new ICategoryActivityBinding[this.categoryActivityBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Util.equals(name, this.name)) {
            this.name = name;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.categoryActivityBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.description;
    }

    public boolean setDescription(String description) {
        if (!Util.equals(description, this.description)) {
            this.description = description;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

