/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.PackageSelectionDialog;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.BundleException;

public class ExportSection
extends TableSection
implements IPartSelectionListener,
IInputContextListener {
    public static final String SECTION_TITLE = "ManifestEditor.ExportSection.title";
    public static final String SECTION_DESC = "ManifestEditor.ExportSection.desc";
    public static final String KEY_NO_EXPORT = "ManifestEditor.ExportSection.noExport";
    public static final String KEY_NEW_FILTER = "ManifestEditor.ExportSection.newFilter";
    public static final String KEY_FULL_EXPORT = "ManifestEditor.ExportSection.fullExport";
    public static final String KEY_SELECTED_EXPORT = "ManifestEditor.ExportSection.selectedExport";
    public static final String KEY_ADD = "ManifestEditor.ExportSection.add";
    public static final String KEY_REMOVE = "ManifestEditor.ExportSection.remove";
    public static final String SECTION_ADD_TITLE = "ManifestEditor.ExportSection.addTitle";
    private Button fFullExportButton;
    private Button fSelectedExportButton;
    private IPluginLibrary fCurrentLibrary;
    private Composite fPackageExportContainer;
    private TableViewer fPackageExportViewer;

    public ExportSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEPlugin.getResourceString(KEY_ADD), PDEPlugin.getResourceString(KEY_REMOVE)});
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.handleDefaultButton = false;
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)new GridLayout());
        String label = PDEPlugin.getResourceString(KEY_FULL_EXPORT);
        this.fFullExportButton = toolkit.createButton(container, label, 16);
        this.fFullExportButton.setLayoutData((Object)new GridData(768));
        this.fFullExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExportSection.this.fCurrentLibrary != null) {
                        ExportSection.this.fCurrentLibrary.setExported(ExportSection.this.fFullExportButton.getSelection());
                    }
                    ExportSection.this.getTablePart().setButtonEnabled(0, !ExportSection.this.fFullExportButton.getSelection());
                    ExportSection.this.getTablePart().setButtonEnabled(1, false);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        });
        label = PDEPlugin.getResourceString(KEY_SELECTED_EXPORT);
        this.fSelectedExportButton = toolkit.createButton(container, label, 16);
        this.fSelectedExportButton.setLayoutData((Object)new GridData(768));
        this.fPackageExportContainer = toolkit.createComposite(container);
        this.fPackageExportContainer.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 2;
        this.fPackageExportContainer.setLayout((Layout)layout);
        this.createNameTable(this.fPackageExportContainer, toolkit);
        this.update(null, this.isBundleMode());
        this.initialize();
        section.setClient((Control)container);
    }

    private void createNameTable(Composite parent, FormToolkit toolkit) {
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.getPage().getModel().isEditable());
        this.createViewerPartControl(parent, 65536, 2, toolkit);
        this.fPackageExportViewer = tablePart.getTableViewer();
        this.fPackageExportViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fPackageExportViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fPackageExportViewer.setSorter(new ViewerSorter());
        toolkit.paintBordersFor(parent);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.getTablePart().setButtonEnabled(1, item != null);
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleAdd();
        } else if (index == 1) {
            this.handleDelete();
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        return false;
    }

    public void dispose() {
        InputContextManager contextManager;
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        if ((contextManager = this.getPage().getPDEEditor().getContextManager()) != null) {
            contextManager.removeInputContextListener(this);
        }
        super.dispose();
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleAdd() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                String[] names = this.isBundleMode() ? this.getProvidedPackages() : this.fCurrentLibrary.getContentFilters();
                Vector<String> existing = new Vector<String>();
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        existing.add(names[i]);
                    }
                }
                JavaElementLabelProvider labelProvider = new JavaElementLabelProvider();
                PackageSelectionDialog dialog = new PackageSelectionDialog(this.fPackageExportViewer.getTable().getShell(), (ILabelProvider)labelProvider, JavaCore.create((IProject)project), existing);
                if (dialog.open() == 0) {
                    Object[] elements = dialog.getResult();
                    if (this.isBundleMode()) {
                        this.addProvidedPackages(elements);
                    } else {
                        for (int i = 0; i < elements.length; ++i) {
                            IPackageFragment fragment = (IPackageFragment)elements[i];
                            this.fCurrentLibrary.addContentFilter(fragment.getElementName());
                        }
                    }
                }
                labelProvider.dispose();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fPackageExportViewer.getSelection();
        Object[] items = ssel.toArray();
        try {
            if (this.isBundleMode()) {
                this.removeProvidedPackages(items);
            } else {
                for (int i = 0; i < items.length; ++i) {
                    this.fCurrentLibrary.removeContentFilter(items[i].toString());
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void initialize() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        InputContextManager contextManager = this.getPage().getPDEEditor().getContextManager();
        if (contextManager != null) {
            contextManager.addInputContextListener(this);
        }
        if (this.isBundleMode()) {
            this.getBundleModel().addModelChangedListener((IModelChangedListener)this);
        }
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            if (this.fCurrentLibrary != null) {
                this.update(null, this.isBundleMode());
            }
            this.markStale();
            return;
        }
        this.refresh();
    }

    public void refresh() {
        this.update(this.fCurrentLibrary, this.isBundleMode());
        super.refresh();
    }

    public void selectionChanged(IFormPart source, ISelection selection) {
        IStructuredSelection ssel;
        if (selection == null || selection.isEmpty()) {
            this.update(null, this.isBundleMode());
        }
        if ((ssel = (IStructuredSelection)selection).getFirstElement() instanceof IPluginLibrary) {
            this.update((IPluginLibrary)ssel.getFirstElement(), this.isBundleMode());
        }
    }

    private boolean isReadOnly() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IEditable) {
            return !((IEditable)model).isEditable();
        }
        return true;
    }

    private boolean isBundleMode() {
        return this.getPage().getModel() instanceof IBundlePluginModelBase;
    }

    private void update(IPluginLibrary library, boolean bundleMode) {
        this.fCurrentLibrary = library;
        if (bundleMode) {
            this.updateInBundleMode();
            return;
        }
        if (library == null) {
            this.fFullExportButton.setEnabled(false);
            this.fFullExportButton.setSelection(false);
            this.fSelectedExportButton.setEnabled(false);
            this.fSelectedExportButton.setSelection(false);
            this.fPackageExportViewer.setInput((Object)new Object[0]);
            this.getTablePart().setButtonEnabled(0, false);
            this.getTablePart().setButtonEnabled(1, false);
            return;
        }
        this.fFullExportButton.setEnabled(!this.isReadOnly());
        this.fSelectedExportButton.setEnabled(!this.isReadOnly());
        this.fFullExportButton.setSelection(library.isFullyExported());
        this.fSelectedExportButton.setSelection(!library.isFullyExported());
        this.fPackageExportViewer.setInput((Object)library);
        this.getTablePart().setButtonEnabled(1, false);
        this.getTablePart().setButtonEnabled(0, this.fSelectedExportButton.getSelection());
    }

    private void updateInBundleMode() {
        this.getTablePart().setButtonEnabled(1, false);
        this.getTablePart().setButtonEnabled(0, true);
        this.fFullExportButton.setEnabled(false);
        this.fFullExportButton.setSelection(false);
        this.fSelectedExportButton.setEnabled(false);
        this.fSelectedExportButton.setSelection(true);
        this.fPackageExportViewer.setInput((Object)this.getPage().getModel());
    }

    private String[] getProvidedPackages() {
        IBundleModel model = this.getBundleModel();
        IBundle bundle = model.getBundle();
        if (bundle == null) {
            return new String[0];
        }
        String value = bundle.getHeader("Provide-Package");
        if (value == null) {
            return new String[0];
        }
        try {
            ManifestElement[] result = ManifestElement.parseHeader((String)"Provide-Package", (String)value);
            String[] names = new String[result.length];
            for (int i = 0; i < result.length; ++i) {
                names[i] = result[i].getValue();
            }
            return names;
        }
        catch (BundleException e) {
            return new String[0];
        }
    }

    private void addProvidedPackages(Object[] names) {
        String[] current = this.getProvidedPackages();
        Object[] newNames = current.length == 0 ? names : new Object[current.length + names.length];
        System.arraycopy(current, 0, newNames, 0, current.length);
        System.arraycopy(names, 0, newNames, current.length, names.length);
        this.setProvidedPackages(newNames);
    }

    private void removeProvidedPackages(Object[] removed) {
        String[] current = this.getProvidedPackages();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < current.length; ++i) {
            String name = current[i];
            boolean skip = false;
            for (int j = 0; j < removed.length; ++j) {
                if (!name.equals(removed[j])) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            result.add(name);
        }
        this.setProvidedPackages(result.toArray());
    }

    IBundleModel getBundleModel() {
        InputContextManager contextManager = this.getPage().getPDEEditor().getContextManager();
        if (contextManager == null) {
            return null;
        }
        InputContext context = contextManager.findContext("bundle-context");
        if (context != null) {
            return (IBundleModel)context.getModel();
        }
        return null;
    }

    private void setProvidedPackages(Object[] names) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i] instanceof IPackageFragment ? ((IPackageFragment)names[i]).getElementName() : names[i].toString();
            buf.append(name);
            if (i >= names.length - 1) continue;
            buf.append("," + System.getProperty("line.separator") + " ");
        }
        IBundleModel model = this.getBundleModel();
        IBundle bundle = model.getBundle();
        if (bundle == null) {
            return;
        }
        bundle.setHeader("Provide-Package", buf.toString());
    }

    public void contextAdded(InputContext context) {
        if (context.getId().equals("bundle-context")) {
            this.bundleModeChanged((IBundleModel)context.getModel(), true);
        }
    }

    public void contextRemoved(InputContext context) {
        if (context.getId().equals("bundle-context")) {
            this.bundleModeChanged((IBundleModel)context.getModel(), false);
        }
    }

    private void bundleModeChanged(IBundleModel model, boolean added) {
        if (added) {
            this.update(this.fCurrentLibrary, true);
            model.addModelChangedListener((IModelChangedListener)this);
        } else {
            model.removeModelChangedListener((IModelChangedListener)this);
            this.update(this.fCurrentLibrary, false);
        }
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return false;
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IModel) {
                return ExportSection.this.getProvidedPackages();
            }
            if (parent instanceof IPluginLibrary) {
                String[] filters = ((IPluginLibrary)parent).getContentFilters();
                return filters == null ? new Object[]{} : filters;
            }
            return new Object[0];
        }
    }
}

