/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ExtensionAttributeRow;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ChoiceAttributeRow
extends ExtensionAttributeRow {
    private ComboPart combo;

    public ChoiceAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    public void createContents(Composite parent, FormToolkit toolkit, int span) {
        this.createLabel(parent, toolkit);
        this.combo = new ComboPart();
        this.combo.createControl(parent, toolkit, 8);
        ISchemaSimpleType type = this.getAttribute().getType();
        ISchemaRestriction restriction = type.getRestriction();
        if (restriction != null) {
            Object[] rchildren = restriction.getChildren();
            if (this.getUse() != 1) {
                this.combo.add("");
            }
            for (int i = 0; i < rchildren.length; ++i) {
                Object rchild = rchildren[i];
                if (!(rchild instanceof ISchemaEnumeration)) continue;
                this.combo.add(((ISchemaEnumeration)rchild).getName());
            }
        }
        GridData gd = new GridData(span == 2 ? 768 : 256);
        gd.widthHint = 20;
        gd.horizontalSpan = span - 1;
        this.combo.getControl().setLayoutData((Object)gd);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ChoiceAttributeRow.this.blockNotification) {
                    ChoiceAttributeRow.this.markDirty();
                }
            }
        });
        this.combo.getControl().setEnabled(this.part.isEditable());
    }

    protected void update() {
        this.blockNotification = true;
        String value = this.getValue();
        this.combo.setText(value != null ? value : "");
        this.blockNotification = false;
        this.dirty = false;
    }

    public void commit() {
        if (this.dirty && this.input != null) {
            try {
                String selection = this.combo.getSelection();
                if (selection.length() == 0) {
                    selection = null;
                }
                this.input.setAttribute(this.getName(), selection);
                this.dirty = false;
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void setFocus() {
        this.combo.getControl().setFocus();
    }
}

