/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.site.ArchivePage;
import org.eclipse.pde.internal.ui.editor.site.FeaturesPage;
import org.eclipse.pde.internal.ui.editor.site.SiteInputContext;
import org.eclipse.pde.internal.ui.editor.site.SiteInputContextManager;
import org.eclipse.pde.internal.ui.editor.site.SiteSourcePage;
import org.eclipse.pde.internal.ui.editor.site.SiteUndoManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SiteEditor
extends MultiSourceEditor {
    static /* synthetic */ Class class$java$io$File;

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        IFile siteFile = null;
        String name = file.getName().toLowerCase();
        if (name.equals("site.xml")) {
            siteFile = file;
        }
        if (siteFile.exists()) {
            FileEditorInput in = new FileEditorInput(siteFile);
            manager.putContext((IEditorInput)in, new SiteInputContext(this, (IEditorInput)in, file == siteFile));
        }
        manager.monitorFile(siteFile);
    }

    protected InputContextManager createInputContextManager() {
        SiteInputContextManager contextManager = new SiteInputContextManager(this);
        contextManager.setUndoManager(new SiteUndoManager(this));
        return contextManager;
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            for (int i = 0; i < types.length; ++i) {
                for (int j = 0; j < transfers.length; ++j) {
                    if (!transfers[j].isSupportedType(types[i])) continue;
                    return true;
                }
            }
        }
        catch (SWTError sWTError) {
            // empty catch block
        }
        return false;
    }

    public void monitoredFileAdded(IFile file) {
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void contextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        if (context.isPrimary()) {
            this.close(true);
            return;
        }
        IFormPage page = this.findPage(context.getId());
        if (page != null) {
            this.removePage(context.getId());
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        File file = (File)input.getAdapter(class$java$io$File == null ? (class$java$io$File = SiteEditor.class$("java.io.File")) : class$java$io$File);
        File siteFile = null;
        String name = file.getName().toLowerCase();
        if (name.equals("site.xml")) {
            siteFile = file;
        }
        if (siteFile.exists()) {
            SystemFileEditorInput in = new SystemFileEditorInput(siteFile);
            manager.putContext((IEditorInput)in, new SiteInputContext(this, (IEditorInput)in, file == siteFile));
        }
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        String name = input.getName().toLowerCase();
        if (name.startsWith("site.xml")) {
            manager.putContext((IEditorInput)input, new SiteInputContext(this, (IEditorInput)input, true));
        }
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        super.contextMenuAboutToShow(manager);
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new FeaturesPage(this));
            this.addPage((IFormPage)new ArchivePage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("site-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            InputContext primary = this.inputContextManager.getPrimaryContext();
            if (primary.getId().equals("site-context")) {
                firstPageId = "features";
            }
            if (firstPageId == null) {
                firstPageId = "features";
            }
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new SiteSourcePage(editor, title, name);
    }

    protected IContentOutlinePage createContentOutline() {
        return null;
    }

    public boolean isDirty() {
        InputContext context = this.inputContextManager.findContext("site-context");
        if (context == null) {
            return super.isDirty();
        }
        ISiteBuildModel fBuildModel = ((ISiteModel)context.getModel()).getBuildModel();
        if (fBuildModel != null && ((WorkspaceSiteBuildModel)fBuildModel).isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

