/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.pde.internal.ui.parts.SharedPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SharedPartWithButtons
extends SharedPart {
    private String[] buttonLabels;
    private Control[] controls;
    private Composite buttonContainer;

    public SharedPartWithButtons(String[] buttonLabels) {
        this.buttonLabels = buttonLabels;
    }

    public void setButtonEnabled(int index, boolean enabled) {
        Control c;
        if (this.controls != null && index >= 0 && this.controls.length > index && (c = this.controls[index]) instanceof Button) {
            c.setEnabled(enabled);
        }
    }

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormToolkit var4);

    protected abstract void buttonSelected(Button var1, int var2);

    public void createControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.createMainLabel(parent, span, toolkit);
        this.createMainControl(parent, style, span - 1, toolkit);
        this.createButtons(parent, toolkit);
    }

    protected void createButtons(Composite parent, FormToolkit toolkit) {
        if (this.buttonLabels != null && this.buttonLabels.length > 0) {
            this.buttonContainer = this.createComposite(parent, toolkit);
            GridData gd = new GridData(1040);
            this.buttonContainer.setLayoutData((Object)gd);
            this.buttonContainer.setLayout((Layout)this.createButtonsLayout());
            this.controls = new Control[this.buttonLabels.length];
            SelectionHandler listener = new SelectionHandler();
            for (int i = 0; i < this.buttonLabels.length; ++i) {
                String label = this.buttonLabels[i];
                if (label != null) {
                    Button button = this.createButton(this.buttonContainer, label, i, toolkit);
                    button.addSelectionListener((SelectionListener)listener);
                    this.controls[i] = button;
                    continue;
                }
                this.createEmptySpace(this.buttonContainer, 1, toolkit);
            }
        }
    }

    protected GridLayout createButtonsLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected Button createButton(Composite parent, String label, int index, FormToolkit toolkit) {
        Button button;
        if (toolkit != null) {
            button = toolkit.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.setData((Object)new Integer(index));
        return button;
    }

    protected void updateEnabledState() {
        for (int i = 0; i < this.controls.length; ++i) {
            Control c = this.controls[i];
            if (!(c instanceof Button)) continue;
            c.setEnabled(this.isEnabled());
        }
    }

    protected void createMainLabel(Composite parent, int span, FormToolkit toolkit) {
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        private void buttonSelected(SelectionEvent e) {
            Integer index = (Integer)e.widget.getData();
            SharedPartWithButtons.this.buttonSelected((Button)e.widget, index);
        }
    }
}

