/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.internal.samples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class SampleOperation
implements IRunnableWithProgress {
    private static final String SAMPLE_PROPERTIES = "sample.properties";
    private IConfigurationElement sample;
    private String[] projectNames;
    private IFile sampleManifest;
    private IOverwriteQuery query;
    private boolean noToAll;
    private IProject[] createdProjects;

    public SampleOperation(IConfigurationElement sample, String[] projectNames, IOverwriteQuery query) {
        this.sample = sample;
        this.query = query;
        this.projectNames = projectNames;
    }

    public IFile getSampleManifest() {
        return this.sampleManifest;
    }

    public IProject[] getCreatedProjects() {
        return this.createdProjects;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IWorkspaceRunnable op = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IConfigurationElement[] projects = SampleOperation.this.sample.getChildren("project");
                    monitor.beginTask(PDEPlugin.getResourceString("SampleOperation.creating"), 4 * projects.length);
                    SampleOperation.access$102(SampleOperation.this, new IProject[projects.length]);
                    try {
                        for (int i = 0; i < projects.length; ++i) {
                            IFile file = SampleOperation.this.importProject(SampleOperation.this.projectNames[i], projects[i], (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            if (file != null && SampleOperation.this.sampleManifest == null) {
                                SampleOperation.this.sampleManifest = file;
                            }
                            if (file == null) continue;
                            ((SampleOperation)SampleOperation.this).createdProjects[i] = file.getProject();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new OperationCanceledException();
                    }
                    catch (InvocationTargetException e) {
                        SampleOperation.this.throwCoreException(e);
                    }
                }
            };
            PDEPlugin.getWorkspace().run(op, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        finally {
            monitor.done();
        }
    }

    private void throwCoreException(InvocationTargetException e) throws CoreException {
        Throwable t = e.getCause();
        Status status = new Status(4, "org.eclipse.pde.ui", 0, e.getMessage(), t);
        throw new CoreException((IStatus)status);
    }

    private IFile importProject(String name, IConfigurationElement config, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String path = config.getAttribute("archive");
        if (name == null || path == null) {
            return null;
        }
        IWorkspace workspace = PDEPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(name);
        boolean skip = false;
        if (project.exists()) {
            if (this.noToAll) {
                skip = true;
            } else {
                String returnId = this.query.queryOverwrite(project.getFullPath().toString());
                if (returnId.equals("NOALL")) {
                    this.noToAll = true;
                    skip = true;
                } else if (returnId.equals("NO")) {
                    skip = true;
                }
            }
            if (!skip) {
                project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                project = root.getProject(name);
            } else {
                monitor.worked(1);
            }
        }
        if (skip) {
            monitor.worked(3);
            IFile manifest = project.getFile(SAMPLE_PROPERTIES);
            return manifest;
        }
        project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        project.open((IProgressMonitor)new NullProgressMonitor());
        ZipFile zipFile = this.getZipFileFromPluginDir(path, this.sample.getDeclaringExtension().getDeclaringPluginDescriptor());
        this.importFilesFromZip(zipFile, project.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return this.createSampleManifest(project, config, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private IFile createSampleManifest(IProject project, IConfigurationElement config, IProgressMonitor monitor) throws CoreException {
        IFile file = project.getFile(SAMPLE_PROPERTIES);
        if (!file.exists()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Properties properties = new Properties();
                this.createSampleManifestContent(config.getAttribute("name"), properties);
                properties.store(out, "");
                out.flush();
                String contents = out.toString();
                out.close();
                ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
                file.create((InputStream)stream, true, monitor);
                stream.close();
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return file;
    }

    private void createSampleManifestContent(String projectName, Properties properties) {
        this.writeProperty(properties, "id", this.sample.getAttribute("id"));
        this.writeProperty(properties, "name", this.sample.getAttribute("name"));
        this.writeProperty(properties, "projectName", projectName);
        this.writeProperty(properties, "launcher", this.sample.getAttribute("launcher"));
        IConfigurationElement[] desc = this.sample.getChildren("description");
        if (desc.length == 1) {
            this.writeProperty(properties, "helpHref", desc[0].getAttribute("helpHref"));
            this.writeProperty(properties, "description", desc[0].getValue());
        }
    }

    private void writeProperty(Properties properties, String name, String value) {
        if (value == null) {
            return;
        }
        properties.setProperty(name, value);
    }

    private ZipFile getZipFileFromPluginDir(String pluginRelativePath, IPluginDescriptor pluginDescriptor) throws CoreException {
        try {
            URL starterURL = new URL(pluginDescriptor.getInstallURL(), pluginRelativePath);
            return new ZipFile(Platform.asLocalURL((URL)starterURL).getFile());
        }
        catch (IOException e) {
            String message = pluginRelativePath + ": " + e.getMessage();
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, this.query);
        op.run(monitor);
    }

    static /* synthetic */ IProject[] access$102(SampleOperation x0, IProject[] x1) {
        x0.createdProjects = x1;
        return x1;
    }
}

