/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.WorkbenchAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.actions.ActionFactory;

public class RefreshUserNotificationPolicy
implements IRefreshSubscriberListener {
    private SubscriberParticipant participant;

    public RefreshUserNotificationPolicy(SubscriberParticipant participant) {
        this.participant = participant;
    }

    public void refreshStarted(final IRefreshEvent event) {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                ISynchronizeView view;
                if (event.getRefreshType() == 2 && (view = TeamUI.getSynchronizeManager().showSynchronizeViewInActivePage()) != null) {
                    view.display(RefreshUserNotificationPolicy.this.participant);
                }
            }
        });
    }

    public ActionFactory.IWorkbenchAction refreshDone(final IRefreshEvent event) {
        if (event.getSubscriber() != this.participant.getSubscriberSyncInfoCollector().getSubscriber()) {
            return null;
        }
        int severity = event.getStatus().getSeverity();
        if (severity == 8 || severity == 4) {
            return null;
        }
        return new WorkbenchAction(){

            public void run() {
                boolean prompt = event.getStatus().getCode() == 2;
                SyncInfo[] infos = event.getChanges();
                ArrayList<IResource> selectedResources = new ArrayList<IResource>();
                selectedResources.addAll(Arrays.asList(event.getResources()));
                for (int i = 0; i < infos.length; ++i) {
                    selectedResources.add(infos[i].getLocal());
                }
                IResource[] resources = selectedResources.toArray(new IResource[selectedResources.size()]);
                if (resources.length == 1 && resources[0].getType() == 1) {
                    IResource file = resources[0];
                    SyncInfo info = RefreshUserNotificationPolicy.this.participant.getSubscriberSyncInfoCollector().getSyncInfoSet().getSyncInfo(file);
                    if (info != null) {
                        OpenInCompareAction.openCompareEditor(RefreshUserNotificationPolicy.this.participant.getName(), info, false, null);
                        prompt = false;
                    }
                }
                if (prompt) {
                    RefreshUserNotificationPolicy.this.notifyIfNeededModal(event);
                }
                this.setToolTipText(this.getToolTipText());
            }

            public String getToolTipText() {
                boolean prompt;
                boolean bl = prompt = event.getStatus().getCode() == 2;
                if (prompt) {
                    return Policy.bind("RefreshSubscriberJob.2a");
                }
                return Policy.bind("RefreshSubscriberJob.2b", RefreshUserNotificationPolicy.this.participant.getName());
            }
        };
    }

    private void notifyIfNeededModal(final IRefreshEvent event) {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                String title = event.getRefreshType() == 1 ? Policy.bind("RefreshCompleteDialog.4a", Utils.getTypeName(RefreshUserNotificationPolicy.this.participant)) : Policy.bind("RefreshCompleteDialog.4", Utils.getTypeName(RefreshUserNotificationPolicy.this.participant));
                MessageDialog.openInformation((Shell)Utils.getShell(null), (String)title, (String)event.getStatus().getMessage());
            }
        });
    }
}

