/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.synchronize.actions.DefaultSynchronizePageActions;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;

public class SynchronizePageConfiguration
extends SynchronizePageActionGroup
implements ISynchronizePageConfiguration {
    public static final String P_MODEL = "org.eclipse.team.ui.P_MODEL";
    public static final String P_ADVISOR = "org.eclipse.team.ui.P_ADVISOR";
    public static final String P_NAVIGATOR = "org.eclipse.team.ui.P_NAVIGATOR";
    public static final String P_MODEL_MANAGER = "org.eclipse.team.ui.P_MODEL_MANAGER";
    public static final String P_WORKING_SET_SYNC_INFO_SET = "org.eclipse.team.ui.P_WORKING_SET_SYNC_INFO_SET";
    public static final String P_PARTICIPANT_SYNC_INFO_SET = "org.eclipse.team.ui.P_PARTICIPANT_SYNC_INFO_SET";
    public static final String P_OPEN_ACTION = "org.eclipse.team.ui.P_OPEN_ACTION";
    public static final String P_VIEWER_STYLE = "org.eclipse.team.ui.P_VIEWER_STYLE";
    public static final int CHECKBOX = 1;
    private ISynchronizeParticipant participant;
    private ISynchronizePageSite site;
    private ListenerList propertyChangeListeners = new ListenerList();
    private ListenerList actionContributions = new ListenerList();
    private Map properties = new HashMap();
    private boolean actionsInitialized = false;
    private ISynchronizePage page;
    private IRunnableContext context;

    public SynchronizePageConfiguration(ISynchronizeParticipant participant) {
        this.participant = participant;
        this.setProperty("org.eclipse.team.ui.P_CONTEXT_MENU", ISynchronizePageConfiguration.DEFAULT_CONTEXT_MENU);
        this.setProperty("org.eclipse.team.ui.P_TOOLBAR_MENU", ISynchronizePageConfiguration.DEFAULT_TOOLBAR_MENU);
        this.setProperty("org.eclipse.team.ui.P_VIEW_MENU", ISynchronizePageConfiguration.DEFAULT_VIEW_MENU);
        this.setProperty("org.eclipse.team.ui.P_COMPARISON_TYPE", "three-way");
        this.addActionContribution(new DefaultSynchronizePageActions());
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }

    public ISynchronizePageSite getSite() {
        return this.site;
    }

    public void setSite(ISynchronizePageSite site) {
        this.site = site;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        ListenerList listenerList = this.propertyChangeListeners;
        synchronized (listenerList) {
            this.propertyChangeListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        ListenerList listenerList = this.propertyChangeListeners;
        synchronized (listenerList) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public void setProperty(String key, Object newValue) {
        Object oldValue = this.properties.get(key);
        if (this.page == null || this.page.aboutToChangeProperty(this, key, newValue)) {
            this.properties.put(key, newValue);
            if (oldValue == null || !oldValue.equals(newValue)) {
                this.firePropertyChange(key, oldValue, newValue);
            }
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionContribution(SynchronizePageActionGroup contribution) {
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            this.actionContributions.add((Object)contribution);
        }
        if (this.actionsInitialized) {
            contribution.initialize(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionContribution(SynchronizePageActionGroup contribution) {
        ListenerList listenerList = this.actionContributions;
        synchronized (listenerList) {
            this.actionContributions.remove((Object)contribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String key, Object oldValue, Object newValue) {
        Object[] listeners;
        ListenerList listenerList = this.propertyChangeListeners;
        synchronized (listenerList) {
            listeners = this.propertyChangeListeners.getListeners();
        }
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, oldValue, newValue);
        for (int i = 0; i < listeners.length; ++i) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            });
        }
    }

    public void initialize(final ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        this.actionsInitialized = true;
        Object[] listeners = this.actionContributions.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.initialize(configuration);
                }
            });
        }
    }

    public void setContext(final ActionContext context) {
        super.setContext(context);
        Object[] listeners = this.actionContributions.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.setContext(context);
                }
            });
        }
    }

    public void fillContextMenu(final IMenuManager manager) {
        Object[] listeners = this.actionContributions.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.fillContextMenu(manager);
                }
            });
        }
    }

    public void fillActionBars(final IActionBars actionBars) {
        if (!this.actionsInitialized) {
            this.initialize(this);
        }
        Object[] listeners = this.actionContributions.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.fillActionBars(actionBars);
                }
            });
        }
    }

    public void updateActionBars() {
        Object[] listeners = this.actionContributions.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.updateActionBars();
                }
            });
        }
    }

    public void modelChanged(final ISynchronizeModelElement root) {
        Object[] listeners = this.actionContributions.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.modelChanged(root);
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        Object[] listeners = this.actionContributions.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final SynchronizePageActionGroup contribution = (SynchronizePageActionGroup)((Object)listeners[i]);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.dispose();
                }
            });
        }
    }

    public void setMenuGroups(String menuPropertyId, String[] groups) {
        this.setProperty(menuPropertyId, groups);
    }

    public void addMenuGroup(String menuPropertyId, String groupId) {
        String[] menuGroups = (String[])this.getProperty(menuPropertyId);
        if (menuGroups == null) {
            menuGroups = this.getDefault(menuPropertyId);
        }
        String[] newGroups = new String[menuGroups.length + 1];
        System.arraycopy(menuGroups, 0, newGroups, 0, menuGroups.length);
        newGroups[menuGroups.length] = groupId;
        this.setProperty(menuPropertyId, newGroups);
    }

    public boolean hasMenuGroup(String menuPropertyId, String groupId) {
        String[] groups = (String[])this.getProperty(menuPropertyId);
        if (groups == null) {
            groups = this.getDefault(menuPropertyId);
        }
        for (int i = 0; i < groups.length; ++i) {
            String string = groups[i];
            if (!string.equals(groupId)) continue;
            return true;
        }
        return false;
    }

    protected String[] getDefault(String menuPropertyId) {
        if (menuPropertyId.equals("org.eclipse.team.ui.P_CONTEXT_MENU")) {
            return ISynchronizePageConfiguration.DEFAULT_CONTEXT_MENU;
        }
        if (menuPropertyId.equals("org.eclipse.team.ui.P_VIEW_MENU")) {
            return ISynchronizePageConfiguration.DEFAULT_VIEW_MENU;
        }
        if (menuPropertyId.equals("org.eclipse.team.ui.P_TOOLBAR_MENU")) {
            return ISynchronizePageConfiguration.DEFAULT_TOOLBAR_MENU;
        }
        return new String[0];
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        ILabelDecorator[] decorators = (ILabelDecorator[])this.getProperty("org.eclipse.team.ui.P_LABEL_DECORATORS");
        if (decorators == null) {
            decorators = new ILabelDecorator[]{};
        }
        for (int i = 0; i < decorators.length; ++i) {
            ILabelDecorator d = decorators[i];
            if (d != decorator) continue;
            return;
        }
        ILabelDecorator[] newDecorators = new ILabelDecorator[decorators.length + 1];
        System.arraycopy(decorators, 0, newDecorators, 0, decorators.length);
        newDecorators[decorators.length] = decorator;
        this.setProperty("org.eclipse.team.ui.P_LABEL_DECORATORS", newDecorators);
    }

    public String getGroupId(String group) {
        String id = this.getParticipant().getId();
        if (this.getParticipant().getSecondaryId() != null) {
            id = id + ".";
            id = id + this.getParticipant().getSecondaryId();
        }
        return id + "." + group;
    }

    public int getMode() {
        Object o = this.getProperty("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE");
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setMode(int mode) {
        this.setProperty("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE", new Integer(mode));
    }

    public int getSupportedModes() {
        Object o = this.getProperty("org.eclipse.team.ui.P_SUPPORTED_MODES");
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setSupportedModes(int modes) {
        this.setProperty("org.eclipse.team.ui.P_SUPPORTED_MODES", new Integer(modes));
    }

    public ISynchronizePage getPage() {
        return this.page;
    }

    public void setPage(ISynchronizePage page) {
        this.page = page;
    }

    public int getViewerStyle() {
        Object o = this.getProperty(P_VIEWER_STYLE);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setViewerStyle(int style) {
        this.setProperty(P_VIEWER_STYLE, new Integer(style));
    }

    public SyncInfoSet getSyncInfoSet() {
        Object o = this.getProperty("org.eclipse.team.ui.P_SYNC_INFO_SET");
        if (o instanceof SyncInfoSet) {
            return (SyncInfoSet)o;
        }
        return null;
    }

    public String getComparisonType() {
        return (String)this.getProperty("org.eclipse.team.ui.P_COMPARISON_TYPE");
    }

    public void setComparisonType(String type) {
        this.setProperty("org.eclipse.team.ui.P_COMPARISON_TYPE", type);
    }

    public void setRunnableContext(IRunnableContext context) {
        this.context = context;
    }

    public IRunnableContext getRunnableContext() {
        return this.context;
    }
}

