/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.internal.configurator.Configuration;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationParser
extends DefaultHandler
implements IConfigurationConstants {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private URL currentSiteURL;
    private Configuration config;
    private URL configURL;
    private InputStream input;

    public ConfigurationParser() throws InvocationTargetException {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            Utils.log(Utils.newStatus("ConfigurationParser", e));
            throw new InvocationTargetException(e);
        }
        catch (SAXException e) {
            Utils.log(Utils.newStatus("ConfigurationParser", e));
            throw new InvocationTargetException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Configuration parse(URL url) throws Exception {
        block16: {
            block19: {
                block13: {
                    block14: {
                        Utils.debug("Start parsing Configuration:" + url);
                        lastModified = 0L;
                        this.configURL = url;
                        if (!"file".equals(url.getProtocol())) ** GOTO lbl28
                        inputFile = new File(url.getFile());
                        if (inputFile.exists() && inputFile.canRead()) break block13;
                        var5_5 = null;
                        var7_6 = null;
                        if (this.config == null) break block14;
                        this.config.setLastModified(lastModified);
                    }
                    try {
                        if (this.input != null) {
                            this.input.close();
                            this.input = null;
                        }
                    }
                    catch (IOException e1) {
                        Utils.log(e1.getLocalizedMessage());
                    }
                    return var5_5;
                }
                lastModified = inputFile.lastModified();
                this.input = new FileInputStream((File)inputFile);
                break block19;
lbl28:
                // 1 sources

                this.input = url.openStream();
            }
            this.parser.parse(new InputSource(this.input), (DefaultHandler)this);
            inputFile = this.config;
            var7_7 = null;
            if (this.config == null) break block16;
            this.config.setLastModified(lastModified);
        }
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
        catch (IOException e1) {
            Utils.log(e1.getLocalizedMessage());
        }
        return inputFile;
        catch (Exception e) {
            try {
                Utils.log(Utils.newStatus("ConfigurationParser.parse() error:", e));
                throw e;
            }
            catch (Throwable var6_12) {
                var7_8 = null;
                if (this.config != null) {
                    this.config.setLastModified(lastModified);
                }
                try {
                    if (this.input != null) {
                        this.input.close();
                        this.input = null;
                    }
                }
                catch (IOException e1) {
                    Utils.log(e1.getLocalizedMessage());
                }
                throw var6_12;
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        try {
            String tag = localName.trim();
            if (tag.equalsIgnoreCase("config")) {
                this.processConfig(attributes);
                return;
            }
            if (tag.equalsIgnoreCase("site")) {
                this.processSite(attributes);
                return;
            }
            if (tag.equalsIgnoreCase("feature")) {
                this.processFeature(attributes);
                return;
            }
        }
        catch (MalformedURLException e) {
            throw new SAXException(Messages.getString("InstalledSiteParser.UnableToCreateURL", e.getMessage()), e);
        }
        catch (CoreException e) {
            throw new SAXException(Messages.getString("InstalledSiteParser.InternalError", e.toString()), (Exception)((Object)e));
        }
    }

    private void processSite(Attributes attributes) throws MalformedURLException, CoreException {
        int policyType;
        if (this.config == null) {
            return;
        }
        this.currentSiteURL = null;
        String urlString = attributes.getValue("url");
        if (urlString == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            url = new URL(PlatformConfiguration.getInstallURL(), urlString);
            return;
        }
        if (!this.isValidSite(url)) {
            return;
        }
        this.currentSiteURL = url;
        String[] policyList = null;
        String typeString = attributes.getValue("policy");
        if (typeString == null) {
            policyType = 1;
            policyList = IConfigurationConstants.DEFAULT_POLICY_LIST;
        } else {
            int i;
            for (i = 0; i < IConfigurationConstants.CFG_POLICY_TYPE.length && !typeString.equals(IConfigurationConstants.CFG_POLICY_TYPE[i]); ++i) {
            }
            if (i >= IConfigurationConstants.CFG_POLICY_TYPE.length) {
                policyType = 1;
                policyList = IConfigurationConstants.DEFAULT_POLICY_LIST;
            } else {
                policyType = i;
                String pluginList = attributes.getValue("list");
                if (pluginList != null) {
                    StringTokenizer st = new StringTokenizer(pluginList, ",");
                    policyList = new String[st.countTokens()];
                    for (i = 0; i < policyList.length; ++i) {
                        policyList[i] = st.nextToken();
                    }
                }
            }
        }
        SitePolicy sp = new SitePolicy(policyType, policyList);
        SiteEntry site = new SiteEntry(url, sp);
        String flag = attributes.getValue("updateable");
        if (flag != null) {
            if (flag.equals("true")) {
                site.setUpdateable(true);
            } else {
                site.setUpdateable(false);
            }
        }
        if ((flag = attributes.getValue("enabled")) != null && flag.equals("false")) {
            site.setEnabled(false);
        } else {
            site.setEnabled(true);
        }
        String linkname = attributes.getValue("linkfile");
        if (linkname != null && !linkname.equals("")) {
            site.setLinkFileName(linkname.replace('/', File.separatorChar));
        }
        Utils.debug("End process config site url:" + urlString + " policy:" + typeString + " updatable:" + flag);
        this.config.addSiteEntry(url.toExternalForm(), site);
    }

    private void processFeature(Attributes attributes) throws MalformedURLException, CoreException {
        String pluginIdentifier;
        if (this.currentSiteURL == null) {
            return;
        }
        String id = attributes.getValue("id");
        if (id == null) {
            return;
        }
        String version = attributes.getValue("version");
        String pluginVersion = attributes.getValue("plugin-version");
        if (pluginVersion == null || pluginVersion.trim().length() == 0) {
            pluginVersion = version;
        }
        if ((pluginIdentifier = attributes.getValue("plugin-identifier")) != null && pluginIdentifier.trim().length() == 0) {
            pluginIdentifier = null;
        }
        String application = attributes.getValue("application");
        String locations = attributes.getValue("root");
        StringTokenizer st = locations != null ? new StringTokenizer(locations, ",") : new StringTokenizer("");
        ArrayList<URL> rootList = new ArrayList<URL>(st.countTokens());
        while (st.hasMoreTokens()) {
            try {
                URL rootEntry = new URL(st.nextToken());
                rootList.add(rootEntry);
            }
            catch (MalformedURLException e) {}
        }
        URL[] roots = rootList.toArray(new URL[rootList.size()]);
        boolean primary = false;
        String flag = attributes.getValue("primary");
        if (flag != null && flag.equals("true")) {
            primary = true;
        }
        FeatureEntry featureEntry = new FeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, roots);
        String url = attributes.getValue("url");
        if (url != null && url.trim().length() > 0) {
            featureEntry.setURL(url);
        }
        SiteEntry site = this.config.getSiteEntry(this.currentSiteURL.toExternalForm());
        site.addFeatureEntry(featureEntry);
    }

    private void processConfig(Attributes attributes) {
        String date = attributes.getValue("date");
        if (date == null || date.trim().length() == 0) {
            this.config = new Configuration();
        } else {
            long time = 0L;
            try {
                time = Long.parseLong(date);
                this.config = new Configuration(new Date(time));
            }
            catch (NumberFormatException e1) {
                time = new Date().getTime();
                Utils.log(Messages.getString("InstalledSiteParser.date", date));
                this.config = new Configuration();
            }
        }
        this.config.setURL(this.configURL);
        try {
            String sharedURL = attributes.getValue("shared_ur");
            if (sharedURL != null) {
                ConfigurationParser parser = new ConfigurationParser();
                Configuration sharedConfig = parser.parse(new URL(sharedURL));
                if (sharedConfig == null) {
                    throw new Exception();
                }
                this.config.setLinkedConfig(sharedConfig);
            }
        }
        catch (Exception e) {
            Utils.log(Utils.newStatus(Messages.getString("ConfigurationParser.cannotLoadSharedInstall"), e));
        }
        String flag = attributes.getValue("transient");
        if (flag != null) {
            this.config.setTransient(flag.equals("true"));
        }
        Utils.debug("End Processing Config Tag: date:" + attributes.getValue("date"));
    }

    private boolean isValidSite(URL url) {
        URL resolvedURL = url;
        if (url.getProtocol().equals("platform")) {
            try {
                resolvedURL = PlatformConfiguration.resolvePlatformURL(url);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!PlatformConfiguration.supportsDetection(resolvedURL)) {
            return false;
        }
        File siteRoot = new File(resolvedURL.getFile().replace('/', File.separatorChar));
        if (!siteRoot.exists()) {
            Utils.debug("Site " + resolvedURL + " does not exist ");
            return false;
        }
        return true;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        Utils.debug("End Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        try {
            String tag = localName.trim();
            if (tag.equalsIgnoreCase("config")) {
                SiteEntry[] sites = this.config.getSites();
                for (int i = 0; i < sites.length; ++i) {
                    sites[i].initialized();
                }
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

