/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;

public class WordlistLoader {
    public static Hashtable getWordtable(String path, String wordfile) {
        if (path == null || wordfile == null) {
            return new Hashtable();
        }
        return WordlistLoader.getWordtable(new File(path, wordfile));
    }

    public static Hashtable getWordtable(String wordfile) {
        if (wordfile == null) {
            return new Hashtable();
        }
        return WordlistLoader.getWordtable(new File(wordfile));
    }

    public static Hashtable getWordtable(File wordfile) {
        if (wordfile == null) {
            return new Hashtable();
        }
        Hashtable result = null;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(wordfile));
            String word = null;
            String[] stopwords = new String[100];
            int wordcount = 0;
            while ((word = lnr.readLine()) != null) {
                if (++wordcount == stopwords.length) {
                    String[] tmp = new String[stopwords.length + 50];
                    System.arraycopy(stopwords, 0, tmp, 0, wordcount);
                    stopwords = tmp;
                }
                stopwords[wordcount - 1] = word;
            }
            result = WordlistLoader.makeWordTable(stopwords, wordcount);
        }
        catch (IOException e) {
            result = new Hashtable();
        }
        return result;
    }

    private static Hashtable makeWordTable(String[] words, int length) {
        Hashtable<String, String> table = new Hashtable<String, String>(length);
        for (int i = 0; i < length; ++i) {
            table.put(words[i], words[i]);
        }
        return table;
    }
}

