/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.event;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ThreadReferenceImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.event.AccessWatchpointEventImpl;
import org.eclipse.jdi.internal.event.BreakpointEventImpl;
import org.eclipse.jdi.internal.event.ClassPrepareEventImpl;
import org.eclipse.jdi.internal.event.ClassUnloadEventImpl;
import org.eclipse.jdi.internal.event.EventMessages;
import org.eclipse.jdi.internal.event.ExceptionEventImpl;
import org.eclipse.jdi.internal.event.MethodEntryEventImpl;
import org.eclipse.jdi.internal.event.MethodExitEventImpl;
import org.eclipse.jdi.internal.event.ModificationWatchpointEventImpl;
import org.eclipse.jdi.internal.event.StepEventImpl;
import org.eclipse.jdi.internal.event.ThreadDeathEventImpl;
import org.eclipse.jdi.internal.event.ThreadStartEventImpl;
import org.eclipse.jdi.internal.event.VMDeathEventImpl;
import org.eclipse.jdi.internal.event.VMDisconnectEventImpl;
import org.eclipse.jdi.internal.event.VMStartEventImpl;
import org.eclipse.jdi.internal.request.RequestID;

public abstract class EventImpl
extends MirrorImpl
implements Event {
    public static final byte EVENT_SINGLE_STEP = 1;
    public static final byte EVENT_BREAKPOINT = 2;
    public static final byte EVENT_FRAME_POP = 3;
    public static final byte EVENT_EXCEPTION = 4;
    public static final byte EVENT_USER_DEFINED = 5;
    public static final byte EVENT_THREAD_START = 6;
    public static final byte EVENT_THREAD_END = 7;
    public static final byte EVENT_CLASS_PREPARE = 8;
    public static final byte EVENT_CLASS_UNLOAD = 9;
    public static final byte EVENT_CLASS_LOAD = 10;
    public static final byte EVENT_FIELD_ACCESS = 20;
    public static final byte EVENT_FIELD_MODIFICATION = 21;
    public static final byte EVENT_EXCEPTION_CATCH = 30;
    public static final byte EVENT_METHOD_ENTRY = 40;
    public static final byte EVENT_METHOD_EXIT = 41;
    public static final byte EVENT_VM_INIT = 90;
    public static final byte EVENT_VM_DEATH = 99;
    public static final byte EVENT_VM_DISCONNECTED = 100;
    public static final byte EVENT_VM_START = 90;
    public static final byte EVENT_THREAD_DEATH = 7;
    protected ThreadReferenceImpl fThreadRef;
    private static HashMap fEventKindMap = null;
    private RequestID fRequestID;
    private EventRequest fRequest;
    static /* synthetic */ Class class$org$eclipse$jdi$internal$event$EventImpl;

    protected EventImpl(String description, VirtualMachineImpl vmImpl, RequestID requestID) {
        super(description, vmImpl);
        this.fRequestID = requestID;
    }

    public ThreadReference thread() {
        return this.fThreadRef;
    }

    public RequestID requestID() {
        return this.fRequestID;
    }

    public String toString() {
        return super.toString() + ": " + this.fRequestID;
    }

    /*
     * WARNING - void declaration
     */
    public static EventImpl read(MirrorImpl target, DataInputStream dataInStream) throws IOException {
        void var4_4;
        byte eventKind = target.readByte("event kind", EventImpl.eventKindMap(), dataInStream);
        RequestID requestID = RequestID.read(target, dataInStream);
        switch (eventKind) {
            case 0: {
                return null;
            }
            case 20: {
                EventImpl result = AccessWatchpointEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 2: {
                EventImpl result = BreakpointEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 8: {
                EventImpl result = ClassPrepareEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 9: {
                EventImpl result = ClassUnloadEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 4: {
                EventImpl result = ExceptionEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 40: {
                EventImpl result = MethodEntryEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 41: {
                EventImpl result = MethodExitEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 21: {
                EventImpl result = ModificationWatchpointEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 1: {
                EventImpl result = StepEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 7: {
                EventImpl result = ThreadDeathEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 6: {
                EventImpl result = ThreadStartEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 99: {
                EventImpl result = VMDeathEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 100: {
                EventImpl result = VMDisconnectEventImpl.read(target, requestID, dataInStream);
                break;
            }
            case 90: {
                EventImpl result = VMStartEventImpl.read(target, requestID, dataInStream);
                break;
            }
            default: {
                throw new IOException(EventMessages.getString("EventImpl.Read_invalid_EventKind___1") + eventKind);
            }
        }
        if (!requestID.isNull()) {
            var4_4.fRequest = target.virtualMachineImpl().eventRequestManagerImpl().findRequest((EventImpl)var4_4);
        }
        return var4_4;
    }

    public EventRequest request() {
        return this.fRequest;
    }

    public static void getConstantMaps() {
        if (fEventKindMap != null) {
            return;
        }
        Field[] fields = (class$org$eclipse$jdi$internal$event$EventImpl == null ? (class$org$eclipse$jdi$internal$event$EventImpl = EventImpl.class$("org.eclipse.jdi.internal.event.EventImpl")) : class$org$eclipse$jdi$internal$event$EventImpl).getDeclaredFields();
        fEventKindMap = new HashMap();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) == 0 || (field.getModifiers() & 0x10) == 0) continue;
            try {
                String name = field.getName();
                Integer intValue = new Integer(field.getInt(null));
                if (!name.startsWith("EVENT_")) continue;
                name = name.substring(6);
                fEventKindMap.put(intValue, name);
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static Map eventKindMap() {
        EventImpl.getConstantMaps();
        return fEventKindMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

