/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LZWCodec;

final class GIFFileFormat
extends FileFormat {
    String signature;
    String version;
    boolean sorted;
    int screenWidth;
    int screenHeight;
    int backgroundPixel;
    int aspect;
    int bitsPerPixel;
    int defaultDepth;
    boolean userInput = false;
    int disposalMethod = 0;
    int delayTime = 0;
    int transparentPixel = -1;
    int repeatCount = 1;
    static final int GIF_APPLICATION_EXTENSION_BLOCK_ID = 255;
    static final int GIF_GRAPHICS_CONTROL_BLOCK_ID = 249;
    static final int GIF_PLAIN_TEXT_BLOCK_ID = 1;
    static final int GIF_COMMENT_BLOCK_ID = 254;
    static final int GIF_EXTENSION_BLOCK_ID = 33;
    static final int GIF_IMAGE_BLOCK_ID = 44;
    static final int GIF_TRAILER_ID = 59;

    GIFFileFormat() {
    }

    static PaletteData grayRamp(int numGrays) {
        int n = numGrays - 1;
        RGB[] colors = new RGB[numGrays];
        for (int i = 0; i < numGrays; ++i) {
            byte intensity = (byte)(i * 3 * 256 / n);
            colors[i] = new RGB(intensity, intensity, intensity);
        }
        return new PaletteData(colors);
    }

    boolean isFileFormat(LEDataInputStream stream) {
        try {
            byte[] signature = new byte[3];
            stream.read(signature);
            stream.unread(signature);
            return new String(signature).equals("GIF");
        }
        catch (Exception e) {
            return false;
        }
    }

    ImageData[] loadFromByteStream() {
        byte[] signatureBytes = new byte[3];
        byte[] versionBytes = new byte[3];
        byte[] block = new byte[7];
        try {
            this.inputStream.read(signatureBytes);
            this.signature = new String(signatureBytes);
            if (!this.signature.equals("GIF")) {
                SWT.error(40);
            }
            this.inputStream.read(versionBytes);
            this.version = new String(versionBytes);
            this.inputStream.read(block);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        this.loader.logicalScreenWidth = this.screenWidth = block[0] & 0xFF | (block[1] & 0xFF) << 8;
        this.loader.logicalScreenHeight = this.screenHeight = block[2] & 0xFF | (block[3] & 0xFF) << 8;
        byte bitField = block[4];
        this.backgroundPixel = block[5] & 0xFF;
        this.aspect = block[6] & 0xFF;
        this.bitsPerPixel = (bitField >> 4 & 7) + 1;
        this.defaultDepth = (bitField & 7) + 1;
        PaletteData palette = null;
        if ((bitField & 0x80) != 0) {
            this.sorted = (bitField & 8) != 0;
            palette = this.readPalette(1 << this.defaultDepth);
        } else {
            this.sorted = false;
            this.backgroundPixel = -1;
            this.defaultDepth = this.bitsPerPixel;
        }
        this.loader.backgroundPixel = this.backgroundPixel;
        this.getExtensions();
        int id = this.readID();
        ImageData[] images = new ImageData[]{};
        while (id == 44) {
            ImageData image = this.readImageBlock(palette);
            if (this.loader.hasListeners()) {
                this.loader.notifyListeners(new ImageLoaderEvent(this.loader, image, 3, true));
            }
            ImageData[] oldImages = images;
            images = new ImageData[oldImages.length + 1];
            System.arraycopy(oldImages, 0, images, 0, oldImages.length);
            images[images.length - 1] = image;
            try {
                id = this.inputStream.read();
                if (id > 0) {
                    this.inputStream.unread(new byte[]{(byte)id});
                }
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
            this.getExtensions();
            id = this.readID();
        }
        return images;
    }

    int readID() {
        try {
            return this.inputStream.read();
        }
        catch (IOException e) {
            SWT.error(39, e);
            return -1;
        }
    }

    void getExtensions() {
        int id = this.readID();
        while (id != 44 && id != 59 && id > 0) {
            if (id == 33) {
                this.readExtension();
            } else {
                SWT.error(40);
            }
            id = this.readID();
        }
        if (id == 44 || id == 59) {
            try {
                this.inputStream.unread(new byte[]{(byte)id});
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
        }
    }

    byte[] readExtension() {
        int extensionID = this.readID();
        if (extensionID == 254) {
            return this.readCommentExtension();
        }
        if (extensionID == 1) {
            return this.readPlainTextExtension();
        }
        if (extensionID == 249) {
            return this.readGraphicsControlExtension();
        }
        if (extensionID == 255) {
            return this.readApplicationExtension();
        }
        try {
            int extSize = this.inputStream.read();
            if (extSize < 0) {
                SWT.error(40);
            }
            byte[] ext = new byte[extSize];
            this.inputStream.read(ext, 0, extSize);
            return ext;
        }
        catch (IOException e) {
            SWT.error(39, e);
            return null;
        }
    }

    byte[] readCommentExtension() {
        try {
            byte[] comment = new byte[]{};
            byte[] block = new byte[255];
            int size = this.inputStream.read();
            while (size > 0 && this.inputStream.read(block, 0, size) != -1) {
                byte[] oldComment = comment;
                comment = new byte[oldComment.length + size];
                System.arraycopy(oldComment, 0, comment, 0, oldComment.length);
                System.arraycopy(block, 0, comment, oldComment.length, size);
                size = this.inputStream.read();
            }
            return comment;
        }
        catch (Exception e) {
            SWT.error(39, e);
            return null;
        }
    }

    byte[] readPlainTextExtension() {
        try {
            this.inputStream.read();
            byte[] info = new byte[12];
            this.inputStream.read(info);
            byte[] text = new byte[]{};
            byte[] block = new byte[255];
            int size = this.inputStream.read();
            while (size > 0 && this.inputStream.read(block, 0, size) != -1) {
                byte[] oldText = text;
                text = new byte[oldText.length + size];
                System.arraycopy(oldText, 0, text, 0, oldText.length);
                System.arraycopy(block, 0, text, oldText.length, size);
                size = this.inputStream.read();
            }
            return text;
        }
        catch (Exception e) {
            SWT.error(39, e);
            return null;
        }
    }

    byte[] readGraphicsControlExtension() {
        try {
            this.inputStream.read();
            byte[] controlBlock = new byte[4];
            this.inputStream.read(controlBlock);
            byte bitField = controlBlock[0];
            this.userInput = (bitField & 2) != 0;
            this.disposalMethod = bitField >> 2 & 7;
            this.delayTime = controlBlock[1] & 0xFF | (controlBlock[2] & 0xFF) << 8;
            if ((bitField & 1) != 0) {
                int colorIndex = controlBlock[3] & 0xFF;
                if (colorIndex <= 1 << this.defaultDepth) {
                    this.transparentPixel = colorIndex;
                }
            } else {
                this.transparentPixel = -1;
            }
            this.inputStream.read();
            return controlBlock;
        }
        catch (Exception e) {
            SWT.error(39, e);
            return null;
        }
    }

    byte[] readApplicationExtension() {
        try {
            this.inputStream.read();
            byte[] applicationBytes = new byte[8];
            this.inputStream.read(applicationBytes);
            String application = new String(applicationBytes);
            byte[] authenticationBytes = new byte[3];
            this.inputStream.read(authenticationBytes);
            String authentication = new String(authenticationBytes);
            byte[] data = new byte[]{};
            byte[] block = new byte[255];
            int size = this.inputStream.read();
            while (size > 0 && this.inputStream.read(block, 0, size) != -1) {
                byte[] oldData = data;
                data = new byte[oldData.length + size];
                System.arraycopy(oldData, 0, data, 0, oldData.length);
                System.arraycopy(block, 0, data, oldData.length, size);
                size = this.inputStream.read();
            }
            if (application.equals("NETSCAPE") && authentication.equals("2.0") && data[0] == 1) {
                this.loader.repeatCount = this.repeatCount = data[1] & 0xFF | (data[2] & 0xFF) << 8;
            }
            return data;
        }
        catch (Exception e) {
            SWT.error(39, e);
            return null;
        }
    }

    ImageData readImageBlock(PaletteData defaultPalette) {
        PaletteData palette;
        int depth;
        boolean interlaced;
        byte[] block = new byte[9];
        try {
            this.inputStream.read(block);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        int left = block[0] & 0xFF | (block[1] & 0xFF) << 8;
        int top = block[2] & 0xFF | (block[3] & 0xFF) << 8;
        int width = block[4] & 0xFF | (block[5] & 0xFF) << 8;
        int height = block[6] & 0xFF | (block[7] & 0xFF) << 8;
        byte bitField = block[8];
        boolean bl = interlaced = (bitField & 0x40) != 0;
        if ((bitField & 0x80) != 0) {
            depth = (bitField & 7) + 1;
            palette = this.readPalette(1 << depth);
        } else {
            depth = this.defaultDepth;
            palette = defaultPalette;
        }
        if (depth != 1 && depth != 4 && depth != 8) {
            depth = depth < 4 ? 4 : 8;
        }
        if (palette == null) {
            palette = GIFFileFormat.grayRamp(1 << depth);
        }
        int initialCodeSize = -1;
        try {
            initialCodeSize = this.inputStream.read();
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        if (initialCodeSize < 0) {
            SWT.error(40);
        }
        ImageData image = ImageData.internal_new(width, height, depth, palette, 4, null, 0, null, null, -1, this.transparentPixel, 2, left, top, this.disposalMethod, this.delayTime);
        LZWCodec codec = new LZWCodec();
        codec.decode(this.inputStream, this.loader, image, interlaced, initialCodeSize);
        return image;
    }

    PaletteData readPalette(int numColors) {
        byte[] bytes = new byte[numColors * 3];
        try {
            if (this.inputStream.read(bytes) != bytes.length) {
                SWT.error(40);
            }
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        RGB[] colors = new RGB[numColors];
        for (int i = 0; i < numColors; ++i) {
            colors[i] = new RGB(bytes[i * 3] & 0xFF, bytes[i * 3 + 1] & 0xFF, bytes[i * 3 + 2] & 0xFF);
        }
        return new PaletteData(colors);
    }

    void unloadIntoByteStream(ImageData image) {
        if (image.depth != 1 && image.depth != 4 && image.depth != 8) {
            SWT.error(38);
        }
        byte bitField = (byte)(128 + (image.depth - 1) + (image.depth - 1) * 16);
        try {
            this.outputStream.write(new byte[]{71, 73, 70});
            this.outputStream.write(new byte[]{56, 57, 97});
            this.outputStream.writeShort((short)image.width);
            this.outputStream.writeShort((short)image.height);
            this.outputStream.writeByte(bitField);
            this.outputStream.writeByte((byte)0);
            this.outputStream.writeByte((byte)0);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        this.writePalette(image.palette, image.depth);
        if (image.transparentPixel != -1 || image.disposalMethod != 0 || image.delayTime != 0) {
            this.writeGraphicsControlBlock(image);
        }
        this.writeImageBlock(image);
        try {
            this.outputStream.write(59);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
    }

    void writeGraphicsControlBlock(ImageData image) {
        try {
            this.outputStream.write(33);
            this.outputStream.write(249);
            this.outputStream.write(4);
            byte[] gcBlock = new byte[]{-3, 0, 0, 0};
            if (image.transparentPixel == -1) {
                gcBlock[0] = (byte)(gcBlock[0] & 0xFE);
            } else {
                gcBlock[0] = (byte)(gcBlock[0] | 1);
                gcBlock[3] = (byte)image.transparentPixel;
            }
            if (image.disposalMethod != 0) {
                gcBlock[0] = (byte)(gcBlock[0] | (image.disposalMethod & 7) << 2);
            }
            if (image.delayTime != 0) {
                gcBlock[1] = (byte)(image.delayTime & 0xFF);
                gcBlock[2] = (byte)(image.delayTime >> 8 & 0xFF);
            }
            this.outputStream.write(gcBlock);
            this.outputStream.write(0);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
    }

    void writeImageBlock(ImageData image) {
        try {
            this.outputStream.write(44);
            byte[] block = new byte[]{(byte)(image.x & 0xFF), (byte)(image.x >> 8 & 0xFF), (byte)(image.y & 0xFF), (byte)(image.y >> 8 & 0xFF), (byte)(image.width & 0xFF), (byte)(image.width >> 8 & 0xFF), (byte)(image.height & 0xFF), (byte)(image.height >> 8 & 0xFF), 0};
            this.outputStream.write(block);
            this.outputStream.write(image.depth);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        new LZWCodec().encode(this.outputStream, image);
    }

    void writePalette(PaletteData palette, int depth) {
        byte[] bytes = new byte[(1 << depth) * 3];
        int offset = 0;
        for (int i = 0; i < palette.colors.length; ++i) {
            RGB color = palette.colors[i];
            bytes[offset] = (byte)color.red;
            bytes[offset + 1] = (byte)color.green;
            bytes[offset + 2] = (byte)color.blue;
            offset += 3;
        }
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
    }
}

