/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.PseudoJavaChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.text.edits.TextEdit;

class ChangeElementContentProvider
implements ITreeContentProvider {
    private static final ChangeElement[] EMPTY_CHILDREN = new ChangeElement[0];
    static /* synthetic */ Class class$org$eclipse$jdt$core$ICompilationUnit;

    ChangeElementContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object o) {
        ChangeElement element = (ChangeElement)o;
        Object[] children = element.getChildren();
        if (children == null) {
            children = this.createChildren(element);
        }
        return children;
    }

    public Object getParent(Object element) {
        return ((ChangeElement)element).getParent();
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    private ChangeElement[] createChildren(ChangeElement object) {
        ChangeElement[] result = EMPTY_CHILDREN;
        if (!(object instanceof DefaultChangeElement)) {
            return result;
        }
        DefaultChangeElement changeElement = (DefaultChangeElement)object;
        Change change = changeElement.getChange();
        if (change instanceof CompositeChange) {
            ArrayList children = new ArrayList();
            this.getFlattendedChildren(children, changeElement, (CompositeChange)change);
            result = children.toArray(new ChangeElement[children.size()]);
        } else if (change instanceof TextChange) {
            TextChange textChange = (TextChange)change;
            ICompilationUnit cunit = (ICompilationUnit)textChange.getAdapter(class$org$eclipse$jdt$core$ICompilationUnit == null ? (class$org$eclipse$jdt$core$ICompilationUnit = ChangeElementContentProvider.class$("org.eclipse.jdt.core.ICompilationUnit")) : class$org$eclipse$jdt$core$ICompilationUnit);
            if (cunit != null) {
                ArrayList<TextEditChangeElement> children = new ArrayList<TextEditChangeElement>(5);
                HashMap map = new HashMap(20);
                TextEditChangeGroup[] changes = this.getSortedTextEditChanges(textChange);
                for (int i = 0; i < changes.length; ++i) {
                    TextEditChangeGroup tec = changes[i];
                    try {
                        IJavaElement element = this.getModifiedJavaElement(tec, cunit);
                        if (element.equals(cunit)) {
                            children.add(new TextEditChangeElement(changeElement, tec));
                            continue;
                        }
                        PseudoJavaChangeElement pjce = this.getChangeElement(map, element, children, changeElement);
                        pjce.addChild(new TextEditChangeElement(pjce, tec));
                        continue;
                    }
                    catch (JavaModelException e) {
                        children.add(new TextEditChangeElement(changeElement, tec));
                    }
                }
                result = children.toArray(new ChangeElement[children.size()]);
            } else {
                TextEditChangeGroup[] changes = this.getSortedTextEditChanges((TextChange)change);
                result = new ChangeElement[changes.length];
                for (int i = 0; i < changes.length; ++i) {
                    result[i] = new TextEditChangeElement(changeElement, changes[i]);
                }
            }
        }
        changeElement.setChildren(result);
        return result;
    }

    private TextEditChangeGroup[] getSortedTextEditChanges(TextChange change) {
        TextEditChangeGroup[] edits = change.getTextEditChangeGroups();
        ArrayList<TextEditChangeGroup> result = new ArrayList<TextEditChangeGroup>(edits.length);
        for (int i = 0; i < edits.length; ++i) {
            if (edits[i].getTextEditGroup().isEmpty()) continue;
            result.add(edits[i]);
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditChangeGroup[result.size()]);
    }

    private PseudoJavaChangeElement getChangeElement(Map map, IJavaElement element, List children, ChangeElement cunitChange) {
        PseudoJavaChangeElement result = (PseudoJavaChangeElement)map.get(element);
        if (result != null) {
            return result;
        }
        IJavaElement parent = element.getParent();
        if (parent instanceof ICompilationUnit) {
            result = new PseudoJavaChangeElement(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            PseudoJavaChangeElement parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new PseudoJavaChangeElement(parentChange, element);
            parentChange.addChild(result);
            map.put(element, result);
        }
        return result;
    }

    private IJavaElement getModifiedJavaElement(TextEditChangeGroup edit, ICompilationUnit cunit) throws JavaModelException {
        IRegion range = edit.getRegion();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return cunit;
        }
        IJavaElement result = cunit.getElementAt(range.getOffset());
        if (result == null) {
            return cunit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getOffset(), ref.getSourceRange().getLength());
                if (result.getElementType() != 5 && result.getParent() != null && !this.coveredBy(edit, (IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException e) {
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return result;
    }

    private void getFlattendedChildren(List result, DefaultChangeElement parent, CompositeChange focus) {
        Change[] changes = focus.getChildren();
        for (int i = 0; i < changes.length; ++i) {
            Change change = changes[i];
            if (change instanceof CompositeChange && ((CompositeChange)change).isSynthetic()) {
                this.getFlattendedChildren(result, parent, (CompositeChange)change);
                continue;
            }
            result.add(new DefaultChangeElement(parent, change));
        }
    }

    public boolean coveredBy(TextEditChangeGroup group, IRegion sourceRegion) {
        int sLength = sourceRegion.getLength();
        if (sLength == 0) {
            return false;
        }
        int sOffset = sourceRegion.getOffset();
        int sEnd = sOffset + sLength - 1;
        TextEdit[] edits = group.getTextEdits();
        for (int i = 0; i < edits.length; ++i) {
            TextEdit edit = edits[i];
            if (edit.isDeleted()) {
                return false;
            }
            int rOffset = edit.getOffset();
            int rLength = edit.getLength();
            int rEnd = rOffset + rLength - 1;
            if (!(rLength == 0 ? sOffset >= rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OffsetComparator
    implements Comparator {
        private OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextEditChangeGroup c1 = (TextEditChangeGroup)o1;
            TextEditChangeGroup c2 = (TextEditChangeGroup)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }
}

