/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class ResourceRegistry {
    private ListenerList listeners = new ListenerList();

    public void addListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    protected abstract void clearCaches();

    public abstract Set getKeySet();

    public abstract boolean hasValueFor(String var1);

    protected void fireMappingChanged(String name, Object oldValue, Object newValue) {
        Object[] myListeners = this.listeners.getListeners();
        if (myListeners.length > 0) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, newValue);
            for (int i = 0; i < myListeners.length; ++i) {
                try {
                    ((IPropertyChangeListener)myListeners[i]).propertyChange(event);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }
}

