/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;

class URLImageDescriptor
extends ImageDescriptor {
    private URL url;

    URLImageDescriptor(URL url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (!(o instanceof URLImageDescriptor)) {
            return false;
        }
        return ((URLImageDescriptor)o).url.equals(this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData() {
        ImageData result = null;
        InputStream in = this.getStream();
        if (in != null) {
            try {
                result = new ImageData(in);
            }
            catch (SWTException e) {
                if (e.code != 40) {
                    throw e;
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    protected InputStream getStream() {
        try {
            return new BufferedInputStream(this.url.openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "URLImageDescriptor(" + this.url + ")";
    }
}

