/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

class MarkerUpdater
implements IMarkerUpdater {
    private static final String[] ATTRIBUTES = new String[]{"charStart", "charEnd", "lineNumber"};

    MarkerUpdater() {
    }

    public String[] getAttribute() {
        return ATTRIBUTES;
    }

    public String getMarkerType() {
        return null;
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        if (position.isDeleted()) {
            return false;
        }
        if (MarkerUtilities.getCharStart(marker) != -1 && MarkerUtilities.getCharEnd(marker) != -1) {
            MarkerUtilities.setCharStart(marker, position.getOffset());
            MarkerUtilities.setCharEnd(marker, position.getOffset() + position.getLength());
        }
        if (MarkerUtilities.getLineNumber(marker) != -1) {
            try {
                MarkerUtilities.setLineNumber(marker, document.getLineOfOffset(position.getOffset()) + 1);
            }
            catch (BadLocationException x) {
                // empty catch block
            }
        }
        return true;
    }
}

