/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class KSubstWizardSelectionPage
extends CVSWizardPage {
    private Command.KSubstOption ksubst;
    private List ksubstOptions;
    private Button automaticRadioButton;
    private Button binaryRadioButton;
    private Button textRadioButton;
    private Button ksubstRadioButton;
    private Combo ksubstOptionCombo;

    public KSubstWizardSelectionPage(String pageName, String title, ImageDescriptor image, Command.KSubstOption defaultKSubst) {
        super(pageName, title, image);
        this.ksubst = defaultKSubst;
        Command.KSubstOption[] options = Command.KSubstOption.getAllKSubstOptions();
        this.ksubstOptions = new ArrayList();
        for (int i = 0; i < options.length; ++i) {
            Command.KSubstOption option = options[i];
            if (Command.KSUBST_BINARY.equals((Object)option) || Command.KSUBST_TEXT.equals((Object)option)) continue;
            this.ksubstOptions.add(option);
        }
        Collections.sort(this.ksubstOptions, new Comparator(){

            public int compare(Object a, Object b) {
                String aKey = ((Command.KSubstOption)a).getLongDisplayText();
                String bKey = ((Command.KSubstOption)b).getLongDisplayText();
                return aKey.compareTo(bKey);
            }
        });
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        this.setControl((Control)top);
        WorkbenchHelp.setHelp((Control)top, (String)"org.eclipse.team.cvs.ui.keyword_substituton_selection_page_context");
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                KSubstWizardSelectionPage.this.updateEnablements();
            }
        };
        this.automaticRadioButton = this.createRadioButton(top, Policy.bind("KSubstWizardSelectionPage.automaticButton"), 1);
        this.automaticRadioButton.addListener(13, selectionListener);
        this.automaticRadioButton.setSelection(this.ksubst == null);
        this.createWrappingLabel(top, Policy.bind("KSubstWizardSelectionPage.automaticLabel", Command.KSUBST_BINARY.getLongDisplayText(), CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption().getLongDisplayText()), 32);
        this.binaryRadioButton = this.createRadioButton(top, Policy.bind("KSubstWizardSelectionPage.binaryButton"), 1);
        this.binaryRadioButton.addListener(13, selectionListener);
        this.binaryRadioButton.setSelection(Command.KSUBST_BINARY.equals((Object)this.ksubst));
        KSubstWizardSelectionPage.createIndentedLabel(top, Policy.bind("KSubstWizardSelectionPage.binaryLabel"), 32);
        this.textRadioButton = this.createRadioButton(top, Policy.bind("KSubstWizardSelectionPage.textButton"), 1);
        this.textRadioButton.addListener(13, selectionListener);
        this.textRadioButton.setSelection(Command.KSUBST_TEXT.equals((Object)this.ksubst));
        KSubstWizardSelectionPage.createIndentedLabel(top, Policy.bind("KSubstWizardSelectionPage.textLabel"), 32);
        this.ksubstRadioButton = this.createRadioButton(top, Policy.bind("KSubstWizardSelectionPage.textWithSubstitutionsButton"), 1);
        this.ksubstRadioButton.addListener(13, selectionListener);
        this.ksubstRadioButton.setSelection(false);
        KSubstWizardSelectionPage.createIndentedLabel(top, Policy.bind("KSubstWizardSelectionPage.textWithSubstitutionsLabel"), 32);
        this.ksubstOptionCombo = new Combo(top, 8);
        this.ksubstOptionCombo.addListener(13, selectionListener);
        GridData data = new GridData(48);
        data.horizontalIndent = 32;
        this.ksubstOptionCombo.setLayoutData((Object)data);
        for (int i = 0; i < this.ksubstOptions.size(); ++i) {
            Command.KSubstOption option = (Command.KSubstOption)this.ksubstOptions.get(i);
            this.ksubstOptionCombo.add(option.getLongDisplayText());
            if (option.equals((Object)this.ksubst)) {
                this.ksubstOptionCombo.select(i);
                this.ksubstRadioButton.setSelection(true);
                continue;
            }
            if (!option.equals((Object)Command.KSUBST_TEXT_EXPAND) || this.ksubstRadioButton.getSelection()) continue;
            this.ksubstOptionCombo.select(i);
        }
        this.updateEnablements();
        Dialog.applyDialogFont((Control)parent);
    }

    protected void updateEnablements() {
        if (this.ksubstRadioButton.getSelection()) {
            this.ksubstOptionCombo.setEnabled(true);
            this.ksubst = (Command.KSubstOption)this.ksubstOptions.get(this.ksubstOptionCombo.getSelectionIndex());
        } else {
            this.ksubstOptionCombo.setEnabled(false);
            if (this.automaticRadioButton.getSelection()) {
                this.ksubst = null;
            } else if (this.binaryRadioButton.getSelection()) {
                this.ksubst = Command.KSUBST_BINARY;
            } else if (this.textRadioButton.getSelection()) {
                this.ksubst = Command.KSUBST_TEXT;
            }
        }
    }

    public Command.KSubstOption getKSubstOption() {
        return this.ksubst;
    }
}

