/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComputeNodeOrder {
    public static Object[][] computeNodeOrder(Object[] objects, Object[][] references) {
        Object[][] knots;
        int i;
        Digraph g1 = new Digraph();
        for (i = 0; i < objects.length; ++i) {
            g1.addVertex(objects[i]);
        }
        for (i = 0; i < references.length; ++i) {
            g1.addEdge(references[i][1], references[i][0]);
        }
        g1.freeze();
        Digraph g2 = new Digraph();
        List resortedVertexes = g1.idsByDFSFinishTime(false);
        Iterator it = resortedVertexes.iterator();
        while (it.hasNext()) {
            g2.addVertex(it.next());
        }
        for (int i2 = 0; i2 < references.length; ++i2) {
            g2.addEdge(references[i2][0], references[i2][1]);
        }
        g2.freeze();
        List sortedProjectList = g2.idsByDFSFinishTime(true);
        Object[] orderedNodes = new Object[sortedProjectList.size()];
        sortedProjectList.toArray(orderedNodes);
        boolean hasCycles = g2.containsCycles();
        if (hasCycles) {
            List knotList = g2.nonTrivialComponents();
            knots = (Object[][])knotList.toArray((T[])new Object[knotList.size()][]);
        } else {
            knots = new Object[][]{};
        }
        for (int i3 = 0; i3 < orderedNodes.length; ++i3) {
            objects[i3] = orderedNodes[i3];
        }
        return knots;
    }

    private ComputeNodeOrder() {
    }

    private static class Digraph {
        private boolean cycles = false;
        private boolean initialized = false;
        private int time;
        private List vertexList = new ArrayList(100);
        private Map vertexMap = new HashMap(100);

        public void addEdge(Object fromId, Object toId) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex fromVertex = (Vertex)this.vertexMap.get(fromId);
            Vertex toVertex = (Vertex)this.vertexMap.get(toId);
            if (fromVertex == null) {
                throw new IllegalArgumentException();
            }
            if (toVertex == null) {
                throw new IllegalArgumentException();
            }
            fromVertex.adjacent.add(toVertex);
        }

        public void addVertex(Object id) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = new Vertex(id);
            Vertex existing = this.vertexMap.put(id, vertex);
            if (existing != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        private void DFS() {
            boolean NEXT_VERTEX = true;
            int START_DFS_VISIT = 2;
            int NEXT_ADJACENT = 3;
            int AFTER_NEXTED_DFS_VISIT = 4;
            Integer NEXT_VERTEX_OBJECT = new Integer(1);
            Integer AFTER_NEXTED_DFS_VISIT_OBJECT = new Integer(4);
            this.time = 0;
            ArrayList<Object> stack = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Iterator allAdjacent = null;
            Vertex vertex = null;
            Iterator allV = this.vertexList.iterator();
            int state = 1;
            block6: while (true) {
                switch (state) {
                    case 1: {
                        if (!allV.hasNext()) break block6;
                        Vertex nextVertex = (Vertex)allV.next();
                        if (nextVertex.color == "white") {
                            stack.add(NEXT_VERTEX_OBJECT);
                            vertex = nextVertex;
                            state = 2;
                            continue block6;
                        }
                        state = 1;
                        continue block6;
                    }
                    case 2: {
                        vertex.color = "grey";
                        allAdjacent = vertex.adjacent.iterator();
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        if (allAdjacent.hasNext()) {
                            Vertex adjVertex = (Vertex)allAdjacent.next();
                            if (adjVertex.color == "white") {
                                adjVertex.predecessor = vertex;
                                stack.add(allAdjacent);
                                stack.add(vertex);
                                stack.add(AFTER_NEXTED_DFS_VISIT_OBJECT);
                                vertex = adjVertex;
                                state = 2;
                                continue block6;
                            }
                            if (adjVertex.color == "grey") {
                                this.cycles = true;
                            }
                            state = 3;
                            continue block6;
                        }
                        vertex.color = "black";
                        vertex.finishTime = ++this.time;
                        state = (Integer)stack.remove(stack.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        vertex = (Vertex)stack.remove(stack.size() - 1);
                        allAdjacent = (Iterator)stack.remove(stack.size() - 1);
                        state = 3;
                        continue block6;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public List idsByDFSFinishTime(boolean increasing) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int len = this.vertexList.size();
            Object[] r = new Object[len];
            Iterator allV = this.vertexList.iterator();
            while (allV.hasNext()) {
                Vertex vertex = (Vertex)allV.next();
                int f = vertex.finishTime;
                if (increasing) {
                    r[f - 1] = vertex.id;
                    continue;
                }
                r[len - f] = vertex.id;
            }
            return Arrays.asList(r);
        }

        public List nonTrivialComponents() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            HashMap<Vertex, ArrayList<Object>> components = new HashMap<Vertex, ArrayList<Object>>();
            Iterator it = this.vertexList.iterator();
            while (it.hasNext()) {
                Vertex vertex = (Vertex)it.next();
                if (vertex.predecessor == null) continue;
                Vertex root = vertex;
                while (root.predecessor != null) {
                    root = root.predecessor;
                }
                ArrayList<Object> component = (ArrayList<Object>)components.get(root);
                if (component == null) {
                    component = new ArrayList<Object>(2);
                    component.add(root.id);
                    components.put(root, component);
                }
                component.add(vertex.id);
            }
            ArrayList<Object[]> result = new ArrayList<Object[]>(components.size());
            Iterator it2 = components.values().iterator();
            while (it2.hasNext()) {
                List component = (List)it2.next();
                if (component.size() <= 1) continue;
                result.add(component.toArray());
            }
            return result;
        }

        public static class Vertex {
            public static final String BLACK = "black";
            public static final String GREY = "grey";
            public static final String WHITE = "white";
            public List adjacent = new ArrayList(3);
            public String color = "white";
            public int finishTime;
            public Object id;
            public Vertex predecessor = null;

            public Vertex(Object id) {
                this.id = id;
            }
        }
    }
}

