/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.ObjectStorePage;
import org.eclipse.core.internal.indexing.PageStore;

class SpaceMapPage
extends ObjectStorePage {
    private static int[] SpaceClassSize = new int[]{7616, 6906, 6196, 5486, 4776, 4066, 3356, 2646, 1936, 1226, 516, 258, 129, 64, 32, 0};

    public static int freeSpaceForClass(int spaceClass) {
        return SpaceClassSize[spaceClass];
    }

    public static int[] generateSpaceClassSize() {
        int i;
        int[] result = new int[16];
        int n = 710;
        for (i = 0; i < 11; ++i) {
            result[i] = 7616 - i * n;
        }
        for (i = 11; i < 15; ++i) {
            result[i] = result[i - 1] / 2;
        }
        result[15] = 0;
        return result;
    }

    public SpaceMapPage(int pageNumber, byte[] buffer, PageStore pageStore) {
        super(pageNumber, buffer, pageStore);
    }

    public void toBuffer(byte[] buffer) {
        int n = Math.min(buffer.length, this.pageBuffer.length());
        System.arraycopy(this.pageBuffer.getByteArray(), 0, buffer, 0, n);
    }

    public int getFreeSpace(int pageNumber) {
        int slot = pageNumber - this.pageNumber;
        if (slot < 1 || slot >= 8192) {
            return 0;
        }
        byte spaceClass = this.pageBuffer.getByte(slot);
        int freeSpace = SpaceMapPage.freeSpaceForClass(spaceClass);
        return freeSpace;
    }

    public void setFreeSpace(int pageNumber, int freeSpace) {
        int slot = pageNumber - this.pageNumber;
        if (slot < 1 || slot >= 8192) {
            return;
        }
        byte spaceClass = 0;
        while (SpaceClassSize[spaceClass] > freeSpace) {
            spaceClass = (byte)(spaceClass + 1);
        }
        this.pageBuffer.put(slot, spaceClass);
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isSpaceMapPage() {
        return true;
    }

    protected void materialize() {
    }
}

