/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.ClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.ClasspathModel;
import org.eclipse.ant.internal.ui.preferences.GlobalClasspathEntries;
import org.eclipse.ant.internal.ui.preferences.IClasspathEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class AntClasspathContentProvider
implements ITreeContentProvider {
    private TreeViewer treeViewer;
    private ClasspathModel model = null;
    private boolean refreshEnabled = false;
    private boolean refreshRequested = false;

    public void add(IClasspathEntry parent, Object child) {
        ClasspathEntry newClasspathEntry;
        GlobalClasspathEntries globalParent;
        Object newEntry = null;
        boolean added = false;
        if (parent == null || parent == this.model) {
            added = true;
            newEntry = this.model.addEntry(child);
            if (newEntry == null) {
                newEntry = this.model.createEntry(child, this.model);
                added = false;
            }
            parent = this.model;
        } else if (parent instanceof GlobalClasspathEntries && !(globalParent = (GlobalClasspathEntries)parent).contains(newClasspathEntry = (ClasspathEntry)(newEntry = this.model.createEntry(child, globalParent)))) {
            added = true;
            globalParent.addEntry(newClasspathEntry);
        }
        if (newEntry != null) {
            if (added) {
                this.treeViewer.add((Object)parent, newEntry);
            }
            this.treeViewer.setExpandedState((Object)parent, true);
            this.treeViewer.setSelection((ISelection)new StructuredSelection(newEntry), true);
            this.refresh();
        }
    }

    public void add(int entryType, Object child) {
        Object newEntry = this.model.addEntry(entryType, child);
        if (newEntry != null) {
            this.treeViewer.add(this.getParent(newEntry), newEntry);
            this.refresh();
        }
    }

    public void removeAll() {
        this.model.removeAll();
        this.refresh();
    }

    private void refresh() {
        if (this.refreshEnabled) {
            this.treeViewer.refresh();
            this.refreshRequested = false;
        } else {
            this.refreshRequested = true;
        }
    }

    public void removeAllGlobalAntClasspathEntries() {
        this.model.removeAll(0);
        this.refresh();
    }

    public Object getParent(Object element) {
        if (element instanceof ClasspathEntry) {
            return ((ClasspathEntry)element).getParent();
        }
        if (element instanceof GlobalClasspathEntries) {
            return this.model;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ClasspathEntry) {
            return false;
        }
        if (element instanceof GlobalClasspathEntries) {
            return ((GlobalClasspathEntries)element).hasEntries();
        }
        if (element instanceof ClasspathModel) {
            return ((ClasspathModel)element).hasEntries();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = (TreeViewer)viewer;
        if (newInput != null) {
            this.model = (ClasspathModel)newInput;
        } else {
            if (this.model != null) {
                this.model.removeAll();
            }
            this.model = null;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GlobalClasspathEntries) {
            return ((GlobalClasspathEntries)parentElement).getEntries();
        }
        if (parentElement instanceof ClasspathModel) {
            return ((ClasspathModel)parentElement).getEntries();
        }
        if (parentElement == null) {
            ArrayList<IAntClasspathEntry> all = new ArrayList<IAntClasspathEntry>();
            IAntClasspathEntry[] topEntries = this.model.getEntries();
            for (int i = 0; i < topEntries.length; ++i) {
                IAntClasspathEntry object = topEntries[i];
                if (object instanceof ClasspathEntry) {
                    all.add(object);
                    continue;
                }
                if (!(object instanceof GlobalClasspathEntries)) continue;
                all.addAll(Arrays.asList(((GlobalClasspathEntries)object).getEntries()));
            }
            return all.toArray();
        }
        return null;
    }

    public void remove(IStructuredSelection selection) {
        Object[] array = selection.toArray();
        this.model.removeAll(array);
        this.treeViewer.remove(array);
        this.refresh();
    }

    public ClasspathModel getModel() {
        return this.model;
    }

    public void setRefreshEnabled(boolean refreshEnabled) {
        this.refreshEnabled = refreshEnabled;
        this.treeViewer.getTree().setRedraw(refreshEnabled);
        if (refreshEnabled && this.refreshRequested) {
            this.refresh();
        }
    }

    public void setEntries(IClasspathEntry currentParent, List entries) {
        if (currentParent instanceof GlobalClasspathEntries) {
            GlobalClasspathEntries group = (GlobalClasspathEntries)currentParent;
            group.setEntries(entries);
        }
    }
}

