/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.ide.registry.IDERegistryReader;
import org.eclipse.ui.internal.ide.registry.ProjectImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ProjectImageRegistryReader
extends IDERegistryReader {
    private static final String TAG_IMAGE = "image";
    private static final String ATT_ID = "id";
    private static final String ATT_NATURE_ID = "natureId";
    private static final String ATT_ICON = "icon";
    private ProjectImageRegistry registry;

    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_IMAGE)) {
            return false;
        }
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            this.logMissingAttribute(element, ATT_ID);
            return true;
        }
        String natureId = element.getAttribute(ATT_NATURE_ID);
        if (natureId == null) {
            this.logMissingAttribute(element, ATT_NATURE_ID);
            return true;
        }
        String icon = element.getAttribute(ATT_ICON);
        if (icon == null) {
            this.logMissingAttribute(element, ATT_ICON);
            return true;
        }
        IExtension extension = element.getDeclaringExtension();
        String extendingPluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)icon);
        if (image != null) {
            this.registry.setNatureImage(natureId, image);
        }
        return true;
    }

    public void readProjectNatureImages(IPluginRegistry in, ProjectImageRegistry out) {
        this.registry = out;
        this.readRegistry(in, "org.eclipse.ui.ide", "projectNatureImages");
    }
}

