/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.Messages;

public class ActionCopyMarker
extends SelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private IField[] properties;

    public ActionCopyMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, Messages.getString("copyAction.title"));
        this.part = part;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    void setProperties(IField[] properties) {
        this.properties = properties;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty() || this.clipboard == null) {
            return;
        }
        List list = selection.toList();
        IMarker[] markers = new IMarker[list.size()];
        list.toArray(markers);
        this.setClipboard(markers, this.createMarkerReport(markers));
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private void setClipboard(IMarker[] markers, String markerReport) {
        block5: {
            try {
                Transfer[] transferTypes;
                Object[] data;
                if (markerReport == null) {
                    data = new Object[]{markers};
                    transferTypes = new Transfer[]{MarkerTransfer.getInstance()};
                } else {
                    data = new Object[]{markers, markerReport};
                    transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                }
                this.clipboard.setContents(data, transferTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.part.getSite().getShell(), (String)Messages.getString("CopyToClipboardProblemDialog.title"), (String)Messages.getString("CopyToClipboardProblemDialog.message"))) break block5;
                this.setClipboard(markers, markerReport);
            }
        }
    }

    String createMarkerReport(IMarker[] rawMarkers) {
        int i;
        ConcreteMarker[] markers;
        try {
            markers = MarkerList.createMarkers(rawMarkers);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.getString("Error"), null, (IStatus)e.getStatus());
            return "";
        }
        StringBuffer report = new StringBuffer();
        String NEWLINE = System.getProperty("line.separator");
        int DELIMITER = 9;
        if (this.properties == null) {
            return null;
        }
        for (i = 0; i < this.properties.length; ++i) {
            report.append(this.properties[i].getDescription());
            if (i == this.properties.length - 1) {
                report.append(NEWLINE);
                continue;
            }
            report.append('\t');
        }
        for (i = 0; i < markers.length; ++i) {
            ConcreteMarker marker = markers[i];
            for (int j = 0; j < this.properties.length; ++j) {
                report.append(this.properties[j].getValue(marker));
                if (j == this.properties.length - 1) {
                    report.append(NEWLINE);
                    continue;
                }
                report.append('\t');
            }
        }
        return report.toString();
    }
}

