/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionRemoveMarker
extends SelectionProviderAction {
    private IWorkbenchPart part;

    public ActionRemoveMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, Messages.getString("deleteAction.title"));
        this.part = part;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setToolTipText(Messages.getString("deleteAction.tooltip"));
        this.setEnabled(false);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        final IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Iterator iter = selection.iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        if (!(o instanceof IMarker)) continue;
                        IMarker marker = (IMarker)o;
                        marker.delete();
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.getString("RemoveMarker.errorTitle"), null, (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IMarker)) {
                return;
            }
            IMarker marker = (IMarker)obj;
            if (Util.isEditable(marker)) continue;
            return;
        }
        this.setEnabled(true);
    }
}

