/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

class MarkerType {
    private MarkerTypesModel model;
    private String id;
    private String label;
    private String[] supertypeIds;

    public MarkerType(MarkerTypesModel model, String id, String label, String[] supertypeIds) {
        this.model = model;
        this.id = id;
        this.label = label;
        this.supertypeIds = supertypeIds;
    }

    public MarkerType[] getAllSupertypes() {
        ArrayList result = new ArrayList();
        this.getAllSupertypes(result);
        return result.toArray(new MarkerType[result.size()]);
    }

    private void getAllSupertypes(ArrayList result) {
        MarkerType[] supers = this.getSupertypes();
        for (int i = 0; i < supers.length; ++i) {
            MarkerType sup = supers[i];
            if (result.contains(sup)) continue;
            result.add(sup);
            sup.getAllSupertypes(result);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public MarkerType[] getSubtypes() {
        MarkerType[] types = this.model.getTypes();
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        for (int i = 0; i < types.length; ++i) {
            MarkerType type = types[i];
            String[] supers = type.getSupertypeIds();
            for (int j = 0; j < supers.length; ++j) {
                if (!supers[j].equals(this.id)) continue;
                result.add(type);
            }
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public MarkerType[] getAllSubTypes() {
        ArrayList subTypes = new ArrayList();
        this.addSubTypes(subTypes, this);
        MarkerType[] subs = new MarkerType[subTypes.size()];
        subTypes.toArray(subs);
        return subs;
    }

    private void addSubTypes(List list, MarkerType superType) {
        MarkerType[] subTypes = superType.getSubtypes();
        for (int i = 0; i < subTypes.length; ++i) {
            MarkerType subType = subTypes[i];
            if (!list.contains(subType)) {
                list.add(subType);
            }
            this.addSubTypes(list, subType);
        }
    }

    public String[] getSupertypeIds() {
        return this.supertypeIds;
    }

    public MarkerType[] getSupertypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        for (int i = 0; i < this.supertypeIds.length; ++i) {
            MarkerType sup = this.model.getType(this.supertypeIds[i]);
            if (sup == null) continue;
            result.add(sup);
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public boolean isSubtypeOf(MarkerType superType) {
        if (this.id.equals(superType.getId())) {
            return true;
        }
        for (int i = 0; i < this.supertypeIds.length; ++i) {
            MarkerType sup = this.model.getType(this.supertypeIds[i]);
            if (sup == null || !sup.isSubtypeOf(superType)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MarkerType)) {
            return false;
        }
        return ((MarkerType)other).getId().equals(this.id);
    }
}

