/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskListMessages;

public class TaskPropertiesDialog
extends Dialog {
    private IMarker marker = null;
    private IResource resource = null;
    private Map initialAttributes = null;
    private Text descriptionText;
    private Label creationTime;
    private Combo priorityCombo;
    private Button completedCheckbox;
    private Label severityLabel;
    private Text resourceText;
    private Text folderText;
    private Text locationText;
    private boolean dirty;

    public TaskPropertiesDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setInitialAttributes(Map initialAttributes) {
        this.initialAttributes = initialAttributes;
    }

    public Map getInitialAttributes() {
        return this.initialAttributes;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.marker == null) {
            newShell.setText(TaskListMessages.getString("TaskProp.newTaskTitle"));
        } else {
            String kind = MarkerUtil.getKindText(this.marker);
            newShell.setText(TaskListMessages.format("TaskProp.propertiesTitle", new Object[]{kind}));
        }
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.task_properties_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createDescriptionArea(composite);
        if (this.marker != null) {
            this.createCreationTimeArea(composite);
        }
        if (this.isTask()) {
            this.createPriorityAndStatusArea(composite);
        } else {
            this.createSeverityArea(composite);
        }
        this.createResourceArea(composite);
        this.updateDialogFromMarker();
        return composite;
    }

    private void createCreationTimeArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(TaskListMessages.getString("TaskProp.creationTime"));
        label.setFont(font);
        this.creationTime = new Label(composite, 0);
        this.creationTime.setFont(font);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.isEditable()) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    private void createDescriptionArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(TaskListMessages.getString("TaskProp.description"));
        label.setFont(font);
        int style = 2052;
        if (!this.isEditable()) {
            style |= 8;
        }
        this.descriptionText = new Text(composite, style);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.setFont(font);
    }

    private void createPriorityAndStatusArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(TaskListMessages.getString("TaskProp.priority"));
        label.setFont(font);
        this.priorityCombo = new Combo(composite, 8);
        this.priorityCombo.setItems(new String[]{TaskListMessages.getString("TaskList.high"), TaskListMessages.getString("TaskList.normal"), TaskListMessages.getString("TaskList.low")});
        this.priorityCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.priorityCombo.setFont(font);
        this.completedCheckbox = new Button(composite, 32);
        this.completedCheckbox.setText(TaskListMessages.getString("TaskProp.completed"));
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        this.completedCheckbox.setFont(font);
        if (!this.isEditable()) {
            this.priorityCombo.setEnabled(false);
            this.completedCheckbox.setEnabled(false);
        }
    }

    private void createSeverityArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(TaskListMessages.getString("TaskProp.severity"));
        label.setFont(font);
        this.severityLabel = new Label(composite, 0);
        this.severityLabel.setFont(font);
    }

    private void createResourceArea(Composite parent) {
        IResource resource = this.getResource();
        if (this.marker == null) {
            if (resource == null) {
                return;
            }
            if ((resource.getType() & 7) == 0) {
                return;
            }
        }
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label resourceLabel = new Label(composite, 0);
        resourceLabel.setText(TaskListMessages.getString("TaskProp.onResource"));
        resourceLabel.setFont(font);
        this.resourceText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.resourceText.setLayoutData((Object)gridData);
        this.resourceText.setFont(font);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(TaskListMessages.getString("TaskProp.inFolder"));
        folderLabel.setFont(font);
        this.folderText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.folderText.setLayoutData((Object)gridData);
        this.folderText.setFont(font);
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText(TaskListMessages.getString("TaskProp.location"));
        locationLabel.setFont(font);
        this.locationText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.locationText.setLayoutData((Object)gridData);
        this.locationText.setFont(font);
    }

    private void updateDialogFromMarker() {
        if (this.marker == null) {
            this.updateDialogForNewMarker();
            return;
        }
        this.descriptionText.setText(MarkerUtil.getMessage(this.marker));
        this.descriptionText.selectAll();
        this.creationTime.setText(MarkerUtil.getCreationTime(this.marker));
        if (this.isTask()) {
            this.priorityCombo.clearSelection();
            this.priorityCombo.select(2 - MarkerUtil.getPriority(this.marker));
            this.completedCheckbox.setSelection(MarkerUtil.isComplete(this.marker));
            this.markDirty();
        } else {
            String sev = "";
            switch (MarkerUtil.getSeverity(this.marker)) {
                case 2: {
                    sev = TaskListMessages.getString("TaskList.error");
                    break;
                }
                case 1: {
                    sev = TaskListMessages.getString("TaskList.warning");
                    break;
                }
                case 0: {
                    sev = TaskListMessages.getString("TaskList.info");
                }
            }
            this.severityLabel.setText(sev);
        }
        this.resourceText.setText(MarkerUtil.getResourceName(this.marker));
        this.folderText.setText(MarkerUtil.getContainerName(this.marker));
        this.locationText.setText(MarkerUtil.getLineAndLocation(this.marker));
    }

    private void updateDialogForNewMarker() {
        Object o;
        int val;
        Object o2;
        Object o3;
        Map attrs = this.getInitialAttributes();
        String desc = "";
        if (attrs != null && (o3 = attrs.get("message")) instanceof String) {
            desc = (String)o3;
        }
        this.descriptionText.setText(desc);
        this.descriptionText.selectAll();
        int pri = 1;
        if (attrs != null && (o2 = attrs.get("priority")) instanceof Integer && (val = ((Integer)o2).intValue()) >= 0 && val <= 2) {
            pri = val;
        }
        this.priorityCombo.deselectAll();
        this.priorityCombo.select(2 - pri);
        boolean completed = false;
        if (attrs != null && (o = attrs.get("done")) instanceof Boolean) {
            completed = (Boolean)o;
        }
        this.completedCheckbox.setSelection(completed);
        IResource resource = this.getResource();
        if (resource != null && this.resourceText != null) {
            this.resourceText.setText(resource.getName());
            IContainer parent = resource.getParent();
            this.folderText.setText(parent == null ? "" : parent.getFullPath().toString().substring(1));
        }
        int line = -1;
        String loc = "";
        if (attrs != null) {
            Object o4 = attrs.get("lineNumber");
            if (o4 instanceof Integer) {
                line = (Integer)o4;
            }
            if ((o4 = attrs.get("location")) instanceof String) {
                loc = (String)o4;
            }
        }
        if (this.locationText != null) {
            this.locationText.setText(MarkerUtil.getLineAndLocation(line, loc));
        }
        this.markDirty();
    }

    protected void okPressed() {
        this.saveChanges();
        super.okPressed();
    }

    private void markDirty() {
        this.dirty = true;
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private boolean isEditable() {
        return this.marker == null || MarkerUtil.isEditable(this.marker);
    }

    private boolean isTask() {
        return this.marker == null || MarkerUtil.isMarkerType(this.marker, "org.eclipse.core.resources.taskmarker");
    }

    private void saveChanges() {
        if (!this.isEditable() || !this.isDirty()) {
            return;
        }
        final CoreException[] coreExceptions = new CoreException[1];
        final Map attrs = this.getMarkerAttributesFromDialog();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                TaskPropertiesDialog.access$200(2.access$100(this.this$1), monitor, 2.access$000(this.this$1));
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        coreExceptions[0] = e;
                    }
                }

                static /* synthetic */ Map access$000(2 x0) {
                    return x0.attrs;
                }

                static /* synthetic */ TaskPropertiesDialog access$100(2 x0) {
                    return x0.TaskPropertiesDialog.this;
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            return;
        }
        catch (InterruptedException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            return;
        }
        if (coreExceptions[0] != null) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.getString("TaskProp.errorMessage"), null, (IStatus)coreExceptions[0].getStatus());
        }
    }

    private void createOrUpdateMarker(IProgressMonitor monitor, Map attrs) throws CoreException {
        monitor.beginTask(TaskListMessages.getString("TaskPropertiesDialog.WorkingOnMarker"), 100);
        if (this.marker == null) {
            monitor.subTask(TaskListMessages.getString("TaskPropertiesDialog.CreatingMarker"));
            IResource resource = this.getResource();
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            monitor.worked(25);
            this.marker = resource.createMarker("org.eclipse.core.resources.taskmarker");
            Map initialAttrs = this.getInitialAttributes();
            if (initialAttrs != null) {
                this.marker.setAttributes(initialAttrs);
            }
            monitor.worked(25);
        } else {
            monitor.worked(50);
        }
        monitor.subTask(TaskListMessages.getString("TaskPropertiesDialog.UpdatingAttributes"));
        int increment = 50 / attrs.keySet().size();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object val = attrs.get(key);
            this.marker.setAttribute(key, val);
            monitor.worked(increment);
        }
        monitor.done();
    }

    private Map getMarkerAttributesFromDialog() {
        HashMap<String, Object> attribs = new HashMap<String, Object>(11);
        if (this.isTask()) {
            attribs.put("message", this.descriptionText.getText());
            int i = this.priorityCombo.getSelectionIndex();
            if (i != -1) {
                attribs.put("priority", new Integer(2 - i));
            }
            attribs.put("done", this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE);
        }
        return attribs;
    }

    static /* synthetic */ void access$200(TaskPropertiesDialog x0, IProgressMonitor x1, Map x2) throws CoreException {
        x0.createOrUpdateMarker(x1, x2);
    }
}

