import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import java.util.*;
import java.io.*;

public class JavaBib implements ActionListener, WindowListener {
    private static boolean m_Debug;
    Hashtable m_Lists; // hash to store lists
    int m_Untitled; // number of untitled windows
    Integer m_Focus; // track who has the focus
    Clipboard m_Clipboard; // program clipboard
    Properties m_Props; // program properties
    Rectangle m_Bounds; // bounds for screen display
    String[] m_FileList; // history list of files
    private static final int HISTORY_SIZE = 10;

    public static void main(String args[]) {
        m_Debug = false;
        // just create a new entity and pass control to it
        JavaBib jb = new JavaBib();
        jb.init(args);
    }

    // init, process passed parameters
    public void init(String[] args) {
        // create a hashtable, with the key as the file name, for
        // a new list item
        m_Lists = new Hashtable();
        m_Props = new Properties();
        m_Bounds = new Rectangle();
        m_FileList = new String[HISTORY_SIZE];
        readProperties(".JavaBibrc");
        m_Untitled = 0;
        ListFrame lf = new ListFrame(this);
        lf.addWindowListener(this);
        lf.setBounds(m_Bounds);
        // need to add to hash to make sure we are here for focus events
        Integer num = new Integer(lf.getFrameNumber());
        m_Lists.put(num, lf);
        m_Focus = num;
        // set the window visible
        lf.setVisible(true);
        // file name only arguement
        String fname = null;
        if(args.length > 0) {
            fname = args[0];}
        else {
            fname = requestFileName();}
        // exit if no file name given
        if(fname == null) {
            lf.setVisible(false);
            m_Lists.remove(num);
            System.exit(0);}
        // have a file name, open it
        ((ListFrame)m_Lists.get(num)).openFile(fname);
        // add to list of file names
        addFileHistory(fname);
        // update menus
        updateWindowList();
        // declare a new clipboard, if needed
        if(m_Clipboard == null) m_Clipboard = lf.getToolkit().getSystemClipboard();
    }

    /**
     Read the properties file, and then set some critical components from
     the properties read in.
     */
    public void readProperties(String fileName) {
        // open the stream and read the properties
        m_Props = new Properties();
        try {
            try {
                m_Props.load(new FileInputStream(fileName));}
            catch(FileNotFoundException e) {
                debug(e.toString());}}
        catch(IOException e) {
            debug(e.toString());}
        // set some objects according to properties or defaults
        m_Bounds = new Rectangle();
        m_Bounds.x = Integer.valueOf(m_Props.getProperty("x", "0")).intValue();
        m_Bounds.y = Integer.valueOf(m_Props.getProperty("y", "0")).intValue();
        m_Bounds.height = Integer.valueOf(m_Props.getProperty("height", "450")).intValue();
        m_Bounds.width = Integer.valueOf(m_Props.getProperty("width", "680")).intValue();
        // get the file history
        for(int i=0; i<m_FileList.length; i++) {
            String propName = "File" + String.valueOf(i);
            if(m_Props.getProperty(propName) == null) break;
            m_FileList[i] = m_Props.getProperty(propName);}
        // done
    }

    /**
     Write the properties.  The properties are read from the window with the
     focus and writen to the passed file.
     */
    public void writeProperties(String fileName) {
        // set bounds in property object
        m_Props.put("x", String.valueOf(m_Bounds.x));
        m_Props.put("y", String.valueOf(m_Bounds.y));
        m_Props.put("height", String.valueOf(m_Bounds.height));
        m_Props.put("width", String.valueOf(m_Bounds.width));
        // add file history to the properties
        for(int i=0; i<m_FileList.length; i++) {
            String propName = "File" + String.valueOf(i);
            if(m_FileList[i] == null) break;
            m_Props.put(propName, m_FileList[i]);}
        // write the properies
        try {
            m_Props.save(new FileOutputStream(fileName), "JavaBib Properties");}
        catch(FileNotFoundException e) {
            debug(e.toString());}
    }

    /**
     Add a file name to the list of file names in the history
     */
    public void addFileHistory(String name) {
        // dump everything into a vector
        Vector temp = new Vector();
        for(int i=0; i<m_FileList.length; i++) {
            temp.addElement(m_FileList[i]);}
        // remove name from list if it is already there
        temp.remove(name);
        // insert element at beginning
        temp.insertElementAt(name, 0);
        // move everything back into a string array
        m_FileList = new String[HISTORY_SIZE];
        for(int i=0; i<Math.min(m_FileList.length, temp.size()); i++) {
            m_FileList[i] = (String)temp.elementAt(i);}
    }

    /**
     process action events passed back to here.  Note, we will need
     to track window events too to see who has the focus.
     */
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if(src instanceof MenuItem) {
            // get a string representing parent and menu item
            String label = ((Menu)((MenuItem)src).getParent()).getLabel()
                + "->" + ((MenuItem)src).getLabel();
            if(label.equals("File->Close")) {
                // check to see if final changes are to be kept
                if(!((ListFrame)m_Lists.get(m_Focus)).processEntryUpdate(null)) return;
                // do the closing
                closeWindow(m_Focus);}
            if(label.equals("File->Exit")) {
                // enumerate through all the windows.  Last one will force exit
                Enumeration enum = m_Lists.keys();
                while(enum.hasMoreElements()) {
                    Integer key = (Integer)enum.nextElement();
                    // check to see if final changes are to be kept
                    if(!((ListFrame)m_Lists.get(key)).processEntryUpdate(null)) return;
                    // wrote or rejected changes, close
                    closeWindow(key);}}
            if(label.equals("File->Open")) {
                // create a new frame with listener
                ListFrame lf = new ListFrame(this);
                lf.addWindowListener(this);
                // for focus references
                Integer num = new Integer(lf.getFrameNumber());
                m_Lists.put(num, lf);
                // get a file name for this window
                String fName = requestFileName();
                if(fName != null) {
                    // add frame to array and open file
                    ((ListFrame)m_Lists.get(num)).openFile(fName);
                    ((ListFrame)m_Lists.get(num)).setBounds(m_Bounds);
                    addFileHistory(fName);
                    // set the window visible
                    lf.setVisible(true);
                    // update the window list
                    updateWindowList();}
                else {
                    // hide the window
                    m_Lists.remove(num);
                    lf.setVisible(false);}}
            if(label.startsWith("Window")) {
                // asking to switch windows
                String wName = label.substring(8); // drop 'Window->'
                Enumeration enum = m_Lists.keys();
                while(enum.hasMoreElements()) {
                    Integer num = (Integer)enum.nextElement();
                    if(wName.equals(((ListFrame)m_Lists.get(num))
                                    .getFileName())) {
                        // found the window which matches, now need to
                        // activate it.
                        ((ListFrame)m_Lists.get(num)).toFront();}}}
            // check to see if a copy is requested
            if(label.equals("Records->Copy")) {
                // get the string from the active list frame
                String recs = ((ListFrame)m_Lists.get(m_Focus))
                    .getSelectedRecords();
                // put it on the clipboard
                if(recs != null) {
                    StringSelection ss = new StringSelection(recs);
                    m_Clipboard.setContents(ss, (ListFrame)m_Lists.get(m_Focus));}}
            // check to see if a copy is requested
            if(label.equals("Records->Cut")) {
                // warn user that records will be deleted permanently
                if(!AskDialog.createAskDialog("Selected records will be permanently deleted.",
                                              "Continue", "Cancel",
                                              (ListFrame)m_Lists.get(m_Focus))) return;
                // get the string from the active list frame
                String recs = ((ListFrame)m_Lists.get(m_Focus))
                    .getSelectedRecords();
                // put it on the clipboard
                if(recs != null) {
                    StringSelection ss = new StringSelection(recs);
                    m_Clipboard.setContents(ss, (ListFrame)m_Lists.get(m_Focus));
                    // end by deleting the selected records
                    ((ListFrame)m_Lists.get(m_Focus)).deleteSelected();}}
            // if a paste, dump the clipboard contents
            if(label.equals("Records->Paste")) {
                // check to see if final changes are to be kept
                if(!((ListFrame)m_Lists.get(m_Focus)).processEntryUpdate(null)) return;
                // just dump the clipboard
                Transferable contents = m_Clipboard.getContents((ListFrame)m_Lists.get(m_Focus));
                if(contents != null) {
//                    debug(contents.toString());
                    if(contents instanceof StringSelection) {
                        String data = null;
                        // got a string selection object, read the data
                        try{
                            try{
                                data = (String)((StringSelection)contents).getTransferData(DataFlavor.stringFlavor);}
                            catch(UnsupportedFlavorException e) {
                                debug(e.toString());}}
                        catch(IOException e) {
                            debug(e.toString());}
                        // should have the data now
                        if(data != null) {
                            // put it into a string reader
                            StringReader sr = new StringReader(data);
                            // pass the reader to the active frame
                            ((ListFrame)m_Lists.get(m_Focus)).addRecords(sr);}
                    }
                }
            }
        }
    }

    /**
     Make the window menu.  Go through the hash of windows, taking
     out the file names and adding them to a menu.  This
     menu is then added to the list frame.
     */
    public void updateWindowList() {
        Vector names = new Vector();
        // grab all the file names
        Enumeration enum = m_Lists.keys();
        while(enum.hasMoreElements()) {
            ListFrame lf = (ListFrame)m_Lists.get((Integer)enum.nextElement());
            names.addElement(lf.getFileName());}
        // done building, now add it to window.  We need to do this to
        // all of them!!
        enum = m_Lists.keys();
        while(enum.hasMoreElements()) {
            // build a menu item from the vector
            Menu m = new Menu("Window");
            Enumeration e2 = names.elements();
            while(e2.hasMoreElements()) {
                MenuItem mi = new MenuItem((String)e2.nextElement());
                mi.addActionListener(this);
                m.add(mi);}
            // now add the menu to the frame
            ((ListFrame)m_Lists.get((Integer)enum.nextElement()))
                .setWindowMenu(m);}
    }

    /**
     Request a file name from the user.
     */
    public String requestFileName() {
        // get a file name from the user
        String fileName = null;
        boolean flag = true;
        while(flag) {
            flag = false;
            StartDialog sd = new StartDialog(((ListFrame)m_Lists.get(m_Focus)),
                                             "Access BibTeX File");
            sd.setFileOptions(m_FileList);
            sd.setVisible(true);
            if(sd.getFileName() == null) return null;
            fileName = sd.getFileName();
            // fix the file name, so that it points to a bib file
            if(fileName.endsWith(".bdx")) {
                fileName = fileName.substring(0, fileName.length() - 4) + ".bib";}
            if(!fileName.endsWith(".bib")) {
                fileName = fileName + ".bib";}
            // check to see if this file is already open
            Enumeration enum = m_Lists.keys();
            while(enum.hasMoreElements()) {
                ListFrame lf = (ListFrame)m_Lists.get((Integer)enum.nextElement());
                debug(lf.getFileName() + ", " + fileName);
                if(fileName.equals(lf.getFileName())) {
                    flag = true; // stay in the loop
                    OKDialog.createOKDialog("Each BibTeX file may only have one active window.",
                                           ((ListFrame)m_Lists.get(m_Focus)));}}}
        return fileName;
    }

    /**
     Close a window, and kill the program if last window closed
     */
    public void closeWindow(Integer num) {
        // close the file
        ((ListFrame)m_Lists.get(num)).closeFile();
        // get the bounds, in case we are done
        m_Bounds = ((ListFrame)m_Lists.get(num)).getBounds();
        // hide the window
        ((ListFrame)m_Lists.get(num)).setVisible(false);
        // remove list from the hash
        m_Lists.remove(num);
        // update the window list
        updateWindowList();
        // check to see if program is done
        if(m_Lists.isEmpty()) {
            writeProperties(".JavaBibrc");
            System.exit(0);}
    }

    public void windowClosed(WindowEvent evt) {}
    public void windowClosing(WindowEvent evt) {
        // get the number for the source
        Integer num = new Integer(((ListFrame)evt.getSource()).getFrameNumber());
        // do the closing
        debug("closing " + m_Focus.toString());
        closeWindow(num);
    }
    public void windowDeiconified(WindowEvent evt) {}
    public void windowDeactivated(WindowEvent evt) {}
    public void windowIconified(WindowEvent evt) {}
    public void windowOpened(WindowEvent evt) {}
    public void windowActivated(WindowEvent evt) {
        // get the focus number
        m_Focus =  new Integer(((ListFrame)evt.getSource()).getFrameNumber());
        debug("focus = " + m_Focus.toString());
    }

    /**
     Method to output a string when a debug flag is set
     */
    public static void debug(String message)
    {
        if(m_Debug) System.out.println("JavaBib:"+message);}

    /**
     Method to set the debug flag
     */
    public static void setDebug(boolean flag) {m_Debug = flag;}
}

