/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf.windows;

import com.jgoodies.clearlook.ClearLookManager;
import com.jgoodies.clearlook.ClearLookMode;
import com.sun.java.swing.plaf.windows.WindowsScrollPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;

public final class ExtWindowsScrollPaneUI
extends WindowsScrollPaneUI {
    private static final Border DEBUG_ETCHED_BORDER = new BorderUIResource(new LineBorder(Color.yellow));
    private Border storedBorder;
    private boolean hasCheckedBorderReplacement = false;
    private boolean hasCheckedTopLevelContainer = false;
    private boolean hasEtchedBorder = false;
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent b) {
        return new ExtWindowsScrollPaneUI();
    }

    protected void installDefaults(JScrollPane scrollPane) {
        super.installDefaults(scrollPane);
        this.installEtchedBorder(scrollPane);
    }

    protected void installEtchedBorder(JScrollPane scrollPane) {
        Object value = scrollPane.getClientProperty("jgoodies.isEtched");
        if (Boolean.TRUE.equals(value)) {
            LookAndFeel.installBorder(scrollPane, "ScrollPane.etchedBorder");
            this.hasEtchedBorder = true;
        }
    }

    protected void installListeners(JScrollPane scrollPane) {
        super.installListeners(scrollPane);
        this.listener = this.createBorderStyleListener();
        scrollPane.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners(JComponent c) {
        ((JScrollPane)c).removePropertyChangeListener(this.listener);
        super.uninstallListeners(c);
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("jgoodies.isEtched")) {
                    JScrollPane scrollPane = (JScrollPane)e.getSource();
                    ExtWindowsScrollPaneUI.this.installEtchedBorder(scrollPane);
                }
            }
        };
    }

    public void paint(Graphics g, JComponent c) {
        if (this.hasEtchedBorder) {
            super.paint(g, c);
            return;
        }
        if (!this.hasCheckedBorderReplacement) {
            this.storedBorder = ClearLookManager.replaceBorder(c);
            this.hasCheckedBorderReplacement = true;
        }
        if (!this.hasCheckedTopLevelContainer && this.storedBorder == null) {
            ClearLookMode mode = ClearLookManager.getMode();
            JScrollPane scrollPane = (JScrollPane)c;
            Component viewportView = scrollPane.getViewport().getView();
            if (mode.isEnabled() && !(viewportView instanceof JTable) && this.isInFrame(c)) {
                if (mode.isDebug()) {
                    c.setBorder(DEBUG_ETCHED_BORDER);
                } else {
                    LookAndFeel.installBorder(this.scrollpane, "ScrollPane.etchedBorder");
                }
                if (mode.isVerbose()) {
                    ClearLookManager.log("Set scrollpane border nested in JFrame to etched.");
                }
            }
            this.hasCheckedTopLevelContainer = true;
        }
        super.paint(g, c);
    }

    protected void uninstallDefaults(JScrollPane scrollPane) {
        if (this.storedBorder != null) {
            scrollPane.setBorder(this.storedBorder);
        }
        super.uninstallDefaults(scrollPane);
    }

    private boolean isInFrame(JComponent c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (p instanceof JFrame || p instanceof JInternalFrame) {
                return true;
            }
            if (!(p instanceof JDialog)) continue;
            return false;
        }
        return false;
    }
}

