/* strmisc.h 2.9.0 92/07/06  */
/* Copyright (C) 1991 Damian Cugley */

#ifndef strmisc_h_
#define strmisc_h_

#ifndef addr
#  include "stdc.h"
#endif

#ifdef BSD
#  define strchr	index
#  define strrchr	rindex
#endif

char *	strcpy	ARGS((char *, const char *));
char *	strncpy	ARGS((char *, const char *, card));
char *	strcat	ARGS((char *, const char *));
char *	strncat	ARGS((char *, const char *, card));
char *	strchr	ARGS((const char *, int));
char *	strrchr ARGS((const char *, int));
int 	strcmp	ARGS((const char *, const char *));
int 	strncmp	ARGS((const char *, const char *, card));
card 	strlen	ARGS((const char *));
long	strtol 	ARGS((const char *, char **, int));

#ifdef BSD
void 	bcopy 	ARGS((const_addr, addr, card));
void 	bzero 	ARGS((addr, card));
#else
addr	memcpy	ARGS((addr, const_addr, card));
addr	memset	ARGS((addr, int, card));
#define bcopy(S,D,N)	memcpy((D),(S),(N))
#define bzero(D,N)	memset((D),0,(N))     
#endif

/*
 * Now my string routines, which are much more fun
 */

char *	stritem ARGS((char *str, int, char **sp));
/*
 *  stritem is used to parse a string as a seq. of items
 *  separated by a particular character -- usually ','.
 *  State is stored into *sp.
 */
     
char *	strword ARGS((char *str, char **sp));
/*
 *  strword is used to parse a string as a seq. of words separated
 *  by whitespace characters.
 *
 *  The first call should have |str| and |sp| both non-null.  It starts
 *  scanning at str and stores state in |sp|.  Subsequent calls
 *  should have |str| NULL so that the state stored in |sp| is used.
 *
 *  Spaces are incorporated into words with double quote characters only. 
 *  To incorporate a " char in a quoted word, use two:
 *  		" wibble""wobble"  ->  [SPC]wibble"wobble
 *  Quote chars inside words *not* started with a quotes are ordinary 
 *  characters.
 *
 *  <string> ::= { <space> <word> } <space>.
 *  <space>  ::= { <space-char> }.
 *  <word> ::= " { <space-char> | <ord-char> | "" } "
 *          |  <ord-char> { <ord-char> | " }.
 *
 *  <space-char> is space, tab, newline etc.  
 *  <ord-char> is anything not a <space-char> or ".
 */

char *	strdup ARGS((const char *));
/*  make a malloc'd copy of a string  */

addr xmalloc ARGS((sizeof_t));
addr xrealloc ARGS((addr, sizeof_t));

#ifndef xpg2
void	xfree ARGS((addr));
#else
#define xfree free
#endif

#ifndef NULL
#  define NULL	0		/* should always be cast */
#endif

#endif
