/*  xstdio.h 2.9.0 92/07/06 -- standard IO header file plus prototypes */

/*
 *  This file is intended to get around the problem of
 *  using GNU C on a system that doesn't have ANSI C header files.
 *  I've taken it out of stdc.h because I want stdc.h to still be
 *  useful when I write non-stdio programs (as I very occasionally do).
 * - Damian Cugley <pdc@prg.ox.ac.uk> Mon. 17 June 1991
 */

#ifndef MFF_xstdio_H
#define MFF_xstdio_H

/*
 *  attempt to avoid loading the system header file more than once
 *  -- on some systems this seems to cause an error because NULL is redefined.
 */
#ifndef BUFSIZ
#  include <stdio.h>
#endif

#ifndef ARGS
#  include "stdc.h"
#endif

#ifdef NEEDPROTO

int	printf ARGS((const char *, ...));
int	fprintf ARGS((FILE *, const char *, ...));
int	puts ARGS((const char *));
int	fputs ARGS((const char *, FILE *));
int	fputc ARGS((int, FILE *));
int	ungetc ARGS((int, FILE *));
int	fclose ARGS((FILE *));
void	rewind ARGS((FILE *));
int	fflush ARGS((FILE *));	/* EOF on error */
int	putw ARGS((int, FILE *));
int	getw ARGS((FILE *));
int 	fwrite ARGS((addr, sizeof_t, int, FILE *));     
int 	fread ARGS((addr, sizeof_t, int, FILE *));     
int	setvbuf ARGS((FILE *, char *, int, sizeof_t));
     
/*
 *  functions used in the putc and getc macros in stdio.h
 *  I need to declare them if only to shut GCC up.
 *  I think they apply to BSD and System V systems at least.
 */
#ifndef NO_FLSBUF
int	_flsbuf ARGS((int, FILE *));
int	_filbuf ARGS((FILE *));
#endif
  
#endif /* NEEDPROTO */


/*
 *  Plus one extra routine:
 */
char *	fgetword ARGS((char *buf, FILE *fp));


#endif /*  MFF_xstdio_H */
