\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{ncc}
         [2002/04/03 v1.02 NCC-LaTeX document class (NCC)]
%
% \changes{v1.01}{2002/03/24}{This version is uploaded to CTAN}
% \changes{v1.02}{2002/04/03}{Bug in loading book class fixed}
% 
\newcommand*\partmark[1]{}
\newcommand\@ptsize{}
\newif\if@restonecol
\let\@openbib@code\@empty
\gdef\NCC@gempty{}% Global case of \@empty command
%
% \openrightorany clears page or double page depending on openright
% mode selected.
%
\newif\if@openright
\newcommand{\openrightorany}{\clearpage\relax
  \if@openright \if@twoside
    \begingroup\let\leftmark\relax \cleardoublepage\endgroup
  \fi\fi
}
%
% What goes first in title: author or title
%
\newif\ifNCC@authorbeforetitle
\newcommand{\AuthorBeforeTitle}{\NCC@authorbeforetitletrue}
\newcommand{\TitleBeforeAuthor}{\NCC@authorbeforetitlefalse}
\@onlypreamble\AuthorBeforeTitle
\@onlypreamble\TitleBeforeAuthor
%
% \SetTOCStyle{STYLE} sets a TOC style
%
\newcommand*{\SetTOCStyle}[1]{\def\NCC@tocstyle{#1}}
\SetTOCStyle{}
\@onlypreamble\SetTOCStyle
%
% Paper size options
%
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{a5a4paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\DeclareOption{fittopage}{}
%
% Base font size options
%
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\DeclareOption{14pt}{\renewcommand\@ptsize{4}\ExecuteOptions{small}}
%
% Layout options
%
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{openany}{\@openrightfalse}
\DeclareOption{openright}{\@openrighttrue}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
%
% Special openbib option
%
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
    \newdimen\bibindent
    \setlength\bibindent{1.5em}%
    \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
%
% Math layout
%
\DeclareOption{fleqn}{\PassOptionsToPackage{\CurrentOption}{nccmath}}
\DeclareOption{leqno}{\PassOptionsToPackage{\CurrentOption}{nccmath}}
%
% Small headings in sections (always used in 14pt size)
%
\DeclareOption{small}{\PassOptionsToPackage{\CurrentOption}{ncclatex}}
%
\newcommand*{\setyear}[1]{\gdef\theyear{#1}}
\newcommand\theyear{\number\year}
%
% Subclass selection options
%
\DeclareOption{article}{%
  \def\NCC@clsload{%
    \TitleBeforeAuthor
    \input{nccart.clo}%
    \newcommand*{\setseries}[1]{\gdef\theseries{##1}}%
    \newcommand*{\setvolume}[1]{\gdef\thevolume{##1}}%
    \newcommand*{\setissue}[1]{\gdef\theissue{##1}}%
    \setseries{}\setvolume{}\setissue{}%
    \AtEndDocument{%
      \clearpage
      \if@filesw \advance\c@page\m@ne
        \immediate\write\@mainaux{\string\newlabel
          {NCC@lastpage}{{}{\thepage}}}%
        \advance\c@page\@ne
      \fi
      \openrightorany
    }%
    \pagestyle{myheadings}%
    \countstyle{}%
    \InputIfFileExists{nccadd.sty}{}{}%
  }%
  \let\chapter\relax
  \let\thechapter\relax
}
\DeclareOption{preprint}{%
  \def\NCC@clsload{%
    \AuthorBeforeTitle
    \input{nccart.clo}%
    \let\maketitle\relax    % Remove these commands to allow creating
    \let\abstract\relax     % them with \newcommand.
    \let\endabstract\relax  %
    \input{ncctitle.clo}%
    \newcommand*{\preprint}[1]{\gdef\thepreprint{##1}}%
    \preprint{}%
    \def\NCC@titlecomment{%
      \ifx\thepreprint\NCC@gempty \else
        \vskip 1.5em 
        {\centering\bfseries \preprintname\\[1.5ex] \thepreprint\par}%
      \fi 
    }%
    \pagestyle{headings}%
    \countstyle{}%
  }%
  \let\chapter\relax
  \let\thechapter\relax
}
\DeclareOption{book}{%
  \def\NCC@clsload{%
    \AuthorBeforeTitle
    \input{nccbook.clo}
    \input{ncctitle.clo}%
    \newcommand*\bookeditor[1]{%
      \gdef\NCC@titlecomment{\vskip 1.5em {\centering##1\par}}%
    }%
    \pagestyle{headings}%
    \countstyle{chapter}%
  }%
  \let\chapter\@empty    % nccsect and russianb packages test an existence of
  \let\thechapter\@empty % \thechapter and \chapter to understand what class
}                        % loaded
\DeclareOption{report}{\ExecuteOptions{book,oneside}}
%
% Process options and load size option file
%
\ExecuteOptions{a4paper,10pt,article,twoside,onecolumn,final,openany}
\ProcessOptions\relax
\input{ncc1\@ptsize.clo}
\@ifclasswith{ncc}{fittopage}{\input{nccfit.clo}}{}
%
% Center text on the page taking into account the header only,
% because default NCC-LaTeX style is headings or myheadings and
% marginal notes are useless. The top margin is bounded by 1.5in.
%
\RequirePackage{tocenter}
\ToCenter[h]{\textwidth}{\textheight}
\ifdim\topmargin >.5in \topmargin=.5in \fi
%
% Set list margins
%
\if@twocolumn
  \setlength\leftmargini  {2em}
  \setlength\leftmarginii {1.7em}
  \setlength\leftmarginiii{1.5em}
  \setlength\leftmarginiv {1.2em}
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmargini  {2.5em}
  \setlength\leftmarginii {2.2em}
  \setlength\leftmarginiii{1.87em}
  \setlength\leftmarginiv {1.7em}
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength\labelsep{.5em}
\leftmargin\leftmargini
\def\NCC@labelwidth{\labelwidth\leftmargin\advance\labelwidth-\labelsep}
\NCC@labelwidth
%
% Set enumeration styles
%
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
%
% Set other dimensions, skips, and penalties
%
\if@twocolumn \setlength\parindent{1em}
\else         \setlength\parindent{1.5em}
\fi
\setlength\smallskipamount{3\p@ \@plus \p@ \@minus \p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\maxdepth{.5\topskip}
\setlength\lineskip{\p@}
\setlength\normallineskip{\p@}
\renewcommand\baselinestretch{}
\setlength\columnseprule{0\p@}
\setlength\parskip{\z@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\setcounter{topnumber}{4}
\renewcommand\topfraction{.8}
\setcounter{bottomnumber}{2}
\renewcommand\bottomfraction{.6}
\setcounter{totalnumber}{6}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{4}
\renewcommand\dbltopfraction{.8}
\renewcommand\dblfloatpagefraction{.5}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\def\@dotsep{4.5}
%
% Declare old font selection commands
%
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
%
% Create section counters. We use \countstyle command from dcounter package.
%
\RequirePackage{dcounter}
\newcounter{part} \renewcommand\thepart{\@Roman\c@part}
\ifx\chapter\@empty
  \countstyle[chapter]{}
  \countstyle[section]{chapter}
\else
  \countstyle[section]{}
\fi
\countstyle[subsection]{section}
\countstyle[subsubsection]{subsection}
\countstyle[paragraph]{subsubsection}
\countstyle[subparagraph]{paragraph}
%
% Declare floats
%
\DeclareDynamicCounter{figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\nobreakspace\thefigure}
\newenvironment{figure}{\@float{figure}}{\end@float}
\newenvironment{figure*}{\@dblfloat{figure}}{\end@dblfloat}
\DeclareDynamicCounter{table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\nobreakspace\thetable}
\newenvironment{table}{\@float{table}}{\end@float}
\newenvironment{table*}{\@dblfloat{table}}{\end@dblfloat}
%
% Names of english captions
%
\newcommand\prefacename{Preface}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\bibname{Bibliography}
\newcommand\indexname{Index}
\newcommand\glossaryname{Glossary}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand\seename{see}
\newcommand\alsoname{see also}
\newcommand\preprintname{Preprint}
%
% English version of \today
%
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
%
% Load other packages. The nccmath is loaded before ncclatex to process
% math options. Maybe, it is not needed, but I do this for safety.
%
\RequirePackage{watermark}
\RequirePackage{nccmath}
\RequirePackage{ncclatex}
\RequirePackage{nccold}
\ifNCC@rus \frenchspacing \fi % French spacing in russian typesetting
%
% \noeqbreak supresses page breaks before display equations
% \alloweqbreak allows page breaks before display equations (default)
%
\newcommand\noeqbreak{\predisplaypenalty=\@M}
\newcommand\alloweqbreak{\predisplaypenalty=-\@medpenalty}
\alloweqbreak                 % Break before display formulas is allowed
\allowdisplaybreaks           % Breaks in display formulas are allowed
%
% Verse, quotation, quote. The description is already defined in ncclatex
%
\newenvironment{verse}{%
  \let\\\centercr
  \list{}{\itemsep \z@ \itemindent -1.5em \listparindent\itemindent
          \rightmargin \leftmargin \advance\leftmargin 1.5em}%
  \item\relax
}{\endlist}
\newenvironment{quotation}{%
  \list{}{\listparindent 1.5em \itemindent \listparindent
          \rightmargin \leftmargin \parsep \z@ \@plus \p@}%
  \item\relax
}{\endlist}
\newenvironment{quote}{%
  \list{}{\rightmargin\leftmargin}\item\relax
}{\endlist}
%
% titlepage. \vspace at the top produces correct vertical space.
% We suppose that a title page can contain many pages and many
% title pages inside. The page counter is restored to its
% original value after leaving a top level title page.
%
\newif\ifNCC@intitle \NCC@intitlefalse
\newenvironment{titlepage}{%
  \clearpage
  \if@twocolumn \@restonecoltrue \onecolumn \else \@restonecolfalse \fi
  \ifNCC@intitle 
    \let\NCC@restorepagecount\@empty
  \else 
    \edef\NCC@restorepagecount{%
      \noexpand\global\noexpand\c@page \@arabic\c@page\relax}%
    \setcounter{page}\z@ 
    \c@footnote\z@ \def\thefootnote{\@fnsymbol\c@footnote}%
    \let\@oddhead\relax \let\@evenhead\relax
    \let\@oddfoot\relax \let\@evenfoot\relax
    \NCC@intitletrue
  \fi
  \NCC@null
}{%
  \clearpage \if@restonecol\twocolumn \fi
  \NCC@restorepagecount
}
\def\NCC@null{\par\strut\par\removelastskip \vskip -\baselineskip}
%
% Bibliography without header. It is possible to set starting number
% for bibliography counter.
%
% \begin{biblist}[start number]{prototype} ... \end{biblist}
%
\newcommand{\bibliststyle}{\small}
\newenvironment*{biblist}[2][0]{
  \bibliststyle
  \list{\@biblabel{\@arabic\c@enumiv}}{%
    \settowidth\labelwidth{\@biblabel{#2}}%
    \leftmargin\labelwidth \advance\leftmargin\labelsep \itemsep\parsep
    \@openbib@code
    \usecounter{enumiv}\let\p@enumiv\@empty
    \renewcommand\theenumiv{\@arabic\c@enumiv}%
  }%
  \setcounter{enumiv}{#1}%
   \sloppy \widowpenalty 4000
   \clubpenalty 4000 \@clubpenalty \clubpenalty
   \sfcode`\.\@m
}{\def\@noitemerr{\@latex@warning{Empty `biblist' environment}}%
  \endlist
}
\newcommand{\newblock}{\hskip .11em\@plus .33em\@minus .07em}
%
% Footnote make commands.
%
\renewcommand{\footnoterule}{%
  \kern-3\p@ \hrule\@width .4\columnwidth \kern2.6\p@
}
\newcommand{\@makefntext}[1]{%
  \parindent 1em \noindent
  \hb@xt@ 1.8em{\hss\@makefnmark}#1}
%
% \tableofcontents, \listoffigures, \listoftables
%
% They use the \NCC@tochead{header} command defined later in subclasses
%
\newcommand{\tableofcontents}{\NCC@toc\contentsname{toc}}
\newcommand{\listoffigures}{\NCC@toc\listfigurename{lof}}
\newcommand{\listoftables}{\NCC@toc\listtablename{lot}}
\def\NCC@toc#1#2{%
  \NCC@tochead{#1}%
  \begingroup
    \normalfont \NCC@tocstyle\NCC@setpnum
    \@starttoc{#2}%
  \endgroup
}
%
% theindex and theglossary. They are based on \NCC@idxhead{header}
% defined later in subclasses
%
\newenvironment{theindex}{\NCC@index\indexname}{\endNCC@index}
\newenvironment{theglossary}{\NCC@index\glossaryname}{\endNCC@index}
\newenvironment*{NCC@index}[1]{%
  \if@twocolumn \@restonecolfalse \else \@restonecoltrue \fi
  \columnseprule \z@ \columnsep 35\p@
  \NCC@idxhead{#1}%
  \parindent\z@ \parskip\z@ \@plus .3\p@
  \let\item\@idxitem \small
}{\if@restonecol\onecolumn \else \clearpage\fi}
\newcommand\@idxitem{\par\hangindent 5em}
\newcommand\subitem{\@idxitem \hspace*{2em}}
\newcommand\subsubitem{\@idxitem \hspace*{4em}}
\newcommand\indexspace{\par \addvspace{4ex \@plus 1ex \@minus .5ex}}
%
% \printindex and \printglossary
%
\newcommand\printindex{\@input@{\jobname.ind}}
\newcommand\printglossary{\@input@{\jobname.gls}}
\newcommand*\see[2]{\emph{\seename} #1}
\providecommand*\seealso[2]{\emph{\alsoname} #1}
%
% NCC page style with headings
%
\def\NCC@setpsheading{%
  \let\@oddfoot\@empty\let\@evenfoot\@empty
  \def\@evenhead{%
    \thepage\hfil
    {\small\itshape\ignorespaces\leftmark\unskip}\hfil
  }%
  \def\@oddhead{%
    \hfil{\small\itshape\ignorespaces\rightmark\unskip}\hfil
    \thepage
  }%
  \reset@font
}
\def\NCC@firstmark#1{\markboth{#1}{#1}}
\def\NCC@secondmark#1{\markright{#1}}
%
% Final actions
%
\pagenumbering{arabic}
\NCC@clsload % load specified subclass
\@onlypreamble\NCC@clsload
\if@twocolumn
  \twocolumn \sloppy \flushbottom
\else
  \onecolumn
  \if@twoside \flushbottom \else \raggedbottom \fi
\fi
\endinput
